/*
 * Decompiled with CFR 0.152.
 */
package gcspawners;

import gcspawners.NBTReflectionUtil;
import gcspawners.NBTType;
import gcspawners.ReflectionMethod;
import gcspawners.d.MinecraftVersion;
import java.util.Iterator;
import java.util.Set;

public class NBTCompound {
    private final String c;
    private final NBTCompound d;
    public static int b;
    private static final String[] a;

    protected NBTCompound(NBTCompound nBTCompound, String string) {
        this.c = string;
        this.d = nBTCompound;
    }

    public String getName() {
        return this.c;
    }

    public Object getCompound() {
        return this.d.getCompound();
    }

    protected void setCompound(Object object) {
        this.d.setCompound(object);
    }

    public NBTCompound getParent() {
        return this.d;
    }

    public void setString(String string, String string2) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_STRING, string, string2);
    }

    public String getString(String string) {
        return (String)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_STRING, string);
    }

    protected String getContent(String string) {
        return NBTReflectionUtil.getContent(this, string);
    }

    public void setInteger(String string, Integer n) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INT, string, n);
    }

    public Integer getInteger(String string) {
        return (Integer)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INT, string);
    }

    public void setDouble(String string, Double d) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_DOUBLE, string, d);
    }

    public Double getDouble(String string) {
        return (Double)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_DOUBLE, string);
    }

    public void setByte(String string, Byte by) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTE, string, by);
    }

    public Byte getByte(String string) {
        return (Byte)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTE, string);
    }

    public void setShort(String string, Short s) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_SHORT, string, s);
    }

    public Short getShort(String string) {
        return (Short)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_SHORT, string);
    }

    public void setLong(String string, Long l) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_LONG, string, l);
    }

    public Long getLong(String string) {
        return (Long)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_LONG, string);
    }

    public void setFloat(String string, Float f) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_FLOAT, string, f);
    }

    public Float getFloat(String string) {
        return (Float)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_FLOAT, string);
    }

    public void setByteArray(String string, byte[] byArray) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTEARRAY, string, byArray);
    }

    public byte[] getByteArray(String string) {
        return (byte[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTEARRAY, string);
    }

    public void setIntArray(String string, int[] nArray) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INTARRAY, string, nArray);
    }

    public int[] getIntArray(String string) {
        return (int[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INTARRAY, string);
    }

    public void setBoolean(String string, Boolean bl) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BOOLEAN, string, bl);
    }

    protected void set(String string, Object object) {
        NBTReflectionUtil.set(this, string, object);
    }

    public Boolean getBoolean(String string) {
        return (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BOOLEAN, string);
    }

    public void setObject(String string, Object object) {
        NBTReflectionUtil.setObject(this, string, object);
    }

    public <T> T getObject(String string, Class<T> clazz) {
        return NBTReflectionUtil.getObject(this, string, clazz);
    }

    public Boolean hasKey(String string) {
        Boolean bl = (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_HAS_KEY, string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void removeKey(String string) {
        NBTReflectionUtil.remove(this, string);
    }

    public Set<String> getKeys() {
        return NBTReflectionUtil.getKeys(this);
    }

    public NBTCompound addCompound(String string) {
        if (this.getType(string) == NBTType.NBTTagCompound) {
            return this.getCompound(string);
        }
        NBTReflectionUtil.addNBTTagCompound(this, string);
        return this.getCompound(string);
    }

    public NBTCompound getCompound(String string) {
        NBTCompound nBTCompound = new NBTCompound(this, string);
        if (NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            return nBTCompound;
        }
        return null;
    }

    public NBTType getType(String string) {
        if (MinecraftVersion.init() == MinecraftVersion.MC1_7_R4) {
            return null;
        }
        Object object = NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_TYPE, string);
        if (object == null) {
            return null;
        }
        return NBTType.valueOf(((Byte)object).byteValue());
    }

    public NBTCompound getOrCreateCompound(String string) {
        return this.addCompound(string);
    }

    public String toString() {
        StringBuilder stringBuilder;
        block2: {
            StringBuilder stringBuilder2 = new StringBuilder();
            Iterator<String> iterator = this.getKeys().iterator();
            int n = b;
            while (iterator.hasNext()) {
                String string = iterator.next();
                stringBuilder = stringBuilder2.append(this.toString(string));
                if (n == 0) {
                    if (n == 0) continue;
                }
                break block2;
            }
            stringBuilder = stringBuilder2;
        }
        return stringBuilder.toString();
    }

    public String toString(String string) {
        StringBuilder stringBuilder;
        block3: {
            stringBuilder = new StringBuilder();
            NBTCompound nBTCompound = this;
            int n = b;
            while (nBTCompound.getParent() != null) {
                String[] stringArray = a;
                stringBuilder.append(stringArray[0]);
                nBTCompound = nBTCompound.getParent();
                if (n == 0) {
                    if (n == 0) continue;
                }
                break block3;
            }
            if (this.getType(string) == NBTType.NBTTagCompound) {
                return this.getCompound(string).toString();
            }
        }
        return stringBuilder + "-" + string + a[2] + this.getContent(string) + System.lineSeparator();
    }

    public String asNBTString() {
        Object object = NBTReflectionUtil.gettoCompount(this.getCompound(), this);
        if (object == null) {
            return a[1];
        }
        return object.toString();
    }

    public void clearNBT() {
        Iterator<String> iterator = this.getKeys().iterator();
        int n = b;
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.removeKey(string);
            if (n == 0) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        String[] stringArray = new String[3];
        int n = 0;
        String string = "H@\u0015\u0002\u0013\u001d\u0002R@";
        int n2 = "H@\u0015\u0002\u0013\u001d\u0002R@".length();
        int n3 = 3;
        int n4 = -1;
        while (true) {
            int n5 = ++n4;
            stringArray[n++] = NBTCompound.a(NBTCompound.a(string.substring(n5, n5 + n3)));
            if ((n4 += n3) >= n2) {
                a = stringArray;
                return;
            }
            n3 = string.charAt(n4);
        }
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x57);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(char[] cArray) {
        char[] cArray2;
        block11: {
            int n;
            int n2;
            block10: {
                cArray2 = cArray;
                n2 = cArray.length;
                n = 0;
                if (!true) break block10;
                n2 = n2;
                if (n2 <= n) break block11;
            }
            do {
                int n3;
                cArray2 = cArray2;
                int n4 = n;
                char c = cArray2[n4];
                switch (n % 7) {
                    case 0: {
                        n3 = 104;
                        break;
                    }
                    case 1: {
                        n3 = 96;
                        break;
                    }
                    case 2: {
                        n3 = 53;
                        break;
                    }
                    case 3: {
                        n3 = 105;
                        break;
                    }
                    case 4: {
                        n3 = 42;
                        break;
                    }
                    case 5: {
                        n3 = 72;
                        break;
                    }
                    default: {
                        n3 = 87;
                    }
                }
                cArray2[n4] = (char)(c ^ n3);
                ++n;
                n2 = n2;
            } while (n2 > n);
        }
        return new String(cArray2).intern();
    }
}

