/*
 * Decompiled with CFR 0.152.
 */
package gcspawners.a;

import gcspawners.CustomEntityHandler;
import gcspawners.CustomEntityInstance;
import gcspawners.CustomEntityPunchEvent;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.MetadataValue;

public class CustomEntityPunchListener
implements Listener {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler
    public void onDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof ArmorStand)) {
            return;
        }
        if (entityDamageByEntityEvent.getCause().equals((Object)EntityDamageEvent.DamageCause.VOID) || entityDamageByEntityEvent.getEntity().getCustomName() == null || entityDamageByEntityEvent.getEntity().getCustomName().isEmpty()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        if (!livingEntity.hasMetadata(CustomEntityHandler.getMetadataKey())) {
            return;
        }
        entityDamageByEntityEvent.setCancelled(true);
        Entity entity = entityDamageByEntityEvent.getDamager();
        CustomEntityInstance customEntityInstance = null;
        try {
            customEntityInstance = CustomEntityHandler.getCustomEntityHandler().matchEntity(UUID.fromString(((MetadataValue)livingEntity.getMetadata(CustomEntityHandler.getMetadataKey()).get(0)).asString()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (customEntityInstance == null) {
            return;
        }
        CustomEntityPunchEvent customEntityPunchEvent = new CustomEntityPunchEvent(entity, customEntityInstance);
        customEntityPunchEvent.setDamage(entityDamageByEntityEvent.getDamage());
        customEntityPunchEvent.setFinalDamage(entityDamageByEntityEvent.getFinalDamage());
        customEntityPunchEvent.setCause(entityDamageByEntityEvent.getCause());
        customEntityPunchEvent.setEvent(entityDamageByEntityEvent);
        Bukkit.getPluginManager().callEvent((Event)customEntityPunchEvent);
    }
}

