/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.advancedplugins.at.api.ATAPI;
import net.advancedplugins.at.commands.AdvancedTradesCommand;
import net.advancedplugins.at.editor.TradeEditorHandler;
import net.advancedplugins.at.handlers.TradesHandler;
import net.advancedplugins.at.listeners.ChatListener;
import net.advancedplugins.at.listeners.FButtonClick;
import net.advancedplugins.at.listeners.VillagerOpenEvent;
import net.advancedplugins.at.listeners.VillagerTradeEvent;
import net.advancedplugins.at.listeners.VillagerTradesPopulator;
import net.advancedplugins.at.utils.ConfigItemCreator;
import net.advancedplugins.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Core
extends JavaPlugin {
    private static Core instance;
    private static TradesHandler tradesHandler;
    private static TradeEditorHandler tradeEditorHandler;
    private String lastId = "";
    private String serverUUID;
    private boolean again = false;

    public void onEnable() {
        Core.loadConfig0();
        instance = this;
        MinecraftVersion.init();
        if (MinecraftVersion.getVersionNumber() < 1160) {
            this.getLogger().severe("AdvancedTrades requires Minecraft Version 1.16 or higher to work.");
            this.getLogger().severe("Plugin will now disable.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", "type");
        hashMap.put("id", "id");
        hashMap.put("amount", "amount");
        hashMap.put("name", "name");
        hashMap.put("lore", "lore");
        hashMap.put("item-flags", "item-flags");
        hashMap.put("custom-model-data", "custom-model-data");
        hashMap.put("force-glow", "force-glow");
        hashMap.put("enchantments", "enchantments");
        hashMap.put("rgb-color", "rgb-color");
        hashMap.put("nbt", "nbt");
        ConfigItemCreator.setDefaultPaths(hashMap);
        this.init();
        tradeEditorHandler = new TradeEditorHandler();
        Bukkit.getPluginManager().registerEvents((Listener)new VillagerTradesPopulator(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new VillagerTradeEvent(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new VillagerOpenEvent(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new FButtonClick(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)this);
        this.getCommand("advancedtrades").setExecutor((CommandExecutor)new AdvancedTradesCommand());
        this.lastId = ATAPI.get();
        new BukkitRunnable(){

            public void run() {
                try {
                    InputStream inputStream;
                    String string = ATAPI.get();
                    if (string == null) {
                        Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                    }
                    if (!ATAPI.get().equalsIgnoreCase(string)) {
                        Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                    }
                    if ((inputStream = instance.getResource(".key")) != null) {
                        try {
                            int n;
                            String string2 = (String)new BufferedReader(new InputStreamReader(inputStream)).lines().iterator().next();
                            if (string2.length() != 32) {
                                Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                            }
                            Core.this.lastId = string2;
                            Core.this.serverUUID = UUID.randomUUID().toString();
                            int n2 = Bukkit.getOnlinePlayers().size();
                            String string3 = "https://v2.advancedplugins.net/auth/handshake.php?token=%token%&server=%serverUUID%&playerCount=%playerCount%";
                            string3 = string3.replace("%token%", string2);
                            string3 = string3.replace("%serverUUID%", Core.this.serverUUID);
                            string3 = string3.replace("%playerCount%", Integer.toString(n2));
                            URL uRL = new URL(string3);
                            URLConnection uRLConnection = uRL.openConnection();
                            uRLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                            InputStream inputStream2 = uRLConnection.getInputStream();
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            byte[] byArray = new byte[16384];
                            while ((n = inputStream2.read(byArray, 0, byArray.length)) != -1) {
                                byteArrayOutputStream.write(byArray, 0, n);
                            }
                            Gson gson = new Gson();
                            String string4 = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
                            Map map = (Map)gson.fromJson(string4, Map.class);
                            Double d = (Double)map.get("code");
                            if (d == 1.0) {
                                Core.this.again = true;
                                AdvancedTradesCommand.name = "pluginLoaded";
                            } else {
                                Bukkit.getLogger().warning("[AdvancedTrades] " + map.get("message"));
                                Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                        }
                        return;
                    }
                    if (Core.this.lastId.isEmpty() && string.isEmpty()) {
                        Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                    }
                    if (string.length() > 7) {
                        Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                    }
                    try {
                        Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                    }
                    Core.this.lastId = string;
                    String string5 = "http://servers.advancedmarket.co/at/api.php?&userId=%id%&minecraftVersion=%mc%&atVersion=%ae%&re=%re%&playerCount=%playerCount%";
                    try {
                        int n;
                        string5 = string5.replace("%mc%", MinecraftVersion.getCurrentVersion().name() + "");
                        string5 = string5.replace("%ae%", "0");
                        string5 = string5.replace("%id%", string + "");
                        string5 = string5.replace("%re%", Core.this.again + "");
                        string5 = string5.replace("%playerCount%", Bukkit.getOnlinePlayers().size() + "");
                        URL uRL = new URL(string5);
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                        InputStream inputStream3 = uRLConnection.getInputStream();
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray = new byte[16384];
                        while ((n = inputStream3.read(byArray, 0, byArray.length)) != -1) {
                            byteArrayOutputStream.write(byArray, 0, n);
                        }
                        String string6 = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
                        int n3 = Integer.parseInt(string6.replaceAll("[^0-9]", ""));
                        switch (n3) {
                            case 1: {
                                Core.this.again = true;
                                AdvancedTradesCommand.name = "pluginLoaded";
                                return;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                Bukkit.getLogger().info("[AdvancedTrades] Could not initialise plugin, are you using Vault?");
                                Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                                return;
                            }
                            case 4: {
                                Bukkit.getLogger().warning("[AdvancedTrades] Could not initialise plugin, contact developer with code 126");
                                Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                                return;
                            }
                            case 5: {
                                Bukkit.getLogger().warning("[AdvancedTrades] Your license exceeded maximum number of unique IPs. Contact the developer for an enterprise license or connect using previously used IPs.");
                                Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                                return;
                            }
                        }
                    }
                    catch (Exception exception) {
                        Bukkit.getLogger().warning("[AdvancedTrades] Failed to connect to remote server, is your firewall configured properly?");
                        Core.this.again = true;
                        AdvancedTradesCommand.name = "pluginLoaded";
                        return;
                    }
                    Bukkit.getLogger().warning("[AdvancedTrades] Could not initialise plugin, contact developer with code 002, your ID: " + string);
                    Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Bukkit.getPluginManager().disablePlugin((Plugin)instance);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this, 0L, 36000L);
        if (!ATAPI.get().equalsIgnoreCase(this.lastId)) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public boolean init() {
        try {
            this.saveDefaultConfig();
            tradesHandler = new TradesHandler(this);
        }
        catch (Exception exception) {
            Core.getInstance().getLogger().severe("Failed to load configuration for trades.");
            exception.printStackTrace();
            if (tradesHandler == null) {
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
            }
            return false;
        }
        if (!this.lastId.isEmpty()) {
            this.reloadConfig();
        }
        return true;
    }

    public static TradeEditorHandler getTradeEditorHandler() {
        return tradeEditorHandler;
    }

    public static TradesHandler getTradesHandler() {
        return tradesHandler;
    }

    public void onDisable() {
    }

    public static Core getInstance() {
        return instance;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=997807&resource_id=96589&nonce=-386498300").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

