/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.commands;

import joptsimple.internal.Strings;
import net.advancedplugins.at.Core;
import net.advancedplugins.at.handlers.CustomTradesVillager;
import net.advancedplugins.at.trading.AdvancedTrade;
import net.advancedplugins.at.utils.fanciful.FancyMessage;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdvancedTradesCommand
implements CommandExecutor {
    public static String name;
    private final String _prefix = "&d[AdvancedTrades]&r";

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!name.equalsIgnoreCase("pluginLoaded")) {
            return false;
        }
        if (stringArray.length == 0 || stringArray[0].equalsIgnoreCase("help")) {
            this.displayHelpMenu(commandSender, stringArray);
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("reload")) {
            if (!this.checkPermission("advancedtrades.reload", commandSender)) {
                return true;
            }
            commandSender.sendMessage(this.color("&d[AdvancedTrades]&r Reloading all configuration..."));
            boolean bl = Core.getInstance().init();
            if (bl) {
                commandSender.sendMessage(this.color("&d[AdvancedTrades]&r &aReloaded all configuration successfully"));
            } else {
                commandSender.sendMessage(this.color("&d[AdvancedTrades]&r &cReload was unsuccessful. &oThere are errors displayed in console."));
                commandSender.sendMessage(this.color("&d[AdvancedTrades]&r &cCheck your configuration first before reporting issues."));
            }
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("editor")) {
            if (!this.checkPermission("advancedtrades.editor", commandSender)) {
                return true;
            }
            Core.getTradeEditorHandler().startEditor(((Player)commandSender).getUniqueId());
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("spawnVillager")) {
            if (!this.checkPermission("advancedtrades.spawnVillager", commandSender)) {
                return true;
            }
            if (!(commandSender instanceof Player)) {
                return false;
            }
            if (stringArray.length < 2) {
                commandSender.sendMessage(this.color("&d[AdvancedTrades]&r Example usage of this command:"));
                commandSender.sendMessage(this.color("&d[AdvancedTrades]&r /at spawnVillager trade1,customTrade,myTrade,other-trade true"));
                return true;
            }
            boolean bl = stringArray.length < 3 || !Boolean.parseBoolean(stringArray[2]);
            Player player = (Player)commandSender;
            CustomTradesVillager customTradesVillager = new CustomTradesVillager(player.getLocation());
            customTradesVillager.setAI(bl);
            customTradesVillager.addTrades(stringArray[1].split(","));
            try {
                customTradesVillager.populateVillager();
            }
            catch (RuntimeException runtimeException) {
                player.sendMessage(this.color("&d[AdvancedTrades]&r Invalid custom villager request! Details are available below and in console:"));
                player.sendMessage(this.color("&d[AdvancedTrades]&r &c" + runtimeException.getMessage()));
                runtimeException.printStackTrace();
            }
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("list")) {
            if (!this.checkPermission("advancedtrades.list", commandSender)) {
                return true;
            }
            commandSender.sendMessage(this.color("&d[AdvancedTrades]&r List of all available custom trades:"));
            int n = 1;
            for (AdvancedTrade advancedTrade : Core.getTradesHandler().getTrades()) {
                new FancyMessage(this.color(" &8#" + n + " &d" + advancedTrade.getTradeName() + " ")).tooltip(this.color("&dTrade Chance: &7" + advancedTrade.getTradeSettings().getChance()), this.color("&dMax uses: &7" + advancedTrade.getTradeSettings().getMaxTradeUses()), this.color("&dRequired villager level: &7" + advancedTrade.getTradeSettings().getRequiredVillagerLevel()), this.color("&dRequired Professions: &7" + Strings.join(advancedTrade.getTradeSettings().getRequiredProfession(), (String)", ")), this.color("&dRequired Biomes: &7" + Strings.join(advancedTrade.getTradeSettings().getRequiredBiome(), (String)", "))).send(commandSender);
                ++n;
            }
            commandSender.sendMessage(this.color("&7* TIP: You can hover over trades to see more information."));
            return true;
        }
        this.displayHelpMenu(commandSender, stringArray);
        return true;
    }

    private boolean checkPermission(String string, CommandSender commandSender) {
        if (commandSender.isOp() || !(commandSender instanceof Player) || commandSender.hasPermission(string)) {
            return true;
        }
        commandSender.sendMessage(this.color("&d[AdvancedTrades]&r &cYou do not have permission to access this command."));
        return false;
    }

    private void displayHelpMenu(CommandSender commandSender, String[] stringArray) {
        new FancyMessage(this.color("&f[<] &8+-------< &d&lAdvancedTrades &f(Page 1/1) &8>-------+ &f[>]")).send(commandSender);
        new FancyMessage(" ").send(commandSender);
        new FancyMessage(this.color("  &f/at reload &7- &dReload configuration")).suggest("/at reload").tooltip(this.color("&8 &dDesc: &7Reload configuration"), this.color("&8 &dPermission: &7at.reload"), this.color("&8 &dUsage: &7/at reload")).send(commandSender);
        new FancyMessage(this.color("  &f/at list &7- &dList all custom trades")).suggest("/at list").tooltip(this.color("&8 &dDesc: &7List all custom trades"), this.color("&8 &dPermission: &7at.list"), this.color("&8 &dUsage: &7/at list")).send(commandSender);
        new FancyMessage(this.color("  &f/at spawnVillager &2<trades list...> &9[disableAi] &7- &dSpawn a villager with custom trades")).suggest("/at spawnVillager [trades list...]").tooltip(this.color("&8 &dDesc: &7Spawn a villager with custom trades"), this.color("&8 &dPermission: &7at.spawnVillager"), this.color("&8 &dUsage: &7/at spawnVillager trade1,customTrade true")).send(commandSender);
        new FancyMessage(" ").send(commandSender);
        new FancyMessage(this.color("  &2<> &f- Required Arguments&7; &9[] &f- Optional Arguments")).send(commandSender);
        new FancyMessage(" ").send(commandSender);
        new FancyMessage(this.color("&7* TIP: You can hover/click commands to see more information.")).send(commandSender);
        new FancyMessage(this.color("&f[<] &8+-------< &d&lAdvancedTrades &f(Page 1/1) &8>-------+ &f[>]")).send(commandSender);
    }

    private String color(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

