/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.editor.gui;

import net.advancedplugins.at.editor.TradeEditorHandler;
import net.advancedplugins.at.editor.events.EditorClickEvent;
import net.advancedplugins.at.editor.gui.EditorEditItem;
import net.advancedplugins.at.editor.gui.EditorMainMenu;
import net.advancedplugins.at.editor.requests.ChatInputRequest;
import net.advancedplugins.at.editor.requests.ChatInputType;
import net.advancedplugins.at.editor.state.EditorMenu;
import net.advancedplugins.at.editor.state.EditorState;
import net.advancedplugins.at.settings.TradeSetting;
import net.advancedplugins.at.utils.ItemBuilder;
import net.advancedplugins.utils.ASManager;
import net.advancedplugins.utils.nbt.NBTapi;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class EditorEditTrade
extends EditorMenu {
    private static EditorMenu instance;

    public EditorEditTrade(JavaPlugin javaPlugin) {
        super(javaPlugin);
        instance = this;
        this.setInvName("&aEditing Trade Settings");
    }

    @Override
    public void onEditorClick(EditorClickEvent editorClickEvent) {
        Player player = editorClickEvent.getPlayer();
        ItemStack itemStack = editorClickEvent.getCurrentItem();
        String string = NBTapi.get("action", itemStack);
        String string2 = NBTapi.get("editValue", itemStack);
        if (string != null && !string.isEmpty()) {
            if (string.equalsIgnoreCase("menu")) {
                EditorMainMenu.open(player);
                TradeEditorHandler.getHandler().endEditor(player.getUniqueId());
            } else if (string.equalsIgnoreCase("stop")) {
                player.closeInventory();
                TradeEditorHandler.getHandler().endEditor(player.getUniqueId());
            }
            if (string.equalsIgnoreCase("close")) {
                player.closeInventory();
                return;
            }
            return;
        }
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        TradeSetting tradeSetting = TradeSetting.valueOf(string2);
        ChatInputType chatInputType = tradeSetting.getChatInputType();
        editorClickEvent.getState().setTradeSetting(tradeSetting);
        if (chatInputType.equals((Object)ChatInputType.EDIT_TRADE_INGREDIENT) || chatInputType.equals((Object)ChatInputType.EDIT_TRADE_RESULT)) {
            EditorEditItem.open(player);
            return;
        }
        if (editorClickEvent.getClick() == ClickType.RIGHT) {
            player.sendMessage(EditorEditTrade.color("&a&l(!) &aWiki article link: &f" + tradeSetting.getWikiLink()));
            player.closeInventory();
            return;
        }
        Object object = tradeSetting.getDefaultValue();
        editorClickEvent.getState().addChatRequest(new ChatInputRequest(player.getUniqueId(), chatInputType, "&eSet new " + tradeSetting.getName() + " setting value &7(Current Value: " + object + ")\n&e \u2b50 &7Description: &f" + tradeSetting.getDescription() + "\n&a \u2b50 &7Example: &f" + tradeSetting.getExample() + "\n&d \u2b50 &7Wiki link: &f" + tradeSetting.getWikiLink()));
        player.closeInventory();
    }

    public static void open(Player player) {
        int n;
        Inventory inventory = Bukkit.createInventory(null, (int)18, (String)EditorEditTrade.color(instance.getInvName()));
        EditorState editorState = TradeEditorHandler.getHandler().getState(player.getUniqueId());
        for (n = 0; n < 9; ++n) {
            inventory.setItem(n, new ItemStack(ASManager.matchMaterial("STAINED_GLASS_PANE", 1, 15)));
        }
        for (n = 9; n < 18; ++n) {
            inventory.setItem(n, ASManager.matchMaterial("THIN_GLASS", 1, 0));
        }
        n = 0;
        for (TradeSetting tradeSetting : TradeSetting.values()) {
            Object object = editorState.getTradeInstance().getSetting(tradeSetting);
            if (object == null) continue;
            inventory.setItem(n, NBTapi.addNBTTag("editValue", tradeSetting.name(), new ItemBuilder(ASManager.matchMaterial(tradeSetting.getMaterial().name(), n + 1, 0)).setName(EditorEditTrade.color("&eTrade Setting: &a" + tradeSetting.getName())).addLoreLine(EditorEditTrade.color("&7- &f" + tradeSetting.getDescription())).addLoreLine(EditorEditTrade.color("&7- &eCurrent Value: &7" + object)).addLoreLine(EditorEditTrade.color("")).addLoreLine(EditorEditTrade.color("&e(!) &7&oLeft-Click&7 to edit value")).addLoreLine(EditorEditTrade.color("&e(!) &7&oRight-Click&7 to view wiki article")).toItemStack()));
            ++n;
        }
        inventory.setItem(inventory.getSize() - 5, NBTapi.addNBTTag("action", "menu", new ItemBuilder(Material.IRON_DOOR).setName(EditorEditTrade.color("&eGo back to main menu")).addLoreLine(EditorEditTrade.color("&7Your changes are automatically saved")).toItemStack()));
        inventory.setItem(inventory.getSize() - 2, NBTapi.addNBTTag("action", "stop", new ItemBuilder(Material.BARRIER).setName(EditorEditTrade.color("&eStop editing this trade")).addLoreLine(EditorEditTrade.color("&7Your changes are automatically saved")).toItemStack()));
        player.openInventory(inventory);
    }
}

