/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.editor.gui;

import net.advancedplugins.at.Core;
import net.advancedplugins.at.editor.TradeEditorHandler;
import net.advancedplugins.at.editor.events.EditorClickEvent;
import net.advancedplugins.at.editor.requests.ChatInputRequest;
import net.advancedplugins.at.editor.requests.ChatInputType;
import net.advancedplugins.at.editor.state.EditorMenu;
import net.advancedplugins.at.editor.state.EditorState;
import net.advancedplugins.at.trading.AdvancedTrade;
import net.advancedplugins.at.utils.ItemBuilder;
import net.advancedplugins.at.utils.SkullCreator;
import net.advancedplugins.utils.nbt.NBTapi;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class EditorMainMenu
extends EditorMenu
implements Listener {
    private static EditorMenu menu;

    public EditorMainMenu(JavaPlugin javaPlugin) {
        super(javaPlugin);
        menu = this;
        this.setInvName("&aTrades Editor");
    }

    @Override
    public void onEditorClick(EditorClickEvent editorClickEvent) {
        Player player = editorClickEvent.getPlayer();
        ItemStack itemStack = editorClickEvent.getCurrentItem();
        int n = editorClickEvent.getSlot();
        String string = NBTapi.get("action", itemStack);
        if (string == null || string.isEmpty()) {
            String string2 = NBTapi.get("edit", itemStack);
            if (string2 == null) {
                return;
            }
            player.closeInventory();
            TradeEditorHandler.getHandler().startEditor(player.getUniqueId()).setTrade(string2);
            return;
        }
        if (string.equalsIgnoreCase("close")) {
            player.closeInventory();
        } else if (!string.equalsIgnoreCase("next") && !string.equalsIgnoreCase("back") && string.equalsIgnoreCase("create")) {
            TradeEditorHandler.getHandler().startEditor(player.getUniqueId()).setTrade(null);
            EditorState editorState = TradeEditorHandler.getHandler().getState(player.getUniqueId());
            editorState.addChatRequest(new ChatInputRequest(player.getUniqueId(), ChatInputType.RENAME_TRADE, "&eSet new trade name!"));
            player.closeInventory();
        }
    }

    public static void open(Player player) {
        int n = Core.getTradesHandler().getTrades().size();
        Inventory inventory = Bukkit.createInventory(null, (int)menu.getResponsiveInventorySize(n + 9), (String)menu.getInvName());
        for (AdvancedTrade advancedTrade : Core.getTradesHandler().getTrades()) {
            Object object;
            try {
                ItemStack itemStack = advancedTrade.getTradeResult().getConfigItem().clone();
                object = new ItemBuilder(itemStack == null || itemStack.getType().equals((Object)Material.AIR) ? new ItemStack(Material.matchMaterial((String)"BARRIER")) : itemStack);
                ((ItemBuilder)object).setName(EditorMainMenu.color("&eEdit &7" + advancedTrade.getTradeName()));
                ((ItemBuilder)object).addLoreLine(EditorMainMenu.color(""));
                ((ItemBuilder)object).addLoreLine(EditorMainMenu.color("&8- &eChance: &7" + advancedTrade.getTradeSettings().getChance()));
                ((ItemBuilder)object).addLoreLine(EditorMainMenu.color("&8- &eRequired Level: &7" + advancedTrade.getTradeSettings().getRequiredVillagerLevel()));
                ((ItemBuilder)object).addLoreLine(EditorMainMenu.color("&8- &eReq. Professions: &7" + StringUtils.join(advancedTrade.getTradeSettings().getRequiredProfession(), (String)", ")));
                ((ItemBuilder)object).addLoreLine(EditorMainMenu.color("&8- &eReq. Biomes: &7" + StringUtils.join(advancedTrade.getTradeSettings().getRequiredBiome(), (String)", ")));
                ((ItemBuilder)object).addLoreLine(EditorMainMenu.color("&8- &eExcld. Worlds: &7" + StringUtils.join(advancedTrade.getTradeSettings().getExcludedWorlds(), (String)", ")));
                ((ItemBuilder)object).addLoreLine(EditorMainMenu.color(""));
                ((ItemBuilder)object).addLoreLine(EditorMainMenu.color("&e(!) &7&oLeft-Click&7 to edit"));
                inventory.addItem(new ItemStack[]{NBTapi.addNBTTag("edit", advancedTrade.getTradeName(), ((ItemBuilder)object).toItemStack())});
            }
            catch (Exception exception) {
                object = "\ufffdcFailed to open editor for trade " + advancedTrade.getTradeName() + "! This is a configuration issue.";
                player.sendMessage((String)object);
                Core.getInstance().getLogger().warning((String)object);
                exception.printStackTrace();
            }
        }
        EditorMainMenu.initControls(inventory, menu);
        inventory.setItem(inventory.getSize() - 2, NBTapi.addNBTTag("action", "create", new ItemBuilder(Material.CRAFTING_TABLE).setName(EditorMainMenu.color("&aCreate a new Trade")).toItemStack()));
        player.openInventory(inventory);
    }

    static void initControls(Inventory inventory, EditorMenu editorMenu) {
        for (int i = inventory.getSize() - 9; i < inventory.getSize(); ++i) {
            inventory.setItem(i, new ItemBuilder(Material.GLASS_PANE).setName(" ").toItemStack());
        }
        inventory.setItem(inventory.getSize() - 6, NBTapi.addNBTTag("action", "back", new ItemBuilder(SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmQ2OWUwNmU1ZGFkZmQ4NGU1ZjNkMWMyMTA2M2YyNTUzYjJmYTk0NWVlMWQ0ZDcxNTJmZGM1NDI1YmMxMmE5In19fQ")).setName(EditorMainMenu.color("&8<< &6Previous Page")).toItemStack()));
        inventory.setItem(inventory.getSize() - 5, NBTapi.addNBTTag("action", "close", new ItemBuilder(Material.ANVIL).setName(EditorMainMenu.color("&6Close the page.")).toItemStack()));
        inventory.setItem(inventory.getSize() - 4, NBTapi.addNBTTag("action", "next", new ItemBuilder(SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTliZjMyOTJlMTI2YTEwNWI1NGViYTcxM2FhMWIxNTJkNTQxYTFkODkzODgyOWM1NjM2NGQxNzhlZDIyYmYifX19")).setName(EditorMainMenu.color("&8>> &6Next Page")).toItemStack()));
    }
}

