/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.editor.state;

import net.advancedplugins.at.Core;
import net.advancedplugins.at.editor.events.EditorClickEvent;
import net.advancedplugins.at.editor.state.EditorState;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EditorMenu
implements Listener {
    private String invName = "";

    public EditorMenu(JavaPlugin javaPlugin) {
        javaPlugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
    }

    public String getInvName() {
        return this.invName;
    }

    public void setInvName(String string) {
        this.invName = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    @EventHandler
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getClickedInventory() == null || inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        String string = inventoryClickEvent.getView().getTitle();
        if (!string.equalsIgnoreCase(this.getInvName())) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        EditorState editorState = Core.getTradeEditorHandler().getState(player.getUniqueId());
        EditorClickEvent editorClickEvent = new EditorClickEvent(inventoryClickEvent.getView(), inventoryClickEvent.getSlotType(), inventoryClickEvent.getSlot(), inventoryClickEvent.getClick(), inventoryClickEvent.getAction());
        editorClickEvent.setCancelled(true);
        editorClickEvent.setState(editorState);
        editorClickEvent.setPlayer(player);
        this.onEditorClick(editorClickEvent);
        if (!editorClickEvent.isCancelled()) {
            inventoryClickEvent.setCancelled(false);
        }
    }

    public void onEditorClick(EditorClickEvent editorClickEvent) {
    }

    public int getResponsiveInventorySize(int n) {
        if (n <= 9) {
            return 9;
        }
        int n2 = n;
        if ((double)n / 9.0 > 0.0) {
            n2 = n / 9 * 9 + 9;
        }
        return Math.min(n2, 54);
    }

    public static String color(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

