/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.advancedplugins.at.Core;
import net.advancedplugins.at.trading.AdvancedTrade;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.MerchantRecipe;

public class CustomTradesVillager {
    private final Villager villager;
    private boolean ai = true;
    private List<String> trades = new ArrayList<String>();

    public CustomTradesVillager(Villager villager) {
        this.villager = villager;
    }

    public CustomTradesVillager(Location location) {
        this.villager = (Villager)location.getWorld().spawnEntity(location, EntityType.VILLAGER);
    }

    public void addTrades(String ... stringArray) {
        this.trades.addAll(Arrays.asList(stringArray));
    }

    public void addTrades(List<String> list) {
        this.trades.addAll(list);
    }

    public void addTrade(String string) {
        this.trades.add(string);
    }

    public void setAI(boolean bl) {
        this.ai = bl;
    }

    public void populateVillager() {
        ArrayList<MerchantRecipe> arrayList = new ArrayList<MerchantRecipe>();
        if (this.trades.isEmpty()) {
            throw new RuntimeException("Trade list is empty!");
        }
        for (String string : this.trades) {
            AdvancedTrade advancedTrade = Core.getTradesHandler().getAdvancedTrade(string);
            if (advancedTrade == null) {
                throw new RuntimeException("Trade " + string + " is invalid!");
            }
            MerchantRecipe merchantRecipe = new MerchantRecipe(advancedTrade.getTradeResult().getConfigItem(), 0, advancedTrade.getTradeSettings().getMaxTradeUses().intValue(), true, advancedTrade.getTradeResult().getVillagerExperience(), 1.0f);
            advancedTrade.getTradeIngredients().getItems().forEach(arg_0 -> ((MerchantRecipe)merchantRecipe).addIngredient(arg_0));
            arrayList.add(merchantRecipe);
        }
        this.villager.setProfession(Villager.Profession.LIBRARIAN);
        this.villager.setVillagerExperience(1);
        this.villager.setRecipes(arrayList);
        this.villager.setAI(this.ai);
    }
}

