/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import net.advancedplugins.at.Core;
import net.advancedplugins.at.trading.AdvancedTrade;
import org.bukkit.block.Biome;
import org.bukkit.entity.Villager;

public class TradeBuilder {
    private Villager.Profession villagerProfession;
    private int villagerLevel;
    private Biome biome;
    private String world;

    public TradeBuilder setVillagerLevel(int n) {
        this.villagerLevel = n;
        return this;
    }

    public TradeBuilder setBiome(Biome biome) {
        this.biome = biome;
        return this;
    }

    public TradeBuilder setWorld(String string) {
        this.world = string;
        return this;
    }

    public TradeBuilder setVillagerProfession(Villager.Profession profession) {
        this.villagerProfession = profession;
        return this;
    }

    public AdvancedTrade build() {
        ArrayList<AdvancedTrade> arrayList = new ArrayList<AdvancedTrade>((Collection<AdvancedTrade>)Core.getTradesHandler().getTrades());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AdvancedTrade advancedTrade = (AdvancedTrade)iterator.next();
            if (advancedTrade.getTradeSettings().getRequiredVillagerLevel() > 0 && advancedTrade.getTradeSettings().getRequiredVillagerLevel() != this.villagerLevel) {
                iterator.remove();
                continue;
            }
            if (!advancedTrade.getTradeSettings().getRequiredBiome().isEmpty() && !advancedTrade.getTradeSettings().getRequiredBiome().contains((Object)this.biome.name().toLowerCase(Locale.ROOT))) {
                iterator.remove();
                continue;
            }
            if (!advancedTrade.getTradeSettings().getExcludedWorlds().isEmpty() && advancedTrade.getTradeSettings().getExcludedWorlds().contains((Object)this.world.toLowerCase(Locale.ROOT))) {
                iterator.remove();
                continue;
            }
            if (advancedTrade.getTradeSettings().getRequiredProfession().isEmpty() || advancedTrade.getTradeSettings().getRequiredProfession().contains((Object)this.villagerProfession.name().toLowerCase(Locale.ROOT))) continue;
            iterator.remove();
        }
        return Core.getTradesHandler().getRandomTrade(arrayList);
    }
}

