/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.handlers;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class TradesFile {
    private final String fileName;
    private final File tradesFile;
    private final FileConfiguration configuration = new YamlConfiguration();

    public TradesFile(JavaPlugin javaPlugin) {
        this.fileName = "trades.yml";
        this.tradesFile = new File(javaPlugin.getDataFolder(), this.fileName);
        if (!this.tradesFile.exists()) {
            javaPlugin.saveResource("trades.yml", true);
        }
        this.loadConfiguration(javaPlugin);
    }

    private void loadConfiguration(JavaPlugin javaPlugin) {
        try {
            this.configuration.load(this.tradesFile);
        }
        catch (Exception exception) {
            javaPlugin.getLogger().severe("Failed to load trades.yml file. Check if there are any configuration issues first.");
            exception.printStackTrace();
        }
    }

    public void saveFile() {
        try {
            this.configuration.save(this.tradesFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        return this.configuration;
    }
}

