/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.settings;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.advancedplugins.at.Core;
import net.advancedplugins.at.editor.requests.ChatInputType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;

public enum TradeSetting {
    CHANCE("tradeSettings.chance", "Chance of villager acquiring this trade", 5, "https://trades.advancedplugins.net/trades/how-to-create-custom-trades#2.-trade-settings-configuration", Material.REPEATER, ChatInputType.EDIT_CHANCE),
    REQUIRED_VILLAGER_LEVEL("tradeSettings.requiredVillagerLevel", "Required villager level", "none", "https://trades.advancedplugins.net/trades/levels", Material.VILLAGER_SPAWN_EGG, ChatInputType.EDIT_REQUIRED_VILLAGER_LEVEL),
    REQUIRED_PROFESSION("tradeSettings.requiredProfession", "Required villager profession", Arrays.asList("none"), "https://trades.advancedplugins.net/trades/professions", Material.LECTERN, ChatInputType.EDIT_REQUIRED_PROFESSION),
    REQUIRED_BIOME("tradeSettings.requiredBiome", "Required villager's biome for this trade", Arrays.asList("none"), "https://trades.advancedplugins.net/trades/biomes", Material.GRASS_BLOCK, ChatInputType.EDIT_REQUIRED_BIOME),
    MAX_TRADE_USES("tradeSettings.maxTradeUses", "Trade limit per villager", "none", "https://trades.advancedplugins.net/trades/limits", Material.REDSTONE, ChatInputType.EDIT_MAX_TRADE_USES),
    EXPERIENCE("tradeResult.villager.experience", "Experience gained by villager with this trade", 5, "https://trades.advancedplugins.net/trades/levels", Material.EXPERIENCE_BOTTLE, ChatInputType.EDIT_EXPERIENCE),
    TRADE_INGREDIENTS("tradeIngredients", "Items required for a trade", null, "https://trades.advancedplugins.net/trades/how-to-create-custom-trades#3.-trade-ingredients-configuration", Material.CRAFTING_TABLE, ChatInputType.EDIT_TRADE_INGREDIENT),
    TRADE_RESULT("tradeResult", "Items gained with a trade", null, "https://trades.advancedplugins.net/trades/how-to-create-custom-trades#4.-trade-result-configuration", Material.CHEST, ChatInputType.EDIT_TRADE_RESULT),
    NONE(null, null, null, null, null, null);

    private final String path;
    private final String description;
    private final Object defaultValue;
    private final Material material;
    private final String wikiLink;
    private final ChatInputType chatInputType;

    private TradeSetting(String string2, String string3, Object object, String string4, Material material, ChatInputType chatInputType) {
        this.path = string2;
        this.description = string3;
        this.defaultValue = object;
        this.wikiLink = string4;
        this.material = material;
        this.chatInputType = chatInputType;
    }

    public String getPath() {
        return this.path;
    }

    public ChatInputType getChatInputType() {
        return this.chatInputType;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getWikiLink() {
        return this.wikiLink;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getBoolean() {
        return Core.getInstance().getConfig().getBoolean(this.path, ((Boolean)this.defaultValue).booleanValue());
    }

    public String getString() {
        return Core.getInstance().getConfig().getString(this.path, (String)this.defaultValue);
    }

    public int getInt() {
        return Core.getInstance().getConfig().getInt(this.path, ((Integer)this.defaultValue).intValue());
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void set(Object object) {
    }

    public String getName() {
        return StringUtils.capitalize((String)this.name().toLowerCase(Locale.ROOT).replaceAll("_", " "));
    }

    public String getInstanceOf() {
        if (this.defaultValue instanceof Integer) {
            return "int";
        }
        if (this.defaultValue instanceof String) {
            return "string";
        }
        if (this.defaultValue instanceof Boolean) {
            return "boolean";
        }
        if (this.defaultValue instanceof List) {
            return "list";
        }
        return "null";
    }

    public String getExample() {
        switch (this.getInstanceOf()) {
            case "int": {
                return "1";
            }
            case "string": {
                return "example text";
            }
            case "boolean": {
                return "true";
            }
            case "list": {
                return "[firstValue, second value, third value]";
            }
        }
        return "Check wiki: https://trades.advancedplugins.net/";
    }
}

