/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.trading.options;

import java.util.Collections;
import java.util.List;
import net.advancedplugins.at.utils.AManager;
import net.advancedplugins.at.utils.ConfigItemCreator;
import net.advancedplugins.utils.nbt.NBTapi;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TradeResult {
    private final int villagerExperience;
    private ItemStack configItem;
    private final List<String> commandReward;
    private final String tradeName;

    public TradeResult(String string, ConfigurationSection configurationSection) {
        this.tradeName = string;
        this.villagerExperience = AManager.parseInt(configurationSection.get("villager.experience").toString());
        this.configItem = ConfigItemCreator.fromConfigSection("trades.yml", "trades." + string + ".tradeResult.item", Collections.emptyMap(), Collections.emptyMap());
        this.commandReward = configurationSection.getStringList("commands");
        if (!this.commandReward.isEmpty()) {
            this.configItem = NBTapi.addNBTTag("commandReward", string, this.configItem);
        }
        this.addIdentifierToItem();
    }

    private void addIdentifierToItem() {
        if (this.configItem == null) {
            throw new NullPointerException("Invalid reward for trade " + this.tradeName);
        }
        this.configItem = NBTapi.addNBTTag("tradeIdentifier", this.tradeName, this.configItem);
    }

    public List<String> getCommandReward() {
        return this.commandReward;
    }

    public ItemStack getConfigItem() {
        return this.configItem;
    }

    public int getVillagerExperience() {
        return this.villagerExperience;
    }

    public void playRewards(Player player) {
        this.getCommandReward().forEach(string -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string.replace("%player%", player.getName())));
    }
}

