/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.advancedplugins.at.Core;
import net.advancedplugins.at.utils.EnchantUtils;
import net.advancedplugins.at.utils.ItemBuilder;
import net.advancedplugins.at.utils.MathUtils;
import net.advancedplugins.utils.ColorUtils;
import net.advancedplugins.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;

public class ConfigItemCreator {
    private static HashMap<String, String> cfgPaths = null;

    public static void setDefaultPaths(HashMap<String, String> hashMap) {
        cfgPaths = hashMap;
    }

    public static ItemStack fromConfigSection(String string, String string2, Map<String, String> map, Map<String, String> map2) {
        String string3;
        int n;
        String[] stringArray;
        List<String> list;
        Material material;
        Object object2;
        File file = new File(Core.getInstance().getDataFolder().getAbsolutePath() + File.separator + string);
        if (!file.exists()) {
            ConfigItemCreator.sendError("Unknown file!", string, null, null);
            return new ItemStack(Material.AIR);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Map map3 = (Map)cfgPaths.clone();
        if (map2 != null && !map2.isEmpty()) {
            object2 = map2.entrySet().iterator();
            while (object2.hasNext()) {
                material = object2.next();
                map3.put(material.getKey(), material.getValue());
            }
        }
        if ((material = Material.matchMaterial((String)(object2 = ConfigItemCreator.format(yamlConfiguration.getString(string2 + "." + (String)map3.get("type"), null), map)))) == null) {
            ConfigItemCreator.sendError("Specified material doesn't exist!", string, string2, object2);
            return new ItemStack(Material.AIR);
        }
        byte by = (byte)yamlConfiguration.getInt(string2 + "." + (String)map3.get("id"));
        byte by2 = (byte)MathUtils.clamp(yamlConfiguration.getInt(string2 + "." + (String)map3.get("amount"), 1), 1, 64);
        ItemBuilder itemBuilder = new ItemBuilder(material, by2, by);
        if (yamlConfiguration.contains(string2 + "." + (String)map3.get("name"))) {
            list = ConfigItemCreator.format(yamlConfiguration.getString(string2 + "." + (String)map3.get("name"), " "), map);
            itemBuilder.setName((String)((Object)list));
        }
        if (yamlConfiguration.contains(string2 + "." + (String)map3.get("lore"))) {
            list = ConfigItemCreator.format(yamlConfiguration.getStringList(string2 + "." + (String)map3.get("lore")), map);
            itemBuilder.setLore(list);
        }
        list = ConfigItemCreator.format(yamlConfiguration.getStringList(string2 + "." + (String)map3.get("item-flags")), map);
        for (String object3 : list) {
            boolean bl = false;
            stringArray = object3.toUpperCase(Locale.ROOT);
            for (ItemFlag itemFlag : ItemFlag.values()) {
                if (!itemFlag.name().equals(stringArray)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                ConfigItemCreator.sendError("Specified ItemFlag doesn't exist!", string, string2, object3);
                continue;
            }
            itemBuilder.addItemFlag(ItemFlag.valueOf((String)object3));
        }
        if (MinecraftVersion.getVersionNumber() >= 1140 && yamlConfiguration.contains(string2 + "." + (String)map3.get("custom-model-data"))) {
            int n2 = yamlConfiguration.getInt(string2 + "." + (String)map3.get("custom-model-data"));
            itemBuilder.setCustomModelData(n2);
        }
        if (yamlConfiguration.contains(string2 + "." + (String)map3.get("force-glow"))) {
            boolean bl = yamlConfiguration.getBoolean(string2 + "." + (String)map3.get("force-glow"));
            itemBuilder.setGlowing(bl);
        }
        List<String> list2 = ConfigItemCreator.format(yamlConfiguration.getStringList(string2 + "." + (String)map3.get("enchantments")), map);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Enchantment enchantment;
            String string4 = (String)iterator.next();
            stringArray = string4.split(":");
            String string5 = stringArray[0];
            n = 1;
            if (stringArray.length > 1) {
                if (!MathUtils.isShort(stringArray[1])) {
                    ConfigItemCreator.sendError("Specified vanilla enchantment level not valid! Must be between -32768 & 32767.", string, string2, stringArray[2]);
                } else {
                    n = Short.parseShort(stringArray[1]);
                }
            }
            if ((enchantment = EnchantUtils.argsToEnchant(string5)) == null) {
                ConfigItemCreator.sendError("Specified vanilla enchantment doesn't exist!", string, string2, string5);
                continue;
            }
            itemBuilder.addUnsafeEnchantment(enchantment, n);
        }
        if ((((String)object2).contains("LEATHER_") || ((String)object2).contains("FIREWORK_STAR")) && (string3 = ConfigItemCreator.format(yamlConfiguration.getString(string2 + "." + (String)map3.get("rgb-color")), map)) != null) {
            String[] stringArray2 = string3.split(";");
            if (stringArray2.length != 3) {
                ConfigItemCreator.sendError("RGB color must contain 3 values in the format \"255;255;255\"!", string, string2, string3);
                return new ItemStack(Material.AIR);
            }
            if (!(MathUtils.isInteger(stringArray2[0]) && MathUtils.isInteger(stringArray2[1]) && MathUtils.isInteger(stringArray2[2]))) {
                ConfigItemCreator.sendError("RGB values must be between 0-255!", string, string2, stringArray2[0]);
                return new ItemStack(Material.AIR);
            }
            int n2 = MathUtils.clamp(Integer.parseInt(stringArray2[0]), 0, 255);
            int n3 = MathUtils.clamp(Integer.parseInt(stringArray2[1]), 0, 255);
            n = MathUtils.clamp(Integer.parseInt(stringArray2[2]), 0, 255);
            Color color = Color.fromRGB((int)n2, (int)n3, (int)n);
            if (((String)object2).contains("LEATHER_")) {
                itemBuilder.setColor(color);
            } else if (((String)object2).contains("FIREWORK_STAR")) {
                ItemFlag itemFlag;
                itemFlag = (FireworkEffectMeta)itemBuilder.getItemMeta();
                itemFlag.setEffect(FireworkEffect.builder().withColor(color).build());
            }
        }
        ItemStack itemStack2 = itemBuilder.toItemStack();
        itemStack2 = ConfigItemCreator.addNbt((FileConfiguration)yamlConfiguration, string2, itemStack2, map3);
        return itemStack2;
    }

    private static String format(String string, Map<String, String> map) {
        string = ConfigItemCreator.placeholders(string, map);
        string = ColorUtils.format(string);
        return string;
    }

    private static List<String> format(List<String> list, Map<String, String> map) {
        list = ConfigItemCreator.placeholders(list, map);
        list = ColorUtils.format(list);
        return list;
    }

    private static String placeholders(String string, Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                string = string.replace(entry.getKey(), entry.getValue());
            }
        }
        return string;
    }

    private static List<String> placeholders(List<String> list, Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (map != null) {
            for (String string : list) {
                if ((string = ConfigItemCreator.placeholders(string, map)).contains("\n")) {
                    String[] stringArray = string.split("\\n");
                    String string2 = "";
                    for (String string3 : stringArray) {
                        arrayList.add(string2 + string3);
                        string2 = ColorUtils.getLastColor(string3);
                    }
                    continue;
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private static String addPunctuation(String string) {
        boolean bl;
        boolean bl2 = bl = string.endsWith(".") || string.endsWith("!") || string.endsWith("?");
        if (!bl) {
            string = string + ".";
        }
        return string;
    }

    private static void sendError(String string, String string2, String string3, Object object) {
        Core.getInstance().getLogger().severe("Something went wrong while creating an item! " + ConfigItemCreator.addPunctuation(string) + " File: " + string2 + "  Config Path: " + string3 + "  Value: " + object);
    }

    private static ItemStack addNbt(FileConfiguration fileConfiguration, String string, ItemStack itemStack, Map<String, String> map) {
        if (fileConfiguration.contains(string + "." + map.get("nbt"))) {
            String string2 = fileConfiguration.getString(string + "." + map.get("nbt"));
            itemStack = Bukkit.getUnsafe().modifyItemStack(itemStack, string2);
        }
        return itemStack;
    }
}

