/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.utils;

import io.papermc.paper.enchantments.EnchantmentRarity;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.advancedplugins.at.Core;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.EntityCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class GlowEffect {
    public static final Enchantment GLOW = new EnchantmentWrapper("ae_glow", "", 1);

    public static void register() {
        boolean bl = Arrays.stream(Enchantment.values()).collect(Collectors.toList()).contains(GLOW);
        if (!bl) {
            GlowEffect.registerEnchantment(GLOW);
        }
    }

    public static void registerEnchantment(Enchantment enchantment) {
        boolean bl = true;
        if (Enchantment.getByName((String)GLOW.getName()) == null) {
            try {
                Field field = Enchantment.class.getDeclaredField("acceptingNew");
                field.setAccessible(true);
                field.set(null, true);
                Enchantment.registerEnchantment((Enchantment)enchantment);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
                bl = false;
                exception.printStackTrace();
            }
        }
        if (!bl) {
            Core.getInstance().getLogger().severe("Failed to register glow effect. Items with custom enchants may not glow.");
        }
    }

    private static class EnchantmentWrapper
    extends Enchantment {
        private final String name;
        private final int maxLvl;

        public EnchantmentWrapper(String string, String string2, int n) {
            super(NamespacedKey.minecraft((String)string));
            this.name = string2;
            this.maxLvl = n;
        }

        public String translationKey() {
            return null;
        }

        public boolean canEnchantItem(ItemStack itemStack) {
            return false;
        }

        public boolean conflictsWith(Enchantment enchantment) {
            return false;
        }

        public EnchantmentTarget getItemTarget() {
            return null;
        }

        public int getMaxLevel() {
            return this.maxLvl;
        }

        public String getName() {
            return this.name;
        }

        public int getStartLevel() {
            return 0;
        }

        public boolean isCursed() {
            return false;
        }

        public boolean isTreasure() {
            return false;
        }

        public Set<EquipmentSlot> getActiveSlots() {
            return null;
        }

        public float getDamageIncrease(int n, EntityCategory entityCategory) {
            return 0.0f;
        }

        public Component displayName(int n) {
            return null;
        }

        public boolean isTradeable() {
            return false;
        }

        public boolean isDiscoverable() {
            return false;
        }

        public EnchantmentRarity getRarity() {
            return null;
        }
    }
}

