/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.at.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.advancedplugins.at.utils.AManager;
import net.advancedplugins.at.utils.GlowEffect;
import net.advancedplugins.at.utils.MathUtils;
import net.advancedplugins.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private ItemStack is;
    private ItemMeta im;

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder(ItemStack itemStack) {
        this.is = itemStack;
        this.im = itemStack.getItemMeta();
    }

    public ItemBuilder(Material material, int n) {
        this.is = new ItemStack(material, n);
        this.im = this.is.getItemMeta();
    }

    public ItemBuilder(Material material, int n, byte by) {
        this.is = new ItemStack(material, n, (short)by);
        this.im = this.is.getItemMeta();
    }

    public ItemBuilder setDurability(short s) {
        this.is.setDurability(s);
        return this;
    }

    public ItemBuilder setName(String string) {
        this.im.setDisplayName(string);
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment enchantment, int n) {
        this.im.addEnchant(enchantment, n, true);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.is.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder setSkullOwner(String string) {
        try {
            SkullMeta skullMeta = (SkullMeta)this.im;
            skullMeta.setOwner(string);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int n) {
        this.im.addEnchant(enchantment, n, true);
        return this;
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> map) {
        this.is.addEnchantments(map);
        return this;
    }

    public ItemBuilder setInfinityDurability() {
        this.is.setDurability((short)Short.MAX_VALUE);
        return this;
    }

    public ItemBuilder setLore(String ... stringArray) {
        this.im.setLore(Arrays.asList(stringArray));
        return this;
    }

    public ItemBuilder setLore(List<String> list) {
        this.im.setLore(list);
        return this;
    }

    public ItemBuilder removeLoreLine(String string) {
        ArrayList arrayList = new ArrayList(this.im.getLore());
        if (!arrayList.contains(string)) {
            return this;
        }
        arrayList.remove(string);
        this.im.setLore(arrayList);
        return this;
    }

    public ItemBuilder removeLoreLine(int n) {
        ArrayList arrayList = new ArrayList(this.im.getLore());
        if (n < 0 || n > arrayList.size()) {
            return this;
        }
        arrayList.remove(n);
        this.im.setLore(arrayList);
        return this;
    }

    public ItemBuilder addLoreLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.im.hasLore()) {
            arrayList = new ArrayList(this.im.getLore());
        }
        arrayList.add(string);
        this.im.setLore(arrayList);
        return this;
    }

    public ItemBuilder addLoreLine(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>(this.im.getLore());
        arrayList.set(n, string);
        this.im.setLore(arrayList);
        return this;
    }

    public ItemBuilder setColor(Color color) {
        if (this.im instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.im;
            leatherArmorMeta.setColor(color);
        } else if (this.im instanceof FireworkEffectMeta) {
            FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)this.im;
            fireworkEffectMeta.setEffect(FireworkEffect.builder().withColor(color).build());
        }
        return this;
    }

    public ItemBuilder setItemFlags(ItemFlag ... itemFlagArray) {
        this.im.addItemFlags(itemFlagArray);
        return this;
    }

    public ItemBuilder setUnbreakable(boolean bl) {
        this.is.setItemMeta(this.im);
        this.im = this.is.getItemMeta();
        if (MinecraftVersion.getVersionNumber() >= 1110) {
            this.im.setUnbreakable(bl);
        }
        return this;
    }

    public ItemBuilder setAmount(int n) {
        this.is.setAmount(MathUtils.clamp(n, 0, 64));
        return this;
    }

    public ItemBuilder addItemFlag(ItemFlag itemFlag) {
        this.im.addItemFlags(new ItemFlag[]{itemFlag});
        return this;
    }

    public ItemBuilder setCustomModelData(Integer n) {
        if (MinecraftVersion.getVersionNumber() >= 1140) {
            this.im.setCustomModelData(n);
        }
        return this;
    }

    public ItemBuilder setGlowing(boolean bl) {
        if (bl) {
            this.is = AManager.addGlow(this.is);
        } else if (MinecraftVersion.isNew() && this.is.containsEnchantment(GlowEffect.GLOW)) {
            this.is.removeEnchantment(GlowEffect.GLOW);
        }
        return this;
    }

    public ItemMeta getItemMeta() {
        return this.im;
    }

    public ItemStack toItemStack() {
        this.is.setItemMeta(this.im);
        return this.is;
    }
}

