/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.advancedplugins.utils.nbt.utils.MinecraftVersion;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ASManager {
    private static HashMap<Integer, String> damages = new HashMap();
    private static HashMap<String, String> newMaterials = new HashMap();

    public static boolean isSpawner(Material material) {
        return material.name().endsWith("SPAWNER");
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String formatMaterialName(Material material) {
        String string = material.name().toLowerCase().replaceAll("_", " ");
        string = ASManager.capitalize(string);
        return string;
    }

    public static Object extractFromDataArray(String string, String string2, String string3, Object object) {
        for (String string4 : string.split(" ")) {
            if (!string4.startsWith(string2)) continue;
            return string4.split(string3)[1];
        }
        return object;
    }

    public static String formatTime(long l) {
        int n = (int)(l / 1000L);
        int n2 = n % 3600 % 60;
        int n3 = (int)Math.floor(n % 3600 / 60);
        int n4 = (int)Math.floor(n / 3600);
        String string = "";
        if (n4 > 0) {
            string = string + n4 + "h ";
        }
        if (n3 > 0) {
            string = string + n3 + "m ";
        }
        string = string + n2 + "s";
        return string;
    }

    public static void reportIssue(Exception exception, String string) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        String string2 = "";
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string3 = stackTraceElement + "";
            if (!string3.contains("net.advancedplugins.ae")) continue;
            string2 = string3;
            break;
        }
        exception.printStackTrace();
        Bukkit.getLogger().info("[AdvancedPets ERROR] Could not pass " + ExceptionUtils.getRootCauseMessage((Throwable)exception) + "");
        Bukkit.getLogger().info("   Class: " + string2);
        Bukkit.getLogger().info("   Extra info: " + string + "; mc[" + MinecraftVersion.getVersionNumber() + "];");
        Bukkit.getLogger().info("If you cannot indentify cause of this, contact developer providing this report. ");
    }

    public static Material getMaterial(String string) {
        try {
            MinecraftVersion.getVersion();
            return MinecraftVersion.getVersionNumber() > 1121 ? Material.matchMaterial((String)string, (boolean)true) : Material.matchMaterial((String)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static List<String> replace(List<String> list, String string, String string2) {
        list.replaceAll(string3 -> string3.replace(string, string2));
        return list;
    }

    public static int[] getSlots(String string) {
        int[] nArray = new int[1];
        if (string.contains(",")) {
            nArray = Arrays.stream(string.split(",")).mapToInt(Integer::parseInt).toArray();
        } else if (string.contains("-")) {
            nArray = Arrays.stream(string.split("-")).mapToInt(Integer::parseInt).toArray();
            nArray = IntStream.rangeClosed(nArray[0], nArray[1]).toArray();
        } else {
            nArray[0] = ASManager.parseInt(string);
        }
        return nArray;
    }

    public static boolean contains(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.toLowerCase(Locale.ROOT).contains(string2)) continue;
            return true;
        }
        return false;
    }

    public static int parseInt(String string) {
        try {
            return Integer.parseInt(string.replaceAll("[^0-9]", ""));
        }
        catch (Exception exception) {
            Bukkit.getLogger().info("Failed to parse " + string + " from String to Integer.");
            return 0;
        }
    }

    public static void playEffect(String string, int n, int n2, Location location) {
        MinecraftVersion.getVersion();
        if (MinecraftVersion.getVersionNumber() < 1130) {
            try {
                Class<?> clazz = Class.forName("org.bukkit.Effect");
                Object obj = Enum.valueOf(clazz, string);
                Method method = location.getWorld().spigot().getClass().getMethod("playEffect", Location.class, clazz, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)location.getWorld().spigot(), location, obj, 0, 0, n, n, n, Float.valueOf(0.0f), n2, 32);
            }
            catch (Exception exception) {}
        } else {
            try {
                Class<?> clazz = Class.forName("org.bukkit.Particle");
                Object obj = Enum.valueOf(clazz, string);
                Method method = location.getWorld().getClass().getMethod("spawnParticle", clazz, Location.class, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)location.getWorld(), obj, location, n2, n, n, n, Float.valueOf(0.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean startsWithColor(String string) {
        for (String string2 : damages.values()) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static String addColor(String string, int n) {
        String string2 = damages.get(n);
        if (string2 == null) {
            return string;
        }
        return string2 + "_" + string;
    }

    private static boolean canAddColor(String string) {
        return string.contains("STAINED_GLASS") || string.contains("SHULKER") || string.contains("TERRACOTTA") || string.contains("WOOL") || string.contains("BANNER") || string.contains("DYE") || string.contains("CONCRETE") || string.contains("CARPET") || string.contains("BED");
    }

    public static ItemStack matchMaterial(String string, int n, int n2) {
        return ASManager.matchMaterial(string, n, n2, false, true);
    }

    public static ItemStack matchMaterial(String string, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        MinecraftVersion.getVersion();
        boolean bl4 = bl3 = MinecraftVersion.getVersionNumber() > 1121;
        if (bl3) {
            if (!(!string.startsWith("GOLD_") || string.contains("BLOCK") || string.contains("NUGGET") || string.contains("INGOT") || string.contains("ORE"))) {
                string = string.replace("GOLD_", "GOLDEN_");
            }
            for (Map.Entry entry : newMaterials.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(string)) continue;
                string = (String)entry.getValue();
                break;
            }
            if (ASManager.canAddColor(string) && !ASManager.startsWithColor(string)) {
                string = ASManager.addColor(string, n2);
            }
        }
        try {
            Material material = bl ? Material.matchMaterial((String)string, (boolean)true) : Material.matchMaterial((String)string);
            return !bl3 ? new ItemStack(material, n, (short)((byte)n2)) : new ItemStack(material, n);
        }
        catch (Exception exception) {
            if (!bl && bl3) {
                return ASManager.matchMaterial(string, n, n2, true, bl2);
            }
            if (bl2) {
                Bukkit.getLogger().info("\u00a7cFailed to match '" + string + "' material, check your configuration or use materials.txt  to find needed material. \u00a77\u00a7oFurther information has been pasted to console...");
                exception.printStackTrace();
            }
            return null;
        }
    }

    public static String getRoughNumber(long l) {
        if (l <= 999L) {
            return String.valueOf(l);
        }
        String[] stringArray = new String[]{"", "K", "M", "B", "P"};
        int n = (int)(Math.log10(l) / Math.log10(1000.0));
        return new DecimalFormat("#,##0.#").format((double)l / Math.pow(1000.0, n)) + "" + stringArray[n];
    }

    public static String format(long l) {
        return NumberFormat.getInstance().format(l) + "";
    }

    public static String color(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static boolean isTall(Material material) {
        if (material.name().endsWith("_DOOR")) {
            return true;
        }
        if (MinecraftVersion.isNew()) {
            return material == Material.SUNFLOWER || material == Material.LILAC || material == Material.ROSE_BUSH || material == Material.PEONY;
        }
        return material == Material.valueOf((String)"DOUBLE_PLANT");
    }

    public static boolean isValid(Material material) {
        return material != null && !ASManager.isAir(material);
    }

    public static boolean isValid(ItemStack itemStack) {
        return itemStack != null && itemStack.getAmount() > 0 && !ASManager.isAir(itemStack.getType());
    }

    public static boolean isValid(Block block) {
        if (block == null || ASManager.isAir(block.getType())) {
            return false;
        }
        String string = block.getType().name();
        if (string.endsWith("_PORTAL")) {
            return false;
        }
        if (string.contains("PISTON_")) {
            return string.contains("PISTON_BASE") || string.contains("PISTON_STICKY_BASE");
        }
        return !string.equals("FIRE") && !string.equals("SOUL_FIRE") && !string.equals("TALL_SEAGRASS") && !string.equals("SWEET_BERRY_BUSH") && !string.equals("BUBBLE_COLUMN") && !string.equals("LAVA");
    }

    public static void giveItem(Player player, ItemStack ... itemStackArray) {
        for (ItemStack itemStack : itemStackArray) {
            if (!ASManager.isValid(itemStack)) continue;
            if (player.getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) continue;
            ASManager.dropItem(player.getLocation(), itemStack);
        }
    }

    public static List<ItemStack> condense(ItemStack[] itemStackArray) {
        for (int i = 0; i < itemStackArray.length; ++i) {
            if (itemStackArray[i] == null) continue;
            for (int j = i + 1; j < itemStackArray.length; ++j) {
                if (itemStackArray[j] == null || !itemStackArray[i].isSimilar(itemStackArray[j]) || itemStackArray[i].getAmount() + itemStackArray[j].getAmount() > itemStackArray[i].getMaxStackSize()) continue;
                itemStackArray[i].setAmount(itemStackArray[i].getAmount() + itemStackArray[j].getAmount());
                itemStackArray[j] = null;
            }
        }
        return Arrays.stream(itemStackArray).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void dropItem(Location location, ItemStack ... itemStackArray) {
        for (ItemStack itemStack : itemStackArray) {
            location.getWorld().dropItem(location, itemStack);
        }
    }

    public static boolean isAir(Material material) {
        if (material == null) {
            return false;
        }
        if (MinecraftVersion.getVersionNumber() >= 1130) {
            return material == Material.AIR || material == Material.CAVE_AIR || material == Material.VOID_AIR || material == Material.LEGACY_AIR;
        }
        return material == Material.AIR;
    }

    public static boolean isAir(Block block) {
        return block == null || ASManager.isAir(block.getType());
    }

    public static boolean isAir(ItemStack itemStack) {
        return itemStack == null || ASManager.isAir(itemStack.getType());
    }

    public static void sendActionBar(String string, Player player) {
        if (MinecraftVersion.getVersionNumber() >= 190) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
        } else {
            String string2 = "v1_8_R3";
            try {
                Class<?> clazz = Class.forName("org.bukkit.craftbukkit." + string2 + ".entity.CraftPlayer");
                Object obj = clazz.cast(player);
                Class<?> clazz2 = Class.forName("net.minecraft.server." + string2 + ".PacketPlayOutChat");
                Class<?> clazz3 = Class.forName("net.minecraft.server." + string2 + ".Packet");
                Class<?> clazz4 = Class.forName("net.minecraft.server." + string2 + (string2.equalsIgnoreCase("v1_8_R1") ? ".ChatSerializer" : ".ChatComponentText"));
                Class<?> clazz5 = Class.forName("net.minecraft.server." + string2 + ".IChatBaseComponent");
                Method method = null;
                if (string2.equalsIgnoreCase("v1_8_R1")) {
                    method = clazz4.getDeclaredMethod("a", String.class);
                }
                Object obj2 = string2.equalsIgnoreCase("v1_8_R1") ? clazz5.cast(method.invoke(clazz4, "{'text': '" + string + "'}")) : clazz4.getConstructor(String.class).newInstance(string);
                Object obj3 = clazz2.getConstructor(clazz5, Byte.TYPE).newInstance(obj2, (byte)2);
                Method method2 = clazz.getDeclaredMethod("getHandle", new Class[0]);
                Object object = method2.invoke(obj, new Object[0]);
                Field field = object.getClass().getDeclaredField("playerConnection");
                Object object2 = field.get(object);
                Method method3 = object2.getClass().getDeclaredMethod("sendPacket", clazz3);
                method3.invoke(object2, obj3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static int getPages(int n, int n2) {
        return n / n2 + (n % n2 == 0 ? 0 : 1);
    }

    static {
        if (damages.isEmpty()) {
            damages.put(0, "WHITE");
            damages.put(1, "ORANGE");
            damages.put(2, "MAGENTA");
            damages.put(3, "LIGHT_BLUE");
            damages.put(4, "YELLOW");
            damages.put(5, "LIME");
            damages.put(6, "PINK");
            damages.put(7, "GRAY");
            damages.put(8, "LIGHT_GRAY");
            damages.put(9, "CYAN");
            damages.put(10, "PURPLE");
            damages.put(11, "BLUE");
            damages.put(12, "BROWN");
            damages.put(13, "GREEN");
            damages.put(14, "RED");
            damages.put(15, "BLACK");
        }
        if (newMaterials.isEmpty()) {
            newMaterials.put("EYE_OF_ENDER", "ENDER_EYE");
            newMaterials.put("ENDER_PORTAL_FRAME", "END_PORTAL_FRAME");
            newMaterials.put("FIREWORK_CHARGE", "FIREWORK_STAR");
            newMaterials.put("FIREBALL", "FIRE_CHARGE");
            newMaterials.put("SULPHUR", "GUNPOWDER");
            newMaterials.put("WOOD_DOOR", "OAK_DOOR");
            newMaterials.put("COMMAND", "COMMAND_BLOCK");
            newMaterials.put("PISTON_BASE", "PISTON");
            newMaterials.put("SKULL_ITEM", "PLAYER_HEAD");
            newMaterials.put("WORKBENCH", "CRAFTING_TABLE");
            newMaterials.put("BOOK_AND_QUILL", "WRITABLE_BOOK");
            newMaterials.put("THIN_GLASS", "GLASS_PANE");
            newMaterials.put("STORAGE_MINECART", "CHEST_MINECART");
            newMaterials.put("BREWING_STAND_ITEM", "LEGACY_BREWING_STAND_ITEM");
        }
    }
}

