/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.utils.fanciful;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import net.advancedplugins.utils.fanciful.ArrayWrapper;
import net.advancedplugins.utils.fanciful.JsonRepresentedObject;
import net.advancedplugins.utils.fanciful.JsonString;
import net.advancedplugins.utils.fanciful.MessagePart;
import net.advancedplugins.utils.fanciful.TextualComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;

public class FancyMessage
implements JsonRepresentedObject,
Cloneable,
Iterable<MessagePart>,
ConfigurationSerializable {
    private static final JsonParser _stringParser = new JsonParser();
    private List<MessagePart> messageParts = new ArrayList<MessagePart>();
    private String jsonString;
    private boolean dirty;

    public FancyMessage(String string) {
        this(TextualComponent.rawText(string));
    }

    private FancyMessage(TextualComponent textualComponent) {
        this.messageParts.add(new MessagePart(textualComponent));
        this.jsonString = null;
        this.dirty = false;
    }

    private FancyMessage() {
        this((TextualComponent)null);
    }

    public static FancyMessage deserialize(Map<String, Object> map) {
        FancyMessage fancyMessage = new FancyMessage();
        fancyMessage.messageParts = (List)map.get("messageParts");
        fancyMessage.jsonString = map.containsKey("JSON") ? map.get("JSON").toString() : null;
        fancyMessage.dirty = !map.containsKey("JSON");
        return fancyMessage;
    }

    private static FancyMessage deserialize(String string) {
        JsonObject jsonObject = _stringParser.parse(string).getAsJsonObject();
        JsonArray jsonArray = jsonObject.getAsJsonArray("extra");
        FancyMessage fancyMessage = new FancyMessage();
        fancyMessage.messageParts.clear();
        for (JsonElement jsonElement : jsonArray) {
            MessagePart messagePart = new MessagePart();
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject2.entrySet()) {
                Object object;
                if (TextualComponent.isTextKey((String)entry.getKey())) {
                    object = new HashMap();
                    object.put("key", entry.getKey());
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        object.put("value", ((JsonElement)entry.getValue()).getAsString());
                    } else {
                        for (Map.Entry entry2 : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                            object.put("value." + (String)entry2.getKey(), ((JsonElement)entry2.getValue()).getAsString());
                        }
                    }
                    messagePart.text = TextualComponent.deserialize((Map<String, Object>)object);
                    continue;
                }
                if (MessagePart.stylesToNames.inverse().containsKey(entry.getKey())) {
                    if (!((JsonElement)entry.getValue()).getAsBoolean()) continue;
                    messagePart.styles.add((ChatColor)MessagePart.stylesToNames.inverse().get(entry.getKey()));
                    continue;
                }
                if (((String)entry.getKey()).equals("color")) {
                    messagePart.color = ChatColor.valueOf((String)((JsonElement)entry.getValue()).getAsString().toUpperCase(Locale.ROOT));
                    continue;
                }
                if (((String)entry.getKey()).equals("clickEvent")) {
                    object = ((JsonElement)entry.getValue()).getAsJsonObject();
                    messagePart.clickActionName = object.get("action").getAsString();
                    messagePart.clickActionData = object.get("value").getAsString();
                    continue;
                }
                if (((String)entry.getKey()).equals("hoverEvent")) {
                    object = ((JsonElement)entry.getValue()).getAsJsonObject();
                    messagePart.hoverActionName = object.get("action").getAsString();
                    if (object.get("value").isJsonPrimitive()) {
                        messagePart.hoverActionData = new JsonString(object.get("value").getAsString());
                        continue;
                    }
                    messagePart.hoverActionData = FancyMessage.deserialize(object.get("value").toString());
                    continue;
                }
                if (((String)entry.getKey()).equals("insertion")) {
                    messagePart.insertionData = ((JsonElement)entry.getValue()).getAsString();
                    continue;
                }
                if (!((String)entry.getKey()).equals("with")) continue;
                for (JsonElement jsonElement2 : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (jsonElement2.isJsonPrimitive()) {
                        messagePart.translationReplacements.add(new JsonString(jsonElement2.getAsString()));
                        continue;
                    }
                    messagePart.translationReplacements.add(FancyMessage.deserialize(jsonElement2.toString()));
                }
            }
            fancyMessage.messageParts.add(messagePart);
        }
        return fancyMessage;
    }

    public FancyMessage clone() {
        FancyMessage fancyMessage = (FancyMessage)super.clone();
        fancyMessage.messageParts = new ArrayList<MessagePart>(this.messageParts.size());
        for (int i = 0; i < this.messageParts.size(); ++i) {
            fancyMessage.messageParts.add(i, this.messageParts.get(i).clone());
        }
        fancyMessage.dirty = false;
        fancyMessage.jsonString = null;
        return fancyMessage;
    }

    public FancyMessage text(String string) {
        MessagePart messagePart = this.latest();
        messagePart.text = TextualComponent.rawText(string);
        this.dirty = true;
        return this;
    }

    public FancyMessage text(TextualComponent textualComponent) {
        MessagePart messagePart = this.latest();
        messagePart.text = textualComponent;
        this.dirty = true;
        return this;
    }

    public FancyMessage color(ChatColor chatColor) {
        if (!chatColor.isColor()) {
            throw new IllegalArgumentException(chatColor.name() + " is not a color");
        }
        this.latest().color = chatColor;
        this.dirty = true;
        return this;
    }

    public FancyMessage style(ChatColor ... chatColorArray) {
        for (ChatColor chatColor : chatColorArray) {
            if (chatColor.isFormat()) continue;
            throw new IllegalArgumentException(chatColor.name() + " is not a style");
        }
        this.latest().styles.addAll(Arrays.asList(chatColorArray));
        this.dirty = true;
        return this;
    }

    public FancyMessage file(String string) {
        this.onClick("open_file", string);
        return this;
    }

    public FancyMessage link(String string) {
        this.onClick("open_url", string);
        return this;
    }

    public FancyMessage suggest(String string) {
        this.onClick("suggest_command", string);
        return this;
    }

    public FancyMessage insert(String string) {
        this.latest().insertionData = string;
        this.dirty = true;
        return this;
    }

    public FancyMessage command(String string) {
        this.onClick("run_command", string);
        return this;
    }

    public FancyMessage achievementTooltip(String string) {
        this.onHover("show_achievement", new JsonString("achievement." + string));
        return this;
    }

    private FancyMessage tooltip(String string) {
        this.onHover("show_text", new JsonString(string));
        return this;
    }

    public FancyMessage tooltip(Iterable<String> iterable) {
        this.tooltip(ArrayWrapper.toArray(iterable, String.class));
        return this;
    }

    public FancyMessage tooltip(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            stringBuilder.append('\n');
        }
        this.tooltip(stringBuilder.toString());
        return this;
    }

    private FancyMessage formattedTooltip(FancyMessage fancyMessage) {
        for (MessagePart messagePart : fancyMessage.messageParts) {
            if (messagePart.clickActionData != null && messagePart.clickActionName != null) {
                throw new IllegalArgumentException("The tooltip text cannot have click data.");
            }
            if (messagePart.hoverActionData == null || messagePart.hoverActionName == null) continue;
            throw new IllegalArgumentException("The tooltip text cannot have a tooltip.");
        }
        this.onHover("show_text", fancyMessage);
        return this;
    }

    private FancyMessage formattedTooltip(FancyMessage ... fancyMessageArray) {
        if (fancyMessageArray.length < 1) {
            this.onHover(null, null);
            return this;
        }
        FancyMessage fancyMessage = new FancyMessage();
        fancyMessage.messageParts.clear();
        for (int i = 0; i < fancyMessageArray.length; ++i) {
            try {
                for (MessagePart messagePart : fancyMessageArray[i]) {
                    if (messagePart.clickActionData != null && messagePart.clickActionName != null) {
                        throw new IllegalArgumentException("The tooltip text cannot have click data.");
                    }
                    if (messagePart.hoverActionData != null && messagePart.hoverActionName != null) {
                        throw new IllegalArgumentException("The tooltip text cannot have a tooltip.");
                    }
                    if (!messagePart.hasText()) continue;
                    fancyMessage.messageParts.add(messagePart.clone());
                }
                if (i == fancyMessageArray.length - 1) continue;
                fancyMessage.messageParts.add(new MessagePart(TextualComponent.rawText("\n")));
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Bukkit.getLogger().log(Level.WARNING, "Failed to clone object", cloneNotSupportedException);
                return this;
            }
        }
        return this.formattedTooltip(fancyMessage.messageParts.isEmpty() ? null : fancyMessage);
    }

    public FancyMessage formattedTooltip(Iterable<FancyMessage> iterable) {
        return this.formattedTooltip(ArrayWrapper.toArray(iterable, FancyMessage.class));
    }

    public FancyMessage translationReplacements(String ... stringArray) {
        for (String string : stringArray) {
            this.latest().translationReplacements.add(new JsonString(string));
        }
        this.dirty = true;
        return this;
    }

    private FancyMessage translationReplacements(FancyMessage ... fancyMessageArray) {
        Collections.addAll(this.latest().translationReplacements, fancyMessageArray);
        this.dirty = true;
        return this;
    }

    public FancyMessage translationReplacements(Iterable<FancyMessage> iterable) {
        return this.translationReplacements(ArrayWrapper.toArray(iterable, FancyMessage.class));
    }

    public FancyMessage then(String string) {
        return this.then(TextualComponent.rawText(string));
    }

    private FancyMessage then(TextualComponent textualComponent) {
        if (!this.latest().hasText()) {
            throw new IllegalStateException("previous message part has no text");
        }
        this.messageParts.add(new MessagePart(textualComponent));
        this.dirty = true;
        return this;
    }

    public FancyMessage then() {
        if (!this.latest().hasText()) {
            throw new IllegalStateException("previous message part has no text");
        }
        this.messageParts.add(new MessagePart());
        this.dirty = true;
        return this;
    }

    @Override
    public void writeJson(JsonWriter jsonWriter) {
        if (this.messageParts.size() == 1) {
            this.latest().writeJson(jsonWriter);
        } else {
            jsonWriter.beginObject().name("text").value("").name("extra").beginArray();
            for (MessagePart messagePart : this) {
                messagePart.writeJson(jsonWriter);
            }
            jsonWriter.endArray().endObject();
        }
    }

    private String toJSONString() {
        if (!this.dirty && this.jsonString != null) {
            return this.jsonString;
        }
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            this.writeJson(jsonWriter);
            jsonWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("invalid message");
        }
        this.jsonString = stringWriter.toString();
        this.dirty = false;
        return this.jsonString;
    }

    public void send(Player player) {
        this.send((CommandSender)player, this.toJSONString());
    }

    private void send(CommandSender commandSender, String string) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.toOldMessageFormat());
            return;
        }
        Player player = (Player)commandSender;
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " " + string));
    }

    public void send(CommandSender commandSender) {
        this.send(commandSender, this.toJSONString());
    }

    public void send(Iterable<? extends CommandSender> iterable) {
        String string = this.toJSONString();
        for (CommandSender commandSender : iterable) {
            this.send(commandSender, string);
        }
    }

    private String toOldMessageFormat() {
        StringBuilder stringBuilder = new StringBuilder();
        for (MessagePart messagePart : this) {
            stringBuilder.append((Object)(messagePart.color == null ? "" : messagePart.color));
            for (ChatColor chatColor : messagePart.styles) {
                stringBuilder.append(chatColor);
            }
            stringBuilder.append(messagePart.text);
        }
        return stringBuilder.toString();
    }

    private MessagePart latest() {
        return this.messageParts.get(this.messageParts.size() - 1);
    }

    private void onClick(String string, String string2) {
        MessagePart messagePart = this.latest();
        messagePart.clickActionName = string;
        messagePart.clickActionData = string2;
        this.dirty = true;
    }

    private void onHover(String string, JsonRepresentedObject jsonRepresentedObject) {
        MessagePart messagePart = this.latest();
        messagePart.hoverActionName = string;
        messagePart.hoverActionData = jsonRepresentedObject;
        this.dirty = true;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("messageParts", this.messageParts);
        return hashMap;
    }

    @Override
    public Iterator<MessagePart> iterator() {
        return this.messageParts.iterator();
    }

    static {
        ConfigurationSerialization.registerClass(FancyMessage.class);
    }
}

