/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.utils.fanciful;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import net.advancedplugins.utils.fanciful.FancyMessage;
import net.advancedplugins.utils.fanciful.JsonRepresentedObject;
import net.advancedplugins.utils.fanciful.JsonString;
import net.advancedplugins.utils.fanciful.TextualComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

final class MessagePart
implements JsonRepresentedObject,
ConfigurationSerializable,
Cloneable {
    static final BiMap<ChatColor, String> stylesToNames;
    ChatColor color = ChatColor.WHITE;
    ArrayList<ChatColor> styles = new ArrayList();
    String clickActionName = null;
    String clickActionData = null;
    String hoverActionName = null;
    JsonRepresentedObject hoverActionData = null;
    TextualComponent text = null;
    String insertionData = null;
    ArrayList<JsonRepresentedObject> translationReplacements = new ArrayList();

    MessagePart(TextualComponent textualComponent) {
        this.text = textualComponent;
    }

    MessagePart() {
        this.text = null;
    }

    public static MessagePart deserialize(Map<String, Object> map) {
        MessagePart messagePart = new MessagePart((TextualComponent)map.get("text"));
        messagePart.styles = (ArrayList)map.get("styles");
        messagePart.color = ChatColor.getByChar((String)map.get("color").toString());
        messagePart.hoverActionName = (String)map.get("hoverActionName");
        messagePart.hoverActionData = (JsonRepresentedObject)map.get("hoverActionData");
        messagePart.clickActionName = (String)map.get("clickActionName");
        messagePart.clickActionData = (String)map.get("clickActionData");
        messagePart.insertionData = (String)map.get("insertion");
        messagePart.translationReplacements = (ArrayList)map.get("translationReplacements");
        return messagePart;
    }

    boolean hasText() {
        return this.text != null;
    }

    public MessagePart clone() {
        MessagePart messagePart = (MessagePart)super.clone();
        messagePart.styles = (ArrayList)this.styles.clone();
        if (this.hoverActionData instanceof JsonString) {
            messagePart.hoverActionData = new JsonString(((JsonString)this.hoverActionData).getValue());
        } else if (this.hoverActionData instanceof FancyMessage) {
            messagePart.hoverActionData = ((FancyMessage)this.hoverActionData).clone();
        }
        messagePart.translationReplacements = (ArrayList)this.translationReplacements.clone();
        return messagePart;
    }

    @Override
    public void writeJson(JsonWriter jsonWriter) {
        try {
            jsonWriter.beginObject();
            this.text.writeJson(jsonWriter);
            jsonWriter.name("color").value(this.color.name().toLowerCase(Locale.ROOT));
            for (ChatColor object : this.styles) {
                jsonWriter.name((String)stylesToNames.get((Object)object)).value(true);
            }
            if (this.clickActionName != null && this.clickActionData != null) {
                jsonWriter.name("clickEvent").beginObject().name("action").value(this.clickActionName).name("value").value(this.clickActionData).endObject();
            }
            if (this.hoverActionName != null && this.hoverActionData != null) {
                jsonWriter.name("hoverEvent").beginObject().name("action").value(this.hoverActionName).name("value");
                this.hoverActionData.writeJson(jsonWriter);
                jsonWriter.endObject();
            }
            if (this.insertionData != null) {
                jsonWriter.name("insertion").value(this.insertionData);
            }
            if (!this.translationReplacements.isEmpty() && TextualComponent.isTranslatableText(this.text)) {
                jsonWriter.name("with").beginArray();
                for (JsonRepresentedObject jsonRepresentedObject : this.translationReplacements) {
                    jsonRepresentedObject.writeJson(jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (IOException iOException) {
            Bukkit.getLogger().log(Level.WARNING, "A problem occured during writing of JSON string", iOException);
        }
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("text", this.text);
        hashMap.put("styles", this.styles);
        hashMap.put("color", Character.valueOf(this.color.getChar()));
        hashMap.put("hoverActionName", this.hoverActionName);
        hashMap.put("hoverActionData", this.hoverActionData);
        hashMap.put("clickActionName", this.clickActionName);
        hashMap.put("clickActionData", this.clickActionData);
        hashMap.put("insertion", this.insertionData);
        hashMap.put("translationReplacements", this.translationReplacements);
        return hashMap;
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ChatColor chatColor : ChatColor.values()) {
            String string;
            if (!chatColor.isFormat()) continue;
            switch (chatColor) {
                case MAGIC: {
                    string = "obfuscated";
                    break;
                }
                case UNDERLINE: {
                    string = "underlined";
                    break;
                }
                default: {
                    string = chatColor.name().toLowerCase(Locale.ROOT);
                }
            }
            builder.put((Object)chatColor, (Object)string);
        }
        stylesToNames = builder.build();
        ConfigurationSerialization.registerClass(MessagePart.class);
    }
}

