/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.utils.nbt.backend;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;
import net.advancedplugins.utils.nbt.backend.ClassWrapper;
import net.advancedplugins.utils.nbt.backend.NBTCompound;
import net.advancedplugins.utils.nbt.backend.NBTContainer;
import net.advancedplugins.utils.nbt.backend.NBTType;
import net.advancedplugins.utils.nbt.backend.NbtApiException;
import net.advancedplugins.utils.nbt.backend.ObjectCreator;
import net.advancedplugins.utils.nbt.backend.ReflectionMethod;
import net.advancedplugins.utils.nbt.utils.GsonWrapper;
import net.advancedplugins.utils.nbt.utils.MinecraftVersion;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.meta.ItemMeta;

public class NBTReflectionUtil {
    private static Field field_unhandledTags = null;

    private NBTReflectionUtil() {
    }

    public static Object getNMSEntity(Entity entity) {
        try {
            return ReflectionMethod.CRAFT_ENTITY_GET_HANDLE.run(ClassWrapper.CRAFT_ENTITY.getClazz().cast(entity), new Object[0]);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while getting the NMS Entity from a Bukkit Entity!", exception);
        }
    }

    public static Object readNBT(InputStream inputStream) {
        try {
            return ReflectionMethod.NBTFILE_READ.run(null, inputStream);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while reading a NBT File!", exception);
        }
    }

    public static Object writeNBT(Object object, OutputStream outputStream) {
        try {
            return ReflectionMethod.NBTFILE_WRITE.run(null, object, outputStream);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while writing NBT!", exception);
        }
    }

    public static void writeApiNBT(NBTCompound nBTCompound, OutputStream outputStream) {
        try {
            Object object = nBTCompound.getCompound();
            if (object == null) {
                object = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
            }
            if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
                return;
            }
            Object object2 = NBTReflectionUtil.gettoCompount(object, nBTCompound);
            ReflectionMethod.NBTFILE_WRITE.run(null, object2, outputStream);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while writing NBT!", exception);
        }
    }

    public static Object getItemRootNBTTagCompound(Object object) {
        try {
            Object object2 = ReflectionMethod.NMSITEM_GETTAG.run(object, new Object[0]);
            return object2 != null ? object2 : ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while getting an Itemstack's NBTCompound!", exception);
        }
    }

    public static Object convertNBTCompoundtoNMSItem(NBTCompound nBTCompound) {
        try {
            Object object = NBTReflectionUtil.gettoCompount(nBTCompound.getCompound(), nBTCompound);
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_11_R1.getVersionId()) {
                return ObjectCreator.NMS_COMPOUNDFROMITEM.getInstance(object);
            }
            return ReflectionMethod.NMSITEM_CREATESTACK.run(null, object);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while converting NBTCompound to NMS ItemStack!", exception);
        }
    }

    public static NBTContainer convertNMSItemtoNBTCompound(Object object) {
        try {
            Object object2 = ReflectionMethod.NMSITEM_SAVE.run(object, ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]));
            return new NBTContainer(object2);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while converting NMS ItemStack to NBTCompound!", exception);
        }
    }

    public static Map<String, Object> getUnhandledNBTTags(ItemMeta itemMeta) {
        try {
            return (Map)field_unhandledTags.get(itemMeta);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while getting unhandled tags from ItemMeta!", exception);
        }
    }

    public static Object getEntityNBTTagCompound(Object object) {
        try {
            Object obj = ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            Object object2 = ReflectionMethod.NMS_ENTITY_GET_NBT.run(object, obj);
            if (object2 == null) {
                object2 = obj;
            }
            return object2;
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while getting NBTCompound from NMS Entity!", exception);
        }
    }

    public static Object setEntityNBTTag(Object object, Object object2) {
        try {
            ReflectionMethod.NMS_ENTITY_SET_NBT.run(object2, object);
            return object2;
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while setting the NBTCompound of an Entity", exception);
        }
    }

    public static Object getTileEntityNBTTagCompound(BlockState blockState) {
        try {
            Object object;
            Object obj = ClassWrapper.CRAFT_WORLD.getClazz().cast(blockState.getWorld());
            Object object2 = ReflectionMethod.CRAFT_WORLD_GET_HANDLE.run(obj, new Object[0]);
            Object object3 = null;
            if (MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4) {
                object3 = ReflectionMethod.NMS_WORLD_GET_TILEENTITY_1_7_10.run(object2, blockState.getX(), blockState.getY(), blockState.getZ());
            } else {
                object = ObjectCreator.NMS_BLOCKPOSITION.getInstance(blockState.getX(), blockState.getY(), blockState.getZ());
                object3 = ReflectionMethod.NMS_WORLD_GET_TILEENTITY.run(object2, object);
            }
            object = null;
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_18_R1)) {
                object = ReflectionMethod.TILEENTITY_GET_NBT_1181.run(object3, new Object[0]);
            } else {
                object = ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
                ReflectionMethod.TILEENTITY_GET_NBT.run(object3, object);
            }
            if (object == null) {
                throw new NbtApiException("Unable to get NBTCompound from TileEntity! " + blockState + " " + object3);
            }
            return object;
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while getting NBTCompound from TileEntity!", exception);
        }
    }

    public static void setTileEntityNBTTagCompound(BlockState blockState, Object object) {
        try {
            Object object2;
            Object obj = ClassWrapper.CRAFT_WORLD.getClazz().cast(blockState.getWorld());
            Object object3 = ReflectionMethod.CRAFT_WORLD_GET_HANDLE.run(obj, new Object[0]);
            Object object4 = null;
            if (MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4) {
                object4 = ReflectionMethod.NMS_WORLD_GET_TILEENTITY_1_7_10.run(object3, blockState.getX(), blockState.getY(), blockState.getZ());
            } else {
                object2 = ObjectCreator.NMS_BLOCKPOSITION.getInstance(blockState.getX(), blockState.getY(), blockState.getZ());
                object4 = ReflectionMethod.NMS_WORLD_GET_TILEENTITY.run(object3, object2);
            }
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_17_R1)) {
                ReflectionMethod.TILEENTITY_SET_NBT.run(object4, object);
            } else if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R1)) {
                object2 = ReflectionMethod.TILEENTITY_GET_BLOCKDATA.run(object4, new Object[0]);
                ReflectionMethod.TILEENTITY_SET_NBT_LEGACY1161.run(object4, object2, object);
            } else {
                ReflectionMethod.TILEENTITY_SET_NBT_LEGACY1151.run(object4, object);
            }
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while setting NBTData for a TileEntity!", exception);
        }
    }

    public static Object getSubNBTTagCompound(Object object, String string) {
        try {
            if (((Boolean)ReflectionMethod.COMPOUND_HAS_KEY.run(object, string)).booleanValue()) {
                return ReflectionMethod.COMPOUND_GET_COMPOUND.run(object, string);
            }
            throw new NbtApiException("Tried getting invalide compound '" + string + "' from '" + object + "'!");
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while getting NBT subcompounds!", exception);
        }
    }

    public static void addNBTTagCompound(NBTCompound nBTCompound, String string) {
        if (string == null) {
            NBTReflectionUtil.remove(nBTCompound, string);
            return;
        }
        Object object = nBTCompound.getCompound();
        if (object == null) {
            object = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            return;
        }
        Object object2 = NBTReflectionUtil.gettoCompount(object, nBTCompound);
        try {
            ReflectionMethod.COMPOUND_SET.run(object2, string, ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance());
            nBTCompound.setCompound(object);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while adding a Compound!", exception);
        }
    }

    public static Boolean valideCompound(NBTCompound nBTCompound) {
        Object object = nBTCompound.getCompound();
        if (object == null) {
            object = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        return NBTReflectionUtil.gettoCompount(object, nBTCompound) != null;
    }

    protected static Object gettoCompount(Object object, NBTCompound nBTCompound) {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        while (nBTCompound.getParent() != null) {
            arrayDeque.add(nBTCompound.getName());
            nBTCompound = nBTCompound.getParent();
        }
        while (!arrayDeque.isEmpty()) {
            String string = (String)arrayDeque.pollLast();
            if ((object = NBTReflectionUtil.getSubNBTTagCompound(object, string)) != null) continue;
            throw new NbtApiException("Unable to find tag '" + string + "' in " + object);
        }
        return object;
    }

    public static void mergeOtherNBTCompound(NBTCompound nBTCompound, NBTCompound nBTCompound2) {
        Object object = nBTCompound.getCompound();
        if (object == null) {
            object = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object object2 = NBTReflectionUtil.gettoCompount(object, nBTCompound);
        Object object3 = nBTCompound2.getCompound();
        if (object3 == null) {
            object3 = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound2).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object object4 = NBTReflectionUtil.gettoCompount(object3, nBTCompound2);
        try {
            ReflectionMethod.COMPOUND_MERGE.run(object2, object4);
            nBTCompound.setCompound(object);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while merging two NBTCompounds!", exception);
        }
    }

    public static String getContent(NBTCompound nBTCompound, String string) {
        Object object = nBTCompound.getCompound();
        if (object == null) {
            object = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object object2 = NBTReflectionUtil.gettoCompount(object, nBTCompound);
        try {
            return ReflectionMethod.COMPOUND_GET.run(object2, string).toString();
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while getting the Content for key '" + string + "'!", exception);
        }
    }

    public static void set(NBTCompound nBTCompound, String string, Object object) {
        if (object == null) {
            NBTReflectionUtil.remove(nBTCompound, string);
            return;
        }
        Object object2 = nBTCompound.getCompound();
        if (object2 == null) {
            object2 = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object object3 = NBTReflectionUtil.gettoCompount(object2, nBTCompound);
        try {
            ReflectionMethod.COMPOUND_SET.run(object3, string, object);
            nBTCompound.setCompound(object2);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while setting key '" + string + "' to '" + object + "'!", exception);
        }
    }

    public static NBTType getListType(NBTCompound nBTCompound, String string) {
        Object object = nBTCompound.getCompound();
        if (object == null) {
            object = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            return null;
        }
        Object object2 = NBTReflectionUtil.gettoCompount(object, nBTCompound);
        try {
            Object object3 = ReflectionMethod.COMPOUND_GET.run(object2, string);
            String string2 = "type";
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_17_R1)) {
                string2 = "w";
            }
            Field field = object3.getClass().getDeclaredField(string2);
            field.setAccessible(true);
            return NBTType.valueOf(field.getByte(object3));
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while getting the list type!", exception);
        }
    }

    public static Object getEntry(NBTCompound nBTCompound, String string) {
        Object object = nBTCompound.getCompound();
        if (object == null) {
            object = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            return null;
        }
        Object object2 = NBTReflectionUtil.gettoCompount(object, nBTCompound);
        try {
            Object object3 = ReflectionMethod.COMPOUND_GET.run(object2, string);
            return object3;
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while getting an Entry!", exception);
        }
    }

    public static void setObject(NBTCompound nBTCompound, String string, Object object) {
        if (!MinecraftVersion.hasGsonSupport()) {
            return;
        }
        try {
            String string2 = GsonWrapper.getString(object);
            NBTReflectionUtil.setData(nBTCompound, ReflectionMethod.COMPOUND_SET_STRING, string, string2);
        }
        catch (Exception exception) {
            throw new NbtApiException("Exception while setting the Object '" + object + "'!", exception);
        }
    }

    public static <T> T getObject(NBTCompound nBTCompound, String string, Class<T> clazz) {
        if (!MinecraftVersion.hasGsonSupport()) {
            return null;
        }
        String string2 = (String)NBTReflectionUtil.getData(nBTCompound, ReflectionMethod.COMPOUND_GET_STRING, string);
        if (string2 == null) {
            return null;
        }
        return GsonWrapper.deserializeJson(string2, clazz);
    }

    public static void remove(NBTCompound nBTCompound, String string) {
        Object object = nBTCompound.getCompound();
        if (object == null) {
            object = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            return;
        }
        Object object2 = NBTReflectionUtil.gettoCompount(object, nBTCompound);
        ReflectionMethod.COMPOUND_REMOVE_KEY.run(object2, string);
        nBTCompound.setCompound(object);
    }

    public static Set<String> getKeys(NBTCompound nBTCompound) {
        Object object = nBTCompound.getCompound();
        if (object == null) {
            object = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object object2 = NBTReflectionUtil.gettoCompount(object, nBTCompound);
        return (Set)ReflectionMethod.COMPOUND_GET_KEYS.run(object2, new Object[0]);
    }

    public static void setData(NBTCompound nBTCompound, ReflectionMethod reflectionMethod, String string, Object object) {
        if (object == null) {
            NBTReflectionUtil.remove(nBTCompound, string);
            return;
        }
        Object object2 = nBTCompound.getCompound();
        if (object2 == null) {
            object2 = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object object3 = NBTReflectionUtil.gettoCompount(object2, nBTCompound);
        reflectionMethod.run(object3, string, object);
        nBTCompound.setCompound(object2);
    }

    public static Object getData(NBTCompound nBTCompound, ReflectionMethod reflectionMethod, String string) {
        Object object = nBTCompound.getCompound();
        if (object == null) {
            return null;
        }
        if (!NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object object2 = NBTReflectionUtil.gettoCompount(object, nBTCompound);
        return reflectionMethod.run(object2, string);
    }

    static {
        try {
            field_unhandledTags = ClassWrapper.CRAFT_METAITEM.getClazz().getDeclaredField("unhandledTags");
            field_unhandledTags.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

