/*
 * Decompiled with CFR 0.152.
 */
package club.josn3rdev.pl.anvilgui;

import club.josn3rdev.pl.anvilgui.version.VersionMatcher;
import club.josn3rdev.pl.anvilgui.version.VersionWrapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AnvilGUI {
    private static final VersionWrapper WRAPPER = new VersionMatcher().match();
    private static final ItemStack AIR = new ItemStack(Material.AIR);
    private final Plugin plugin;
    private final Player player;
    private final String inventoryTitle;
    private final ItemStack[] initialContents;
    private final boolean preventClose;
    private final Set<Integer> interactableSlots;
    private final Consumer<Player> closeListener;
    private final Function<Completion, List<ResponseAction>> completeFunction;
    private final Consumer<Player> inputLeftClickListener;
    private final Consumer<Player> inputRightClickListener;
    private int containerId;
    private Inventory inventory;
    private final ListenUp listener = new ListenUp();
    private boolean open;

    private AnvilGUI(Plugin plugin, Player player, String string, ItemStack[] itemStackArray, boolean bl, Set<Integer> set, Consumer<Player> consumer, Consumer<Player> consumer2, Consumer<Player> consumer3, Function<Completion, List<ResponseAction>> function) {
        this.plugin = plugin;
        this.player = player;
        this.inventoryTitle = string;
        this.initialContents = itemStackArray;
        this.preventClose = bl;
        this.interactableSlots = Collections.unmodifiableSet(set);
        this.closeListener = consumer;
        this.inputLeftClickListener = consumer2;
        this.inputRightClickListener = consumer3;
        this.completeFunction = function;
        this.openInventory();
    }

    private void openInventory() {
        WRAPPER.handleInventoryCloseEvent(this.player);
        WRAPPER.setActiveContainerDefault(this.player);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, this.plugin);
        Object object = WRAPPER.newContainerAnvil(this.player, this.inventoryTitle);
        this.inventory = WRAPPER.toBukkitInventory(object);
        for (int i = 0; i < this.initialContents.length; ++i) {
            this.inventory.setItem(i, this.initialContents[i]);
        }
        this.containerId = WRAPPER.getNextContainerId(this.player, object);
        WRAPPER.sendPacketOpenWindow(this.player, this.containerId, this.inventoryTitle);
        WRAPPER.setActiveContainer(this.player, object);
        WRAPPER.setActiveContainerId(object, this.containerId);
        WRAPPER.addActiveContainerSlotListener(object, this.player);
        this.open = true;
    }

    public void closeInventory() {
        this.closeInventory(true);
    }

    private void closeInventory(boolean bl) {
        if (!this.open) {
            return;
        }
        this.open = false;
        HandlerList.unregisterAll((Listener)this.listener);
        if (bl) {
            WRAPPER.handleInventoryCloseEvent(this.player);
            WRAPPER.setActiveContainerDefault(this.player);
            WRAPPER.sendPacketCloseWindow(this.player, this.containerId);
        }
        if (this.closeListener != null) {
            this.closeListener.accept(this.player);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack notNull(ItemStack itemStack) {
        return itemStack == null ? AIR : itemStack;
    }

    private class ListenUp
    implements Listener {
        private ListenUp() {
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
            if (!inventoryClickEvent.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                return;
            }
            Player player = (Player)inventoryClickEvent.getWhoClicked();
            Inventory inventory = inventoryClickEvent.getClickedInventory();
            if (inventory != null && inventory.equals((Object)player.getInventory()) && inventoryClickEvent.getClick().equals((Object)ClickType.DOUBLE_CLICK)) {
                inventoryClickEvent.setCancelled(true);
                return;
            }
            if (inventoryClickEvent.getRawSlot() < 3 || inventoryClickEvent.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
                int n = inventoryClickEvent.getRawSlot();
                inventoryClickEvent.setCancelled(!AnvilGUI.this.interactableSlots.contains(n));
                if (inventoryClickEvent.getRawSlot() == 2) {
                    ItemStack itemStack = AnvilGUI.this.inventory.getItem(2);
                    if (itemStack == null || itemStack.getType() == Material.AIR) {
                        return;
                    }
                    List list = (List)AnvilGUI.this.completeFunction.apply(new Completion(AnvilGUI.this.notNull(AnvilGUI.this.inventory.getItem(0)), AnvilGUI.this.notNull(AnvilGUI.this.inventory.getItem(1)), AnvilGUI.this.notNull(AnvilGUI.this.inventory.getItem(2)), AnvilGUI.this.player, itemStack.hasItemMeta() ? itemStack.getItemMeta().getDisplayName() : ""));
                    for (ResponseAction responseAction : list) {
                        responseAction.accept(AnvilGUI.this, player);
                    }
                } else if (inventoryClickEvent.getRawSlot() == 0) {
                    if (AnvilGUI.this.inputLeftClickListener != null) {
                        AnvilGUI.this.inputLeftClickListener.accept(AnvilGUI.this.player);
                    }
                } else if (inventoryClickEvent.getRawSlot() == 1 && AnvilGUI.this.inputRightClickListener != null) {
                    AnvilGUI.this.inputRightClickListener.accept(AnvilGUI.this.player);
                }
            }
        }

        @EventHandler
        public void onInventoryDrag(InventoryDragEvent inventoryDragEvent) {
            if (inventoryDragEvent.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                for (int n : Slot.values()) {
                    if (!inventoryDragEvent.getRawSlots().contains(n)) continue;
                    inventoryDragEvent.setCancelled(!AnvilGUI.this.interactableSlots.contains(n));
                    break;
                }
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
            if (AnvilGUI.this.open && inventoryCloseEvent.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                AnvilGUI.this.closeInventory(false);
                if (AnvilGUI.this.preventClose) {
                    Bukkit.getScheduler().runTask(AnvilGUI.this.plugin, () -> AnvilGUI.this.openInventory());
                }
            }
        }
    }

    public static final class Completion {
        private final ItemStack leftItem;
        private final ItemStack rightItem;
        private final ItemStack outputItem;
        private final Player player;
        private final String text;

        public Completion(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, Player player, String string) {
            this.leftItem = itemStack;
            this.rightItem = itemStack2;
            this.outputItem = itemStack3;
            this.player = player;
            this.text = string;
        }

        public ItemStack getLeftItem() {
            return this.leftItem;
        }

        public ItemStack getRightItem() {
            return this.rightItem;
        }

        public ItemStack getOutputItem() {
            return this.outputItem;
        }

        public Player getPlayer() {
            return this.player;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Slot {
        private static final int[] values = new int[]{0, 1, 2};
        public static final int INPUT_LEFT = 0;
        public static final int INPUT_RIGHT = 1;
        public static final int OUTPUT = 2;

        public static int[] values() {
            return values;
        }
    }

    @Deprecated
    public static class Response {
        public static List<ResponseAction> close() {
            return Arrays.asList(ResponseAction.close());
        }

        public static List<ResponseAction> text(String string) {
            return Arrays.asList(ResponseAction.replaceInputText(string));
        }

        public static List<ResponseAction> openInventory(Inventory inventory) {
            return Arrays.asList(ResponseAction.openInventory(inventory));
        }
    }

    public static interface ResponseAction
    extends BiConsumer<AnvilGUI, Player> {
        public static ResponseAction replaceInputText(String text) {
            return (anvilgui, player) -> {
                ItemStack outputSlotItem = anvilgui.getInventory().getItem(2).clone();
                ItemMeta meta = outputSlotItem.getItemMeta();
                meta.setDisplayName(text);
                outputSlotItem.setItemMeta(meta);
                anvilgui.getInventory().setItem(0, outputSlotItem);
            };
        }

        public static ResponseAction openInventory(Inventory otherInventory) {
            return (anvigui, player) -> player.openInventory(otherInventory);
        }

        public static ResponseAction close() {
            return (anvilgui, player) -> anvilgui.closeInventory();
        }

        public static ResponseAction run(Runnable runnable) {
            return (anvilgui, player) -> runnable.run();
        }
    }

    public static class Builder {
        private Consumer<Player> closeListener;
        private boolean preventClose = false;
        private Set<Integer> interactableSlots = Collections.emptySet();
        private Consumer<Player> inputLeftClickListener;
        private Consumer<Player> inputRightClickListener;
        private Function<Completion, List<ResponseAction>> completeFunction;
        private Plugin plugin;
        private String title = "Repair & Name";
        private String itemText;
        private ItemStack itemLeft;
        private ItemStack itemRight;
        private ItemStack itemOutput;

        public Builder preventClose() {
            this.preventClose = true;
            return this;
        }

        public Builder interactableSlots(int ... nArray) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n : nArray) {
                hashSet.add(n);
            }
            this.interactableSlots = hashSet;
            return this;
        }

        public Builder onClose(Consumer<Player> consumer) {
            Validate.notNull(consumer, (String)"closeListener cannot be null");
            this.closeListener = consumer;
            return this;
        }

        public Builder onLeftInputClick(Consumer<Player> consumer) {
            this.inputLeftClickListener = consumer;
            return this;
        }

        public Builder onRightInputClick(Consumer<Player> consumer) {
            this.inputRightClickListener = consumer;
            return this;
        }

        @Deprecated
        public Builder onComplete(BiFunction<Player, String, List<ResponseAction>> biFunction) {
            Validate.notNull(biFunction, (String)"Complete function cannot be null");
            this.completeFunction = completion -> (List)biFunction.apply(((Completion)completion).player, ((Completion)completion).text);
            return this;
        }

        public Builder onComplete(Function<Completion, List<ResponseAction>> function) {
            Validate.notNull(function, (String)"Complete function cannot be null");
            this.completeFunction = function;
            return this;
        }

        public Builder plugin(Plugin plugin) {
            Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
            this.plugin = plugin;
            return this;
        }

        public Builder text(String string) {
            Validate.notNull((Object)string, (String)"Text cannot be null");
            this.itemText = string;
            return this;
        }

        public Builder title(String string) {
            Validate.notNull((Object)string, (String)"title cannot be null");
            this.title = string;
            return this;
        }

        @Deprecated
        public Builder item(ItemStack itemStack) {
            return this.itemLeft(itemStack);
        }

        public Builder itemLeft(ItemStack itemStack) {
            Validate.notNull((Object)itemStack, (String)"item cannot be null");
            this.itemLeft = itemStack;
            return this;
        }

        public Builder itemRight(ItemStack itemStack) {
            this.itemRight = itemStack;
            return this;
        }

        public Builder itemOutput(ItemStack itemStack) {
            this.itemOutput = itemStack;
            return this;
        }

        public AnvilGUI open(Player player) {
            Validate.notNull((Object)this.plugin, (String)"Plugin cannot be null");
            Validate.notNull(this.completeFunction, (String)"Complete function cannot be null");
            Validate.notNull((Object)player, (String)"Player cannot be null");
            if (this.itemText != null) {
                if (this.itemLeft == null) {
                    this.itemLeft = new ItemStack(Material.PAPER);
                }
                ItemMeta itemMeta = this.itemLeft.getItemMeta();
                itemMeta.setDisplayName(this.itemText);
                this.itemLeft.setItemMeta(itemMeta);
            }
            return new AnvilGUI(this.plugin, player, this.title, new ItemStack[]{this.itemLeft, this.itemRight, this.itemOutput}, this.preventClose, this.interactableSlots, this.closeListener, this.inputLeftClickListener, this.inputRightClickListener, this.completeFunction);
        }
    }
}

