/*
 * Decompiled with CFR 0.152.
 */
package me.josn3r.plugin.controller;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import me.josn3r.plugin.Airdrop;
import me.josn3r.plugin.controller.ScatterManager;
import me.josn3r.plugin.enums.AirdropState;
import me.josn3r.plugin.enums.AirdropType;
import me.josn3r.plugin.task.AirdropTask;
import me.josn3r.plugin.task.AirdropTaskComing;
import me.josn3r.plugin.task.AirdropTaskToRemove;
import me.josn3r.plugin.task.RadiationTask;
import me.josn3r.plugin.utils.Tools;
import me.josn3r.plugin.utils.Vault;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class AirdropManager {
    private final List<DropItems> airdropComun = Lists.newArrayList();
    private final List<DropItems> airdropRaro = Lists.newArrayList();
    private final List<DropItems> airdropLegend = Lists.newArrayList();
    private final Random random = new Random();
    public static Location airdropLocation;
    public static Block airdropChest;
    public static Boolean isOpen;
    public static Boolean forceAirdrop;
    public static AirdropType type;
    public static AirdropState state;
    public static Integer airdropEvery;
    public static Integer airdropComing;
    public static Integer airdropTimeToRemove;

    public AirdropManager(Airdrop airdrop) {
        this.load();
    }

    public static void startAirdropTask() {
        airdropEvery = Airdrop.get().getConfig().getInt("config.cooldowns.airdrop-summon-every");
        airdropComing = Airdrop.get().getConfig().getInt("config.cooldowns.airdrop-coming-time");
        airdropTimeToRemove = Airdrop.get().getConfig().getInt("config.cooldowns.airdrop-time-to-remove");
        isOpen = false;
        airdropLocation = null;
        state = AirdropState.COUNTDOWN;
        new AirdropTask(Airdrop.get()).runTaskTimer((Plugin)Airdrop.get(), 0L, 20L);
    }

    public static void resetAirdrop() {
        Tools.get().deleteHologramTB();
        AirdropManager.startAirdropTask();
    }

    public AirdropType getTypeAirdrop() {
        return type;
    }

    public AirdropState getStateAirdrop() {
        return state;
    }

    public String getAirdropCooldown() {
        String string = "";
        if (state == AirdropState.COUNTDOWN) {
            string = Tools.get().getFormatTime(airdropEvery);
        } else if (state == AirdropState.COMING) {
            string = Tools.get().getFormatTime(airdropComing);
        } else if (state == AirdropState.GROUND) {
            string = Tools.get().getFormatTime(airdropTimeToRemove);
        }
        return string;
    }

    public String getAirdropLocationPAPI() {
        String string = "";
        string = state == AirdropState.COUNTDOWN ? Tools.get().getFormatTime(airdropEvery) : Tools.get().formatLocation(airdropLocation);
        return string;
    }

    public static String getAirdropType() {
        if (type == AirdropType.COMUN) {
            return Airdrop.get().getConfig().getString("config.airdrop-config.type-name.common");
        }
        if (type == AirdropType.RARO) {
            return Airdrop.get().getConfig().getString("config.airdrop-config.type-name.rare");
        }
        if (type == AirdropType.LEGEND) {
            return Airdrop.get().getConfig().getString("config.airdrop-config.type-name.legendary");
        }
        return "ERROR";
    }

    public static void comingAirdrop() {
        airdropLocation = ScatterManager.getRandomLocation();
        if (airdropLocation == null) {
            Airdrop.debug("&cAirdrop has been canceled due to no find good location.");
            AirdropManager.startAirdropTask();
            return;
        }
        Double d = new Random().nextDouble(100.0);
        Double d2 = Airdrop.get().getConfig().getDouble("config.airdrop-config.type-percent.common");
        Double d3 = Airdrop.get().getConfig().getDouble("config.airdrop-config.type-percent.rare");
        Double d4 = Airdrop.get().getConfig().getDouble("config.airdrop-config.type-percent.legendary");
        if (d < d4) {
            type = AirdropType.LEGEND;
        } else if (d < d3) {
            type = AirdropType.RARO;
        } else if (d < d2) {
            type = AirdropType.COMUN;
        }
        if (Airdrop.lang.getBoolean("messages.airdrop.titles.enable")) {
            String[] stringArray = Airdrop.lang.getString("messages.airdrop.titles.airdrop-coming").split(" : ");
            for (Player player : Bukkit.getOnlinePlayers()) {
                Tools.get().playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, Float.valueOf(10.0f), Float.valueOf(10.0f));
                Tools.get().sendTitle(player, (String)stringArray[0], (String)stringArray[1], 60);
            }
        }
        if (Airdrop.lang.getBoolean("messages.airdrop.chat-message")) {
            for (String string : Airdrop.lang.getStringList("messages.airdrop.airdrop-arrived")) {
                String string2 = string.replace("<TYPE>", AirdropManager.getAirdropType()).replace("<LOCATION>", Tools.get().formatLocation(airdropLocation)).replace("<TIME>", Tools.get().getFormatTime(airdropTimeToRemove));
                Bukkit.broadcastMessage((String)Tools.get().Text(Airdrop.PREFIX + string2));
            }
        }
        airdropLocation = airdropLocation.add(0.0, 1.0, 0.0);
        state = AirdropState.COMING;
        new AirdropTaskComing(Airdrop.get()).runTaskTimer((Plugin)Airdrop.get(), 0L, 20L);
    }

    public static void dropAirdrop() {
        if (Airdrop.lang.getBoolean("messages.airdrop.titles.enable")) {
            String[] stringArray = Airdrop.lang.getString("messages.airdrop.titles.airdrop-coming").split(" : ");
            for (Player player : Bukkit.getOnlinePlayers()) {
                Tools.get().playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, Float.valueOf(10.0f), Float.valueOf(10.0f));
                Tools.get().sendTitle(player, (String)stringArray[0], (String)stringArray[1], 60);
            }
        }
        if (Airdrop.lang.getBoolean("messages.airdrop.chat-message")) {
            for (String string : Airdrop.lang.getStringList("messages.airdrop.airdrop-arrived")) {
                String string2 = string.replace("<TYPE>", AirdropManager.getAirdropType()).replace("<LOCATION>", Tools.get().formatLocation(airdropLocation)).replace("<TIME>", Tools.get().getFormatTime(airdropTimeToRemove));
                Bukkit.broadcastMessage((String)Tools.get().Text(Airdrop.PREFIX + string2));
            }
        }
        airdropLocation.getBlock().setType(Material.CHEST);
        airdropLocation.getWorld().getBlockAt(airdropLocation).setMetadata("isPackage", (MetadataValue)new FixedMetadataValue((Plugin)Airdrop.get(), (Object)true));
        airdropChest = airdropLocation.getBlock();
        if (Airdrop.lang.getBoolean("messages.holograms.enable")) {
            Tools.get().createHologram(airdropLocation);
        }
        state = AirdropState.GROUND;
        new AirdropTaskToRemove(Airdrop.get()).runTaskTimer((Plugin)Airdrop.get(), 0L, 20L);
        if (Airdrop.get().getConfig().getBoolean("config.airdrop-options.radiation.enable")) {
            new RadiationTask(airdropLocation).runTaskTimer((Plugin)Airdrop.get(), 0L, 20L);
        }
    }

    public static void destroyAirdrop() {
        Airdrop.debug("Destroying Airdrop");
        Location location = airdropLocation;
        Tools.get().summonFirework(airdropLocation);
        Tools.get().playSound(location, Sound.ENTITY_IRON_GOLEM_STEP, Float.valueOf(1.0f), Float.valueOf(1.0f));
        airdropChest.setType(Material.AIR);
    }

    public void load() {
        Object object;
        String string;
        Double d;
        this.airdropComun.clear();
        this.airdropRaro.clear();
        this.airdropLegend.clear();
        if (Airdrop.airdrop.getConfig().contains("airdrops.common")) {
            for (String string2 : Airdrop.airdrop.getConfig().getStringList("airdrops.common")) {
                d = Double.parseDouble(string2.split(" : ")[0]);
                string = string2.split(" : ")[1];
                if (string.equalsIgnoreCase("MONEY")) {
                    object = Double.parseDouble(string2.split(" : ")[2]);
                    this.airdropComun.add(new DropItems("MONEY", d, (Double)object, null, null));
                    continue;
                }
                if (string.equalsIgnoreCase("COMMAND")) {
                    object = string2.split(" : ")[2];
                    this.airdropComun.add(new DropItems("COMMAND", d, null, (String)object, null));
                    continue;
                }
                object = Tools.get().decode(string);
                if (object == null) continue;
                this.airdropComun.add(new DropItems("ITEM", d, null, null, (ItemStack)object));
            }
        }
        if (Airdrop.airdrop.getConfig().contains("airdrops.rare")) {
            for (String string2 : Airdrop.airdrop.getConfig().getStringList("airdrops.rare")) {
                d = Double.parseDouble(string2.split(" : ")[0]);
                string = string2.split(" : ")[1];
                if (string.equalsIgnoreCase("MONEY")) {
                    object = Double.parseDouble(string2.split(" : ")[2]);
                    this.airdropRaro.add(new DropItems("MONEY", d, (Double)object, null, null));
                    continue;
                }
                if (string.equalsIgnoreCase("COMMAND")) {
                    object = string2.split(" : ")[2];
                    this.airdropRaro.add(new DropItems("COMMAND", d, null, (String)object, null));
                    continue;
                }
                object = Tools.get().decode(string);
                if (object == null) continue;
                this.airdropRaro.add(new DropItems("ITEM", d, null, null, (ItemStack)object));
            }
        }
        if (Airdrop.airdrop.getConfig().contains("airdrops.legendary")) {
            for (String string2 : Airdrop.airdrop.getConfig().getStringList("airdrops.legendary")) {
                d = Double.parseDouble(string2.split(" : ")[0]);
                string = string2.split(" : ")[1];
                if (string.equalsIgnoreCase("MONEY")) {
                    object = Double.parseDouble(string2.split(" : ")[2]);
                    this.airdropLegend.add(new DropItems("MONEY", d, (Double)object, null, null));
                    continue;
                }
                if (string.equalsIgnoreCase("COMMAND")) {
                    object = string2.split(" : ")[2];
                    this.airdropLegend.add(new DropItems("COMMAND", d, null, (String)object, null));
                    continue;
                }
                object = Tools.get().decode(string);
                if (object == null) continue;
                this.airdropLegend.add(new DropItems("ITEM", d, null, null, (ItemStack)object));
            }
        }
        Airdrop.debug("Airdrops items (re)loaded. " + this.airdropComun.size() + " common items, " + this.airdropRaro.size() + " rare items, " + this.airdropLegend.size() + " legendary items");
    }

    public void dropItems(Player player, Location location, AirdropType airdropType) {
        Double d;
        Integer n;
        if (airdropType == AirdropType.COMUN) {
            n = 4;
            for (DropItems dropItems : this.airdropComun) {
                d = this.random.nextDouble(100.0);
                if (!(d <= dropItems.getChance())) continue;
                if (dropItems.getType().equals("MONEY")) {
                    Vault.setMoney(player, (double)dropItems.getValue());
                } else if (dropItems.getType().equals("COMMAND")) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)dropItems.getCommand().replace("<PLAYER>", player.getName()));
                } else {
                    location.getWorld().dropItemNaturally(location, dropItems.getItem());
                }
                if ((n = Integer.valueOf(n - 1)) > 0) continue;
                break;
            }
        }
        if (airdropType == AirdropType.RARO) {
            n = 4;
            for (DropItems dropItems : this.airdropRaro) {
                d = this.random.nextDouble(100.0);
                if (!(d <= dropItems.getChance())) continue;
                if (dropItems.getType().equals("MONEY")) {
                    Vault.setMoney(player, (double)dropItems.getValue());
                } else if (dropItems.getType().equals("COMMAND")) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)dropItems.getCommand().replace("<PLAYER>", player.getName()));
                } else {
                    location.getWorld().dropItemNaturally(location, dropItems.getItem());
                }
                if ((n = Integer.valueOf(n - 1)) > 0) continue;
                break;
            }
        }
        if (airdropType == AirdropType.LEGEND) {
            n = 6;
            for (DropItems dropItems : this.airdropLegend) {
                d = this.random.nextDouble(100.0);
                if (!(d <= dropItems.getChance())) continue;
                if (dropItems.getType().equals("MONEY")) {
                    Vault.setMoney(player, (double)dropItems.getValue());
                } else if (dropItems.getType().equals("COMMAND")) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)dropItems.getCommand().replace("<PLAYER>", player.getName()));
                } else {
                    location.getWorld().dropItemNaturally(location, dropItems.getItem());
                }
                if ((n = Integer.valueOf(n - 1)) > 0) continue;
                break;
            }
        }
    }

    public Location getAirdropLocation() {
        return airdropLocation;
    }

    static {
        isOpen = false;
        forceAirdrop = false;
    }

    public class DropItems {
        private String type;
        private Double chance;
        private Double value;
        private String command;
        private ItemStack item;

        public DropItems(String string, Double d, Double d2, String string2, ItemStack itemStack) {
            this.type = string;
            this.chance = d;
            this.value = d2;
            this.command = string2;
            this.item = itemStack;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public Double getChance() {
            return this.chance;
        }

        public String getType() {
            return this.type;
        }

        public Double getValue() {
            return this.value;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

