/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsoplus;

import com.alonsoaliaga.alonsoplus.commands.MainCommand;
import com.alonsoaliaga.alonsoplus.commands.RankCommand;
import com.alonsoaliaga.alonsoplus.hooks.PlaceholderAPIHook;
import com.alonsoaliaga.alonsoplus.listeners.ChatListener;
import com.alonsoaliaga.alonsoplus.listeners.ClickListener;
import com.alonsoaliaga.alonsoplus.listeners.ConnectionListener;
import com.alonsoaliaga.alonsoplus.metrics.Metrics;
import com.alonsoaliaga.alonsoplus.others.ColorData;
import com.alonsoaliaga.alonsoplus.others.Colors;
import com.alonsoaliaga.alonsoplus.others.CommandData;
import com.alonsoaliaga.alonsoplus.others.Database;
import com.alonsoaliaga.alonsoplus.others.FileManager;
import com.alonsoaliaga.alonsoplus.others.Messages;
import com.alonsoaliaga.alonsoplus.others.Permissions;
import com.alonsoaliaga.alonsoplus.others.PlayerData;
import com.alonsoaliaga.alonsoplus.others.PlusHolder;
import com.alonsoaliaga.alonsoplus.others.RankData;
import com.alonsoaliaga.alonsoplus.utils.AlonsoUtils;
import com.alonsoaliaga.alonsoplus.utils.ItemUtils;
import com.alonsoaliaga.alonsoplus.utils.LocalUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AlonsoPlus
extends JavaPlugin
implements AlonsoUtils.AlonsoPlugin {
    private static AlonsoPlus instance;
    private AlonsoUtils.PluginUtils pluginUtils;
    private FileManager fileManager;
    private AlonsoUtils.Updater updater = null;
    public MainCommand mainCommand;
    public RankCommand rankCommand;
    public Messages messages;
    public Permissions permissions;
    private int bStatsID = 9606;
    private String resourceID = "86621";
    public Database.Data database;
    public BukkitTask keepAliveTask = null;
    public int keepAliveInterval = 30;
    public boolean debugMode = false;
    public boolean logMode = false;
    public boolean instantUpdate = false;
    public boolean closeItemClose;
    public boolean backItemClose;
    public boolean closeOnSelect;
    public boolean frameEnabled;
    private HashMap<Integer, ColorData> colorsSlotsMap;
    private HashMap<String, ColorData> colorsMap;
    private HashMap<UUID, PlayerData> dataMap;
    public int rows;
    public int backSlot;
    public int closeSlot;
    public ItemStack closeItem;
    public ItemStack backItem;
    public ItemStack frameItem;
    public CommandData backItemCommand = null;
    public CommandData closeItemCommand = null;
    public ClickListener clickListener;
    public ConnectionListener connectionListener;
    public ChatListener chatListener;
    public ColorData colorData = null;
    public Metrics metrics;
    public boolean customPlaceholderEnabled = false;
    public boolean chatCompatibility = false;
    public boolean hikariCPEnabled = false;
    public boolean mysqlEnabled = false;
    public int joinDelay = 20;
    public HashMap<String, RankData> rankMap = new HashMap();
    private final String HEADER = "                 _   _                  ___ _                         Our plugins: https://alonsoaliaga.com/plugins\n                /_\\ | |___ _ _  ___ ___| _ \\ |_  _ ___                Support server: https://alonsoaliaga.com/discord\n               / _ \\| / _ \\ ' \\(_-</ _ \\  _/ | || (_-<                Youtube: https://alonsoaliaga.com/play\n              /_/ \\_\\_\\___/_||_/__/\\___/_| |_|\\_,_/__/                Test server: plugins.alonsoaliaga.com\n                           by AlonsoAliaga                            Twitch: https://alonsoaliaga.com/twitch\n        Considering donating? https://alonsoaliaga.com/donate         Thanks for purchasing my plugin! Only buyers receive support <3\n\n                         >> If your spigot profile link is not https://www.spigotmc.org/members/997807/\n               consider purchasing our plugin from https://alonsoaliaga.com/AlonsoPlus to support our hard work. <<\n ======================================================================================================================================\n |              Downloaded this jar in a server setup? Tell the author he is NOT allowed to upload someone else work!                 |\n |   Update to latest version as soon as possible. Support WON'T be given when using old versions. Specially from downloaded setups.  |\n | Remember: Support is only provided for .jar files downloaded DIRECTLY from spigotmc.org! Other files will be considered as invalid |\n |        as they are NOT the same .jar file the developer (me) uploaded and I cannot guarantee that the file is safe or not.         |\n |                   If you have issues with setup configs. Tell the setup author to update his config file.                          |\n |                         Download original plugin directly from https://alonsoaliaga.com/AlonsoPlus                                 |\n ======================================================================================================================================";

    public void onEnable() {
        AlonsoPlus.loadConfig0();
        instance = this;
        this.dataMap = new HashMap();
        AlonsoUtils.sendEnableText(this);
        AlonsoUtils.isSupported();
        this.pluginUtils = new AlonsoUtils.PluginUtils(this);
        this.fileManager = new FileManager(this);
        this.updateConfigurations();
        String string = this.getFiles().getConfig().get().getString("Database.Type", "sqlite");
        if (string.equalsIgnoreCase("mysql") || string.equalsIgnoreCase("hikaricp")) {
            Database database = new Database();
            database.getClass();
            this.database = new Database.HikariCP(database, this);
            this.hikariCPEnabled = true;
            this.mysqlEnabled = false;
        } else if (string.equalsIgnoreCase("iwantmysql")) {
            Database database = new Database();
            database.getClass();
            this.database = new Database.MySQL(database, this);
            this.hikariCPEnabled = false;
            this.mysqlEnabled = true;
        } else {
            Database database = new Database();
            database.getClass();
            this.database = new Database.SQLite(database, this);
            this.hikariCPEnabled = false;
            this.mysqlEnabled = false;
        }
        this.reloadMessages();
        this.loadColors();
        this.mainCommand = new MainCommand(this, this.getFiles().getConfig().get().getString("Options.Command.Main", "alonsoplus"), this.getFiles().getConfig().get().getStringList("Options.Command.Aliases"), "AlonsoPlus main command.");
        this.rankCommand = new RankCommand(this, this.getFiles().getConfig().get().getString("Options.Rank-color.Main", "rankcolor"), this.getFiles().getConfig().get().getStringList("Options.Rank-color.Aliases"), "RankColor main command.");
        this.messages = new Messages(this);
        this.permissions = new Permissions(this);
        this.clickListener = new ClickListener(this);
        this.connectionListener = new ConnectionListener(this);
        this.chatListener = new ChatListener(this);
        if (this.pluginUtils.isPlaceholderApiSupported()) {
            new PlaceholderAPIHook(this, "alonsoplus");
        }
        if (this.bStatsID != 0) {
            this.metrics = new Metrics((Plugin)this, this.bStatsID);
            this.metrics.addCustomChart(new Metrics.SimplePie("server_type", () -> LocalUtils.firstCase(AlonsoUtils.serverVersion.name())));
            this.metrics.addCustomChart(new Metrics.SimplePie("protocollib_hooked", () -> this.pluginUtils.isProtocolLibSupported() ? "Yes" : "No"));
            this.metrics.addCustomChart(new Metrics.SimplePie("placeholderapi_hooked", () -> this.pluginUtils.isPlaceholderApiSupported() ? "Yes" : "No"));
            this.metrics.addCustomChart(new Metrics.SimplePie("nbtapi_hooked", () -> this.pluginUtils.isNbtApiSupported() ? "Yes" : "No"));
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.metrics.addCustomChart(new Metrics.AdvancedPie("plugins_from_alonsoaliaga", () -> {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (Plugin plugin : this.getServer().getPluginManager().getPlugins()) {
                    if (!plugin.getDescription().getAuthors().contains("AlonsoAliaga") || plugin.getName().equalsIgnoreCase(this.getDescription().getName())) continue;
                    hashMap.put(plugin.getName(), 1);
                }
                return hashMap;
            })), 1200L);
        }
        if (this.getFiles().getConfig().get().getBoolean("Updates.Check-updates", true)) {
            this.updater = new AlonsoUtils.Updater(this, this.resourceID, this.getFiles().getConfig().get().getBoolean("Updates.Notify-updates", true), this.getFiles().getConfig().get().getString("Updates.Permission", null), this.getFiles().getConfig().get().getString("Updates.Message", null));
        }
    }

    public void loadColors() {
        this.colorsSlotsMap = new HashMap();
        this.colorsMap = new HashMap();
        ConfigurationSection configurationSection = this.getFiles().getColors().get().getConfigurationSection("Colors");
        if (configurationSection != null) {
            ColorData colorData = null;
            for (String object : configurationSection.getKeys(false)) {
                LocalUtils.logp("Loading '" + object + "' color..");
                ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(object);
                int n = configurationSection2.getInt("Slot", -1);
                if (n >= this.rows * 9 || n <= -1) {
                    LocalUtils.logp("Slot for color '" + object + "' is not valid or is out of bounds.");
                    continue;
                }
                String string = configurationSection2.getString("Color", "&f");
                String string2 = LocalUtils.colorize(string);
                boolean bl = configurationSection2.getBoolean("Default", false);
                String string3 = configurationSection2.getString("Permission", "none");
                string3 = string3.equalsIgnoreCase("none") ? null : string3;
                String string4 = LocalUtils.colorize(configurationSection2.getString("Messages.Locked", "&cYou haven't unlocked (or claimed) that yet!"));
                String string5 = LocalUtils.colorize(configurationSection2.getString("Messages.Selected", "&aSelected! Your rank looks like this now: &bMVP{COLOR}+&b!").replace("{COLOR}", string2));
                String string6 = LocalUtils.colorize(configurationSection2.getString("Messages.Already-selected", "&cYou already have that selected!"));
                ItemStack itemStack = this.createColorItem(configurationSection2.getConfigurationSection("Items.Locked"));
                List<String> list = LocalUtils.colorize(configurationSection2.getStringList("Items.Locked.Lore"));
                ItemStack itemStack2 = this.createColorItem(configurationSection2.getConfigurationSection("Items.Unlocked"));
                List<String> list2 = LocalUtils.colorize(configurationSection2.getStringList("Items.Unlocked.Lore"));
                ItemStack itemStack3 = this.createColorItem(configurationSection2.getConfigurationSection("Items.Selected"));
                List<String> list3 = LocalUtils.colorize(configurationSection2.getStringList("Items.Selected.Lore"));
                if (colorData != null) {
                    bl = false;
                }
                ColorData colorData2 = new ColorData(object, n, string, string2, string3, bl, itemStack, itemStack2, itemStack3, list, list2, list3, string4, string5, string6);
                if (bl) {
                    colorData = colorData2;
                }
                this.colorsSlotsMap.put(n, colorData2);
                this.colorsMap.put(object.toLowerCase(), colorData2);
                LocalUtils.logp("Successfully loaded " + object + " color!");
            }
            if (colorData == null) {
                Optional<ColorData> optional = this.colorsMap.values().stream().min(Comparator.comparingInt(ColorData::getSlot));
                if (optional.isPresent()) {
                    colorData = (ColorData)optional.get();
                } else {
                    LocalUtils.loge("There isn't any color registered in colors.yml! Disabling plugin..");
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    return;
                }
            }
            this.colorData = colorData;
            for (ColorData colorData3 : this.colorsSlotsMap.values()) {
                colorData3.buildDefaultColor(colorData.getColor());
            }
        } else {
            LocalUtils.loge("There isn't any color registered in colors.yml! Disabling plugin..");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
    }

    public HashMap<Integer, ColorData> getColorsSlotsMap() {
        return this.colorsSlotsMap;
    }

    public HashMap<String, ColorData> getColorsMap() {
        return this.colorsMap;
    }

    public HashMap<UUID, PlayerData> getDataMap() {
        return this.dataMap;
    }

    public Database.Data getDatabase() {
        return this.database;
    }

    private ItemStack createColorItem(ConfigurationSection configurationSection) {
        int n;
        ItemMeta itemMeta;
        ItemStack itemStack;
        String string = configurationSection.getString("Material", "CUSTOM_HEAD");
        if (string.equals("CUSTOM_HEAD")) {
            if (this.pluginUtils.isNbtApiSupported()) {
                itemStack = ItemUtils.buildHead(configurationSection.getString("Texture", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0="));
            } else {
                LocalUtils.logp("The material for an item was 'CUSTOM_HEAD' but NBTAPI is not installed. Using COBBLESTONE material..");
                itemStack = new ItemStack(Material.COBBLESTONE);
            }
        } else {
            Material material;
            itemMeta = string.split(":");
            if (((String[])itemMeta).length >= 2) {
                string = itemMeta[0];
                try {
                    short s = (short)Math.max(0, Short.parseShort((String)itemMeta[1]));
                    material = LocalUtils.getMaterial(string, Material.COBBLESTONE);
                    itemStack = new ItemStack(material, 1, s);
                }
                catch (Throwable throwable) {
                    material = LocalUtils.getMaterial(string, Material.COBBLESTONE);
                    itemStack = new ItemStack(material);
                }
            } else {
                material = LocalUtils.getMaterial(string, Material.COBBLESTONE);
                itemStack = new ItemStack(material);
            }
        }
        itemMeta = itemStack.getItemMeta();
        int n2 = n = this.pluginUtils.isCustomModelSupported() ? Math.max(0, configurationSection.getInt("Custom-model-data", 0)) : 0;
        if (n != 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n));
        }
        itemMeta.setDisplayName(LocalUtils.colorize(configurationSection.getString("Displayname", "&cUnknown color")));
        itemMeta.addItemFlags(ItemFlag.values());
        if (configurationSection.getBoolean("Glow", false)) {
            itemStack.setItemMeta(itemMeta);
            itemStack.addUnsafeEnchantment(itemStack.getType().name().toLowerCase().contains("shield") ? Enchantment.MENDING : Enchantment.LURE, 1);
        } else {
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    private ItemStack createItem(ConfigurationSection configurationSection, Material material) {
        int n;
        ItemMeta itemMeta;
        ItemStack itemStack;
        String string = configurationSection.getString("Material", "CUSTOM_HEAD");
        if (string.equals("CUSTOM_HEAD")) {
            if (this.pluginUtils.isNbtApiSupported()) {
                itemStack = ItemUtils.buildHead(configurationSection.getString("Texture", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0="));
            } else {
                LocalUtils.logp("The material for an item was 'CUSTOM_HEAD' but NBTAPI is not installed. Using COBBLESTONE material..");
                itemStack = new ItemStack(material);
            }
        } else {
            Material material2;
            itemMeta = string.split(":");
            if (((String[])itemMeta).length >= 2) {
                string = itemMeta[0];
                try {
                    short s = (short)Math.max(0, Short.parseShort((String)itemMeta[1]));
                    material2 = LocalUtils.getMaterial(string, material);
                    itemStack = new ItemStack(material2, 1, s);
                }
                catch (Throwable throwable) {
                    material2 = LocalUtils.getMaterial(string, material);
                    itemStack = new ItemStack(material2);
                }
            } else {
                material2 = LocalUtils.getMaterial(string, material);
                itemStack = new ItemStack(material2);
            }
        }
        itemMeta = itemStack.getItemMeta();
        int n2 = n = this.pluginUtils.isCustomModelSupported() ? Math.max(0, configurationSection.getInt("Custom-model-data", 0)) : 0;
        if (n != 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n));
        }
        itemMeta.setDisplayName(LocalUtils.colorize(configurationSection.getString("Displayname", "&cUnknown color")));
        itemMeta.setLore(LocalUtils.colorize(configurationSection.getStringList("Lore")));
        itemMeta.addItemFlags(ItemFlag.values());
        if (configurationSection.getBoolean("Glow", false)) {
            itemStack.setItemMeta(itemMeta);
            itemStack.addUnsafeEnchantment(itemStack.getType().name().toLowerCase().contains("shield") ? Enchantment.MENDING : Enchantment.LURE, 1);
        } else {
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public void onDisable() {
        this.closeInventories();
        for (PlayerData playerData : this.dataMap.values()) {
            if (!playerData.isModified()) continue;
            this.connectionListener.savePlayer(playerData, true);
        }
        AlonsoUtils.sendDisableText();
    }

    public void closeInventories() {
        for (Player player : this.getServer().getOnlinePlayers()) {
            try {
                if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof PlusHolder)) continue;
                player.closeInventory();
            }
            catch (Throwable throwable) {
                player.closeInventory();
            }
        }
    }

    @Override
    public AlonsoPlus getMain() {
        return this;
    }

    public void reloadMessages() {
        int n;
        LocalUtils.setFixColors(this.getFiles().getConfig().get().getBoolean("Options.Compatibility.Hex-color-fix", true));
        this.debugMode = this.getFiles().getConfig().get().getBoolean("Options.Debug", false);
        this.logMode = this.getFiles().getConfig().get().getBoolean("Options.Log-mode", true);
        this.instantUpdate = this.getFiles().getConfig().get().getBoolean("Options.Instant-update", true);
        this.chatCompatibility = this.pluginUtils.isPlaceholderApiSupported() && this.getFiles().getConfig().get().getBoolean("Options.Compatibility.Chat", false);
        this.keepAliveInterval = Math.max(5, this.getFiles().getConfig().get().getInt("Database.Keep-connection-interval", 30)) * 1200;
        this.joinDelay = Math.max(0, this.getFiles().getConfig().get().getInt("Options.Data-delay", 20));
        this.closeOnSelect = this.getFiles().getConfig().get().getBoolean("Options.Gui.Close-on-select", false);
        this.frameEnabled = this.getFiles().getConfig().get().getBoolean("Items.Frame.Enabled", false);
        this.rows = Math.max(1, Math.min(6, this.getFiles().getConfig().get().getInt("Options.Gui.Rows", 5)));
        this.backSlot = Math.max(-1, this.getFiles().getConfig().get().getInt("Items.Back.Slot", 40));
        if (this.backSlot > this.rows * 9 - 1 || this.backSlot < 0) {
            this.backSlot = -1;
        }
        this.closeSlot = Math.max(-1, this.getFiles().getConfig().get().getInt("Items.Close.Slot", 39));
        if (this.closeSlot > this.rows * 9 - 1 || this.closeSlot < 0) {
            this.closeSlot = -1;
        }
        if (this.logMode) {
            LocalUtils.logp("Back slot is: " + this.backSlot + " | Close slot is: " + this.closeSlot);
        }
        Colors colors = Colors.getByName(this.getFiles().getConfig().get().getString("Items.Frame.Color", "BLACK"), Colors.BLACK);
        try {
            this.frameItem = new ItemStack(Material.valueOf((String)(colors.getName() + "_STAINED_GLASS_PANE")));
        }
        catch (Throwable throwable) {
            this.frameItem = new ItemStack(Material.valueOf((String)"STAINED_GLASS_PANE"), 1, colors.forGlass());
        }
        ItemMeta itemMeta = this.frameItem.getItemMeta();
        itemMeta.setDisplayName("\u00a7r");
        int n2 = n = this.pluginUtils.isCustomModelSupported() ? Math.max(0, this.getFiles().getConfig().get().getInt("Items.Frame.Custom-model-data", 0)) : 0;
        if (n != 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n));
        }
        this.frameItem.setItemMeta(itemMeta);
        this.backItem = this.createItem(this.getFiles().getConfig().get().getConfigurationSection("Items.Back"), Material.ARROW);
        this.closeItem = this.createItem(this.getFiles().getConfig().get().getConfigurationSection("Items.Close"), Material.BARRIER);
        String string = this.getFiles().getConfig().get().getString("Items.Back.Command", "none");
        this.backItemCommand = string.equalsIgnoreCase("none") ? null : new CommandData(string);
        String string2 = this.getFiles().getConfig().get().getString("Items.Close.Command", "none");
        this.closeItemCommand = string2.equalsIgnoreCase("none") ? null : new CommandData(string2);
        this.backItemClose = this.getFiles().getConfig().get().getBoolean("Items.Back.Close", true);
        this.closeItemClose = this.getFiles().getConfig().get().getBoolean("Items.Close.Close", true);
        this.loadCustomPlaceholders();
        if (this.keepAliveTask != null) {
            this.keepAliveTask.cancel();
        }
        if (this.keepAliveInterval != 0 && this.mysqlEnabled) {
            this.keepAliveTask = new BukkitRunnable(){

                public void run() {
                    if (AlonsoPlus.this.debugMode) {
                        LocalUtils.logp("[DATABASE] Keeping connection alive..");
                    }
                    try {
                        AlonsoPlus.this.database.getConnection(false).prepareStatement("SELECT 1").executeQuery();
                    }
                    catch (SQLException sQLException) {
                        if (AlonsoPlus.this.debugMode) {
                            LocalUtils.loge("[DATABASE] Issue keeping connection alive..");
                        }
                        sQLException.printStackTrace();
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)this, (long)this.keepAliveInterval, (long)this.keepAliveInterval);
        }
    }

    private void loadCustomPlaceholders() {
        ConfigurationSection configurationSection = this.fileManager.getConfig().get().getConfigurationSection("Placeholders.Custom");
        this.customPlaceholderEnabled = false;
        this.rankMap.clear();
        if (configurationSection != null) {
            this.customPlaceholderEnabled = configurationSection.getBoolean("Enabled", false);
            if (this.customPlaceholderEnabled) {
                LocalUtils.logp("Custom placeholders are enabled. Loading..");
                for (String string : configurationSection.getKeys(false)) {
                    if (string.equalsIgnoreCase("enabled")) continue;
                    String string2 = string.toLowerCase();
                    ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
                    String string3 = configurationSection2.getString("Ranked", "%vault_prefix%");
                    String string4 = configurationSection2.getString("No-ranked", "%vault_prefix%");
                    String string5 = configurationSection2.getString("To-replace", "{COLOR}");
                    RankData rankData = new RankData(string2, string3, string4, string5);
                    this.rankMap.put(string2, rankData);
                    LocalUtils.logp("Loaded '" + string2 + "' custom placeholder.");
                }
                if (this.rankMap.isEmpty()) {
                    this.customPlaceholderEnabled = false;
                    LocalUtils.logp("Couldn't load any custom placeholder! Skipping..");
                } else {
                    LocalUtils.logp("Successfully loaded " + this.rankMap.size() + " custom placeholders!");
                }
            } else {
                LocalUtils.logp("Custom placeholders are not enabled. Skipping..");
            }
        } else {
            LocalUtils.logp("Custom placeholders section is not available. Skipping..");
        }
    }

    public static AlonsoPlus getInstance() {
        return instance;
    }

    private void updateConfigurations() {
        this.updateConfiguration(this.getFiles().getConfig());
        this.updateColors(this.getFiles().getColors());
    }

    private void updateColors(FileManager.Configuration configuration) {
        if (configuration.get().getBoolean("Updates.Auto-update-configuration", true)) {
            boolean bl = false;
            ConfigurationSection configurationSection = configuration.get().getConfigurationSection("Colors");
            if (configurationSection != null) {
                for (String string : configurationSection.getKeys(false)) {
                    ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
                    if (configurationSection2 == null) continue;
                    bl = this.fixConfig(configurationSection2, "Items.Locked.Custom-mode-data", "Items.Locked.Custom-model-data", (Object)0) || bl;
                    bl = this.fixConfig(configurationSection2, "Items.Unlocked.Custom-mode-data", "Items.Unlocked.Custom-model-data", (Object)0) || bl;
                    bl = this.fixConfig(configurationSection2, "Items.Selected.Custom-mode-data", "Items.Selected.Custom-model-data", (Object)0) || bl;
                }
            }
            if (bl) {
                configuration.save();
            }
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] \u00a77Configuration " + configuration.getFileName() + " is up-to-date!");
        } else {
            LocalUtils.logp("Configuration auto-update is not enabled! Ignoring " + configuration.getFileName() + " changes..");
        }
    }

    private void updateConfiguration(FileManager.Configuration configuration) {
        if (configuration.get().getBoolean("Updates.Auto-update-configuration", true)) {
            boolean bl = false;
            bl = this.addConfig(configuration.get(), "Updates.Auto-update-configuration", true) || bl;
            bl = this.addConfig(configuration.get(), "Messages.Clear.Cleared", "&cYou have cleared your color!") || bl;
            bl = this.addConfig(configuration.get(), "Messages.Set.Invalid-color", "&cIdentifier is not a valid color!") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Database.Keep-connection-interval", 30) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Database.HikariCP.Warning", Arrays.asList("========================================================================================", "You don't need to edit this text, it's ONLY displayed in config so you can read it.", "========================================================================================", "HikariCP is experimental. Remember that only modify the following IF YOU KNOW HOW IT WORKS.", "You will not get support for HikariCP configurations as 1) I'm not a HikariCP advanced user", "and 2) Customization depends on the owner and his knowledge level.", "Related to Source-properties, if you KNOW and want to add custom properties follow the format:", "Source-properties:", "  thePropertySelected1: 'theValue1'", "  thePropertySelected2: 'theValue2'", "[!] Remember to modify data only if you know what you are doing.", "Available source properties can be found here: https://alonsoaliaga.com/HikariCP-sp", "Available source class names can be found here: https://alonsoaliaga.com/HikariCP-cn")) || bl;
            boolean bl2 = bl = this.addConfig(this.getFiles().getConfig().get(), "Database.HikariCP.Custom-source-class-name", "default") || bl;
            if (!this.getFiles().getConfig().get().contains("Database.HikariCP.Source-properties")) {
                bl = this.addConfig(this.getFiles().getConfig().get(), "Database.HikariCP.Source-properties.useSSL", "false") || bl;
                bl = this.addConfig(this.getFiles().getConfig().get(), "Database.HikariCP.Source-properties.requireSSL", "false") || bl;
            }
            bl = this.addConfig(this.getFiles().getConfig().get(), "Database.HikariCP.Max-pool-size", 3) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Data-delay", 20) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Compatibility.Chat", false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Compatibility.Hex-color-fix", true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Log-mode", true) || bl;
            bl = this.fixConfig(this.getFiles().getConfig().get(), "Items.Back.Custom-mode-data", "Items.Back.Custom-model-data", (Object)0) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close.Slot", -1) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close.Material", "BARRIER") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close.Texture", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmViNTg4YjIxYTZmOThhZDFmZjRlMDg1YzU1MmRjYjA1MGVmYzljYWI0MjdmNDYwNDhmMThmYzgwMzQ3NWY3In19fQ==") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close.Custom-model-data", 0) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close.Displayname", "&cClose") || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close.Glow", false) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close.Lore", Arrays.asList("&7Close GUI.")) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close.Close", true) || bl;
            bl = this.addConfig(this.getFiles().getConfig().get(), "Items.Close.Command", "none") || bl;
            boolean bl3 = bl = this.addConfig(this.getFiles().getConfig().get(), "Options.Instant-update", false) || bl;
            if (!this.getFiles().getConfig().get().contains("Placeholders.Custom")) {
                bl = this.addConfig(this.getFiles().getConfig().get(), "Placeholders.Custom.Enabled", false) || bl;
                bl = this.addConfig(this.getFiles().getConfig().get(), "Placeholders.Custom.another_prefix.To-replace", "{COLOR}") || bl;
                bl = this.addConfig(this.getFiles().getConfig().get(), "Placeholders.Custom.another_prefix.No-ranked", "%vault_prefix%") || bl;
                bl = this.addConfig(this.getFiles().getConfig().get(), "Placeholders.Custom.another_prefix.Ranked", "%vault_prefix%") || bl;
                bl = this.addConfig(this.getFiles().getConfig().get(), "Placeholders.Custom.another_prefix_2.To-replace", "{COLOR}") || bl;
                bl = this.addConfig(this.getFiles().getConfig().get(), "Placeholders.Custom.another_prefix_2.No-ranked", "%vault_prefix%") || bl;
                boolean bl4 = bl = this.addConfig(this.getFiles().getConfig().get(), "Placeholders.Custom.another_prefix_2.Ranked", "%vault_prefix%") || bl;
            }
            if (bl) {
                configuration.get().options().header("                 _   _                  ___ _                         Our plugins: https://alonsoaliaga.com/plugins\n                /_\\ | |___ _ _  ___ ___| _ \\ |_  _ ___                Support server: https://alonsoaliaga.com/discord\n               / _ \\| / _ \\ ' \\(_-</ _ \\  _/ | || (_-<                Youtube: https://alonsoaliaga.com/play\n              /_/ \\_\\_\\___/_||_/__/\\___/_| |_|\\_,_/__/                Test server: plugins.alonsoaliaga.com\n                           by AlonsoAliaga                            Twitch: https://alonsoaliaga.com/twitch\n        Considering donating? https://alonsoaliaga.com/donate         Thanks for purchasing my plugin! Only buyers receive support <3\n\n                         >> If your spigot profile link is not https://www.spigotmc.org/members/997807/\n               consider purchasing our plugin from https://alonsoaliaga.com/AlonsoPlus to support our hard work. <<\n ======================================================================================================================================\n |              Downloaded this jar in a server setup? Tell the author he is NOT allowed to upload someone else work!                 |\n |   Update to latest version as soon as possible. Support WON'T be given when using old versions. Specially from downloaded setups.  |\n | Remember: Support is only provided for .jar files downloaded DIRECTLY from spigotmc.org! Other files will be considered as invalid |\n |        as they are NOT the same .jar file the developer (me) uploaded and I cannot guarantee that the file is safe or not.         |\n |                   If you have issues with setup configs. Tell the setup author to update his config file.                          |\n |                         Download original plugin directly from https://alonsoaliaga.com/AlonsoPlus                                 |\n ======================================================================================================================================");
                configuration.save();
            }
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] \u00a77Configuration " + configuration.getFileName() + " is up-to-date!");
        } else {
            LocalUtils.logp("Configuration auto-update is not enabled! Ignoring " + configuration.getFileName() + " changes..");
        }
    }

    private boolean fixConfig(ConfigurationSection configurationSection, String string, String string2, Object object) {
        if (configurationSection.contains(string)) {
            Object object2 = configurationSection.get(string, object);
            if (!configurationSection.contains(string2)) {
                configurationSection.set(string2, object2);
            }
            configurationSection.set(string, null);
            return true;
        }
        return false;
    }

    private boolean fixConfig(FileConfiguration fileConfiguration, String string, String string2, Object object) {
        if (fileConfiguration.contains(string)) {
            Object object2 = fileConfiguration.get(string, object);
            if (!fileConfiguration.contains(string2)) {
                fileConfiguration.set(string2, object2);
            }
            fileConfiguration.set(string, null);
            return true;
        }
        return false;
    }

    private boolean addConfig(FileConfiguration fileConfiguration, String string, Object object) {
        if (!fileConfiguration.contains(string)) {
            fileConfiguration.set(string, object);
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] \u00a77Adding default configuration in path: " + AlonsoUtils.first + string);
            return true;
        }
        return false;
    }

    @Override
    public AlonsoUtils.PluginUtils getPluginUtils() {
        return this.pluginUtils;
    }

    @Override
    public FileManager getFiles() {
        return this.fileManager;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this;
    }

    public void openColors(Player player, PlayerData playerData) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new PlusHolder(0), (int)(this.rows * 9), (String)LocalUtils.fixInventoryTitle(this.messages.colorsTitle));
        if (player.hasPermission(this.permissions.rankedPermission)) {
            ColorData colorData;
            if (playerData.hasSelectedColor()) {
                for (Map.Entry<Integer, ColorData> itemStack : this.colorsSlotsMap.entrySet()) {
                    colorData = itemStack.getValue();
                    inventory.setItem(itemStack.getKey().intValue(), playerData.getSelectedColor().equals(colorData.getColorIdentifier()) ? colorData.getSelectedItem() : (colorData.hasPermission() && player.hasPermission(colorData.getPermission()) ? colorData.getUnlockedItem() : colorData.getLockedItem()));
                }
            } else {
                for (Map.Entry<Integer, ColorData> entry : this.colorsSlotsMap.entrySet()) {
                    colorData = entry.getValue();
                    inventory.setItem(entry.getKey().intValue(), colorData.isDefault() ? colorData.getSelectedItem() : (colorData.hasPermission() && player.hasPermission(colorData.getPermission()) ? colorData.getUnlockedItem() : colorData.getLockedItem()));
                }
            }
        } else {
            for (Map.Entry<Integer, ColorData> entry : this.colorsSlotsMap.entrySet()) {
                inventory.setItem(entry.getKey().intValue(), entry.getValue().getLockedItem());
            }
        }
        if (this.backSlot != -1) {
            inventory.setItem(this.backSlot, this.backItem);
        }
        if (this.closeSlot != -1) {
            inventory.setItem(this.closeSlot, this.closeItem);
        }
        if (this.frameEnabled) {
            for (int i = 0; i < inventory.getSize(); ++i) {
                ItemStack itemStack = inventory.getItem(i);
                if (itemStack != null && itemStack.getType() != Material.AIR) continue;
                inventory.setItem(i, this.frameItem);
            }
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> player.openInventory(inventory));
    }

    public String getColor(String string) {
        if (this.colorsMap.containsKey(string)) {
            return this.colorsMap.get(string).getColor();
        }
        return null;
    }

    public String getColor(Player player) {
        if (this.dataMap.containsKey(player.getUniqueId()) && player.hasPermission(this.permissions.rankedPermission)) {
            return this.dataMap.get(player.getUniqueId()).getColor();
        }
        return null;
    }

    public String getColorIdentifier(Player player) {
        if (this.dataMap.containsKey(player.getUniqueId()) && player.hasPermission(this.permissions.rankedPermission)) {
            return this.dataMap.get(player.getUniqueId()).getSelectedColor();
        }
        return null;
    }

    public String getPrefix(Player player) {
        if (this.pluginUtils.isPlaceholderApiSupported()) {
            if (this.dataMap.containsKey(player.getUniqueId()) && player.hasPermission(this.permissions.rankedPermission)) {
                return LocalUtils.colorize(PlaceholderAPI.setPlaceholders((Player)player, (String)this.messages.placeholderNoRanked).replace(this.messages.placeholderToReplace, this.dataMap.get(player.getUniqueId()).getColor()));
            }
            return LocalUtils.colorize(PlaceholderAPI.setPlaceholders((Player)player, (String)this.messages.placeholderNoRanked).replace(this.messages.placeholderToReplace, ""));
        }
        if (this.dataMap.containsKey(player.getUniqueId()) && player.hasPermission(this.permissions.rankedPermission)) {
            return LocalUtils.colorize(this.messages.placeholderNoRanked.replace(this.messages.placeholderToReplace, this.dataMap.get(player.getUniqueId()).getColor()));
        }
        return LocalUtils.colorize(this.messages.placeholderNoRanked.replace(this.messages.placeholderToReplace, ""));
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=997807&resource_id=86621&nonce=663608878").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

