/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsoplus.listeners;

import com.alonsoaliaga.alonsoplus.AlonsoPlus;
import com.alonsoaliaga.alonsoplus.api.events.PlayerRegisterEvent;
import com.alonsoaliaga.alonsoplus.others.ColorData;
import com.alonsoaliaga.alonsoplus.others.PlayerData;
import com.alonsoaliaga.alonsoplus.utils.LocalUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ConnectionListener
implements Listener {
    private AlonsoPlus plugin;
    private HashMap<UUID, BukkitTask> loadingProcess = new HashMap();

    public ConnectionListener(AlonsoPlus alonsoPlus) {
        this.plugin = alonsoPlus;
        alonsoPlus.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)alonsoPlus);
        this.reloadMessages();
    }

    public void reloadMessages() {
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        if (this.plugin.joinDelay == 0) {
            if (playerJoinEvent.getPlayer().isOnline()) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    if (playerJoinEvent.getPlayer().isOnline()) {
                        this.loadPlayer(playerJoinEvent.getPlayer());
                    }
                });
            }
        } else {
            if (this.loadingProcess.containsKey(playerJoinEvent.getPlayer().getUniqueId())) {
                this.loadingProcess.remove(playerJoinEvent.getPlayer().getUniqueId()).cancel();
            }
            this.loadingProcess.put(playerJoinEvent.getPlayer().getUniqueId(), Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
                if (playerJoinEvent.getPlayer().isOnline()) {
                    this.loadPlayer(playerJoinEvent.getPlayer());
                    this.loadingProcess.remove(playerJoinEvent.getPlayer().getUniqueId());
                }
            }, (long)this.plugin.joinDelay));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        PlayerData playerData;
        if (this.loadingProcess.containsKey(playerQuitEvent.getPlayer().getUniqueId())) {
            this.loadingProcess.remove(playerQuitEvent.getPlayer().getUniqueId()).cancel();
        }
        if (this.plugin.getDataMap().containsKey(playerQuitEvent.getPlayer().getUniqueId()) && (playerData = this.plugin.getDataMap().get(playerQuitEvent.getPlayer().getUniqueId())).isModified()) {
            this.savePlayer(playerData, false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuitRemove(PlayerQuitEvent playerQuitEvent) {
        this.plugin.getDataMap().remove(playerQuitEvent.getPlayer().getUniqueId());
    }

    public void loadPlayer(Player player) {
        if (this.plugin.hikariCPEnabled) {
            try (Connection connection = this.plugin.getDatabase().getConnection(false);){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + this.plugin.getDatabase().getTable() + " WHERE uuid=?");
                preparedStatement.setString(1, player.getUniqueId().toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    String string = resultSet.getString("selected_color");
                    String string2 = resultSet.getString("playername");
                    if (string.equalsIgnoreCase("none")) {
                        PlayerData playerData = new PlayerData(player, player.getUniqueId(), string2, null, this.plugin.colorData);
                        this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                    } else if (player.hasPermission(this.plugin.permissions.rankedPermission)) {
                        if (this.plugin.getColorsMap().containsKey(string)) {
                            ColorData colorData = this.plugin.getColorsMap().get(string);
                            if (!colorData.hasPermission() || player.hasPermission(colorData.getPermission())) {
                                PlayerData playerData = new PlayerData(player, player.getUniqueId(), string2, colorData.getColorIdentifier(), colorData);
                                this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                            } else {
                                PlayerData playerData = new PlayerData(player, player.getUniqueId(), string2, null, this.plugin.colorData);
                                playerData.markModified();
                                this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                            }
                        } else {
                            PlayerData playerData = new PlayerData(player, player.getUniqueId(), string2, null, this.plugin.colorData);
                            playerData.markModified();
                            this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                        }
                    } else {
                        PlayerData playerData = new PlayerData(player, player.getUniqueId(), string2, null, this.plugin.colorData);
                        playerData.markModified();
                        this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                    }
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("&aSuccessfully loaded player '" + player.getName() + "' from database!");
                    }
                } else {
                    this.registerPlayer(player);
                }
            }
            catch (SQLException sQLException) {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&cCouldn't load player '" + player.getName() + "' from database!");
                }
                sQLException.printStackTrace();
            }
        } else {
            try {
                PreparedStatement preparedStatement = this.plugin.getDatabase().getConnection(false).prepareStatement("SELECT * FROM " + this.plugin.getDatabase().getTable() + " WHERE uuid=?");
                preparedStatement.setString(1, player.getUniqueId().toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    String string = resultSet.getString("selected_color");
                    String string3 = resultSet.getString("playername");
                    if (string.equalsIgnoreCase("none")) {
                        PlayerData playerData = new PlayerData(player, player.getUniqueId(), string3, null, this.plugin.colorData);
                        this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                    } else if (player.hasPermission(this.plugin.permissions.rankedPermission)) {
                        if (this.plugin.getColorsMap().containsKey(string)) {
                            ColorData colorData = this.plugin.getColorsMap().get(string);
                            if (!colorData.hasPermission() || player.hasPermission(colorData.getPermission())) {
                                PlayerData playerData = new PlayerData(player, player.getUniqueId(), string3, colorData.getColorIdentifier(), colorData);
                                this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                            } else {
                                PlayerData playerData = new PlayerData(player, player.getUniqueId(), string3, null, this.plugin.colorData);
                                playerData.markModified();
                                this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                            }
                        } else {
                            PlayerData playerData = new PlayerData(player, player.getUniqueId(), string3, null, this.plugin.colorData);
                            playerData.markModified();
                            this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                        }
                    } else {
                        PlayerData playerData = new PlayerData(player, player.getUniqueId(), string3, null, this.plugin.colorData);
                        playerData.markModified();
                        this.plugin.getDataMap().put(player.getUniqueId(), playerData);
                    }
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("&aSuccessfully loaded player '" + player.getName() + "' from database!");
                    }
                } else {
                    this.registerPlayer(player);
                }
            }
            catch (SQLException sQLException) {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&cCouldn't load player '" + player.getName() + "' from database!");
                }
                sQLException.printStackTrace();
            }
        }
    }

    public void savePlayer(PlayerData playerData, boolean bl) {
        Object object;
        String string = "none";
        if (playerData.hasSelectedColor()) {
            object = playerData.getSelectedColorData();
            if (!((ColorData)object).hasPermission() || playerData.getPlayer().hasPermission(((ColorData)object).getPermission())) {
                string = ((ColorData)object).getColorIdentifier();
            }
            if (string.equals(this.plugin.colorData.getColorIdentifier())) {
                string = "none";
            }
        }
        if (bl) {
            if (this.plugin.hikariCPEnabled) {
                try {
                    object = this.plugin.getDatabase().getConnection(false);
                    Throwable throwable = null;
                    try {
                        PreparedStatement preparedStatement = object.prepareStatement("UPDATE " + this.plugin.getDatabase().getTable() + " SET selected_color=?,playername=? WHERE uuid=?");
                        preparedStatement.setString(1, string);
                        preparedStatement.setString(2, playerData.getPlayername());
                        preparedStatement.setString(3, playerData.getPlayer().getUniqueId().toString());
                        preparedStatement.executeUpdate();
                        playerData.markUpdated();
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("&aSuccessfully saved player '" + playerData.getPlayer().getName() + "' in database!");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    LocalUtils.logp("&cCouldn't save player '" + playerData.getPlayer().getName() + "' in database!");
                    sQLException.printStackTrace();
                }
            } else {
                try {
                    object = this.plugin.getDatabase().getConnection(false).prepareStatement("UPDATE " + this.plugin.getDatabase().getTable() + " SET selected_color=?,playername=? WHERE uuid=?");
                    object.setString(1, string);
                    object.setString(2, playerData.getPlayername());
                    object.setString(3, playerData.getPlayer().getUniqueId().toString());
                    object.executeUpdate();
                    playerData.markUpdated();
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("&aSuccessfully saved player '" + playerData.getPlayer().getName() + "' in database!");
                    }
                }
                catch (SQLException sQLException) {
                    LocalUtils.logp("&cCouldn't save player '" + playerData.getPlayer().getName() + "' in database!");
                    sQLException.printStackTrace();
                }
            }
        } else {
            object = string;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.lambda$savePlayer$2((String)object, playerData));
        }
    }

    private void registerPlayer(Player player) {
        if (this.plugin.hikariCPEnabled) {
            try (Connection connection = this.plugin.getDatabase().getConnection(false);){
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + this.plugin.getDatabase().getTable() + " (uuid,playername) VALUES (?,?)");
                preparedStatement.setString(1, player.getUniqueId().toString());
                preparedStatement.setString(2, player.getName());
                preparedStatement.execute();
                this.plugin.getDataMap().put(player.getUniqueId(), new PlayerData(player, player.getUniqueId(), player.getName(), null, this.plugin.colorData));
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&aSuccessfully registered player '" + player.getName() + "' in database!");
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    PlayerRegisterEvent playerRegisterEvent = new PlayerRegisterEvent(player);
                    Bukkit.getPluginManager().callEvent((Event)playerRegisterEvent);
                });
            }
            catch (SQLException sQLException) {
                LocalUtils.logp("&cCouldn't register player '" + player.getName() + "' in database!");
                sQLException.printStackTrace();
            }
        } else {
            try {
                PreparedStatement preparedStatement = this.plugin.getDatabase().getConnection(false).prepareStatement("INSERT INTO " + this.plugin.getDatabase().getTable() + " (uuid,playername) VALUES (?,?)");
                preparedStatement.setString(1, player.getUniqueId().toString());
                preparedStatement.setString(2, player.getName());
                preparedStatement.execute();
                this.plugin.getDataMap().put(player.getUniqueId(), new PlayerData(player, player.getUniqueId(), player.getName(), null, this.plugin.colorData));
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&aSuccessfully registered player '" + player.getName() + "' in database!");
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    PlayerRegisterEvent playerRegisterEvent = new PlayerRegisterEvent(player);
                    Bukkit.getPluginManager().callEvent((Event)playerRegisterEvent);
                });
            }
            catch (SQLException sQLException) {
                LocalUtils.logp("&cCouldn't register player '" + player.getName() + "' in database!");
                sQLException.printStackTrace();
            }
        }
    }

    private /* synthetic */ void lambda$savePlayer$2(String string, PlayerData playerData) {
        if (this.plugin.hikariCPEnabled) {
            try (Connection connection = this.plugin.getDatabase().getConnection(false);){
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE " + this.plugin.getDatabase().getTable() + " SET selected_color=?,playername=? WHERE uuid=?");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, playerData.getPlayername());
                preparedStatement.setString(3, playerData.getPlayer().getUniqueId().toString());
                preparedStatement.executeUpdate();
                playerData.markUpdated();
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&aSuccessfully saved player '" + playerData.getPlayer().getName() + "' in database!");
                }
            }
            catch (SQLException sQLException) {
                LocalUtils.logp("&cCouldn't save player '" + playerData.getPlayer().getName() + "' in database!");
                sQLException.printStackTrace();
            }
        } else {
            try {
                PreparedStatement preparedStatement = this.plugin.getDatabase().getConnection(false).prepareStatement("UPDATE " + this.plugin.getDatabase().getTable() + " SET selected_color=?,playername=? WHERE uuid=?");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, playerData.getPlayername());
                preparedStatement.setString(3, playerData.getPlayer().getUniqueId().toString());
                preparedStatement.executeUpdate();
                playerData.markUpdated();
                if (this.plugin.debugMode) {
                    LocalUtils.logp("&aSuccessfully saved player '" + playerData.getPlayer().getName() + "' in database!");
                }
            }
            catch (SQLException sQLException) {
                LocalUtils.logp("&cCouldn't save player '" + playerData.getPlayer().getName() + "' in database!");
                sQLException.printStackTrace();
            }
        }
    }
}

