/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsoplus.others;

import com.alonsoaliaga.alonsoplus.AlonsoPlus;
import com.alonsoaliaga.alonsoplus.enums.CommandType;
import com.alonsoaliaga.alonsoplus.others.Sounds;
import com.alonsoaliaga.alonsoplus.utils.AlonsoUtils;
import com.alonsoaliaga.alonsoplus.utils.LocalUtils;
import javax.annotation.Nonnull;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandData {
    private String command;
    private CommandType commandType;
    private Sound sound = null;
    private float volume = 1.0f;
    private float pitch = 1.0f;

    public CommandData(String string, CommandType commandType) {
        this.command = string.trim();
        CommandType commandType2 = this.commandType = commandType == null ? CommandType.PLAYER : commandType;
        if (AlonsoPlus.getInstance().logMode) {
            LocalUtils.logp("Successfully loaded command '" + this.command + "' with type '" + this.commandType.name() + "'!");
        }
        this.process();
    }

    private void process() {
        if (this.commandType == CommandType.SOUND_BROADCAST || this.commandType == CommandType.SOUND || this.commandType == CommandType.SOUND_WORLD_BROADCAST) {
            String[] stringArray = this.command.split(",");
            this.sound = LocalUtils.getSound(stringArray[0].trim(), Sounds.LEVEL_UP.getSound());
            if (stringArray.length >= 2) {
                try {
                    this.volume = Float.parseFloat(stringArray[1].trim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (stringArray.length >= 3) {
                    try {
                        this.pitch = Float.parseFloat(stringArray[2].trim());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public CommandData(String string) {
        this.command = string.trim();
        this.commandType = CommandType.getFromCommand(string);
        this.command = this.commandType == null ? this.command : this.command.substring(this.commandType.getToRemove().length());
        CommandType commandType = this.commandType = this.commandType == null ? CommandType.PLAYER : this.commandType;
        if (AlonsoPlus.getInstance().logMode) {
            LocalUtils.logp("Successfully loaded command '" + this.command + "' with type '" + this.commandType.name() + "'!");
        }
    }

    public void performCommand(@Nonnull Player player) {
        switch (this.commandType) {
            case PLAYER: {
                player.performCommand(this.setPlaceholders(player, this.command));
                break;
            }
            case OP: {
                String string = this.setPlaceholders(player, this.command);
                if (player.isOp()) {
                    player.performCommand(string);
                    break;
                }
                player.setOp(true);
                try {
                    player.performCommand(string);
                    player.setOp(false);
                }
                catch (Throwable throwable) {
                    LocalUtils.logp("Error running '" + string + "' as OP! Removing OP..");
                    throwable.printStackTrace();
                    player.setOp(false);
                }
                break;
            }
            case CONSOLE: {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.setPlaceholders(player, this.command));
                break;
            }
            case MESSAGE: {
                player.sendMessage(LocalUtils.colorize(this.setPlaceholders(player, this.command)));
                break;
            }
            case CHAT: {
                player.chat(this.setPlaceholders(player, this.command));
                break;
            }
            case MESSAGE_BROADCAST: {
                Bukkit.broadcastMessage((String)LocalUtils.colorize(this.setPlaceholders(player, this.command)));
                break;
            }
            case MESSAGE_WORLD_BROADCAST: {
                String string = LocalUtils.colorize(this.setPlaceholders(player, this.command));
                for (Player player2 : player.getWorld().getPlayers()) {
                    player2.sendMessage(string);
                }
                break;
            }
            case SOUND: {
                player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
                break;
            }
            case SOUND_BROADCAST: {
                for (Player player3 : Bukkit.getOnlinePlayers()) {
                    player3.playSound(player3.getLocation(), this.sound, this.volume, this.pitch);
                }
                break;
            }
            case SOUND_WORLD_BROADCAST: {
                for (Player player4 : player.getWorld().getPlayers()) {
                    player4.playSound(player4.getLocation(), this.sound, this.volume, this.pitch);
                }
                break;
            }
        }
    }

    private String setPlaceholders(Player player, String string) {
        String string2 = player.getName();
        String string3 = player.getWorld().getName();
        String string4 = player.getWorld().getUID().toString();
        String string5 = String.valueOf(player.getLocation().getBlockX());
        String string6 = String.valueOf(player.getLocation().getBlockY());
        String string7 = String.valueOf(player.getLocation().getBlockZ());
        String string8 = player.getUniqueId().toString();
        string = string.replace("{PLAYER}", string2).replace("{UUID}", string8).replace("{WORLD}", string3).replace("{WORLD_UUID}", string4).replace("{X}", string5).replace("{Y}", string6).replace("{Z}", string7);
        return AlonsoUtils.PluginUtils.hasPlaceholderApiSupport() ? PlaceholderAPI.setPlaceholders((Player)player, (String)string) : string;
    }
}

