/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsoplus.others;

import com.alonsoaliaga.alonsoplus.AlonsoPlus;
import com.alonsoaliaga.alonsoplus.utils.AlonsoUtils;
import com.alonsoaliaga.alonsoplus.utils.LocalUtils;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FileManager {
    private JavaPlugin plugin;
    private Configuration configuration;
    private Configuration colors;

    public FileManager(JavaPlugin javaPlugin) {
        this.plugin = javaPlugin;
        this.configuration = this.setupConfigFile("config");
        FileManager.copyResource("colors.yml", AlonsoUtils.serverVersion.isLegacy() ? "colors_legacy.yml" : (AlonsoUtils.serverVersion.isNewerEqualThanV1_16() ? "colors_hex.yml" : "colors_new_api.yml"));
        this.colors = this.setupConfigFile("colors");
    }

    private Configuration setupConfigFile(String string) {
        boolean bl;
        File file = new File(this.plugin.getDataFolder(), "/");
        if (!file.exists() && (bl = file.mkdir())) {
            LocalUtils.logp("Creating datafolder '/AlonsoPlus/ ..'");
        }
        String string2 = string.endsWith(".yml") ? string : string + ".yml";
        return new Configuration(this.plugin, string2);
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public Configuration getColors() {
        return this.colors;
    }

    public static void copyResource(String string, String string2) {
        File file = new File(AlonsoPlus.getInstance().getDataFolder(), string);
        if (!file.exists()) {
            AlonsoPlus.getInstance().saveResource(string2, false);
            File file2 = new File(AlonsoPlus.getInstance().getDataFolder(), string2);
            if (file2.renameTo(file)) {
                LocalUtils.logp("Created '" + string + "' file!");
            }
            file2.delete();
        }
    }

    public class Configuration {
        private JavaPlugin plugin;
        private String fileName;
        private FileConfiguration fileConfiguration = null;
        private File file = null;

        public Configuration(JavaPlugin javaPlugin, String string) {
            this.plugin = javaPlugin;
            this.fileName = string.endsWith(".yml") ? string : string + ".yml";
            this.init();
        }

        private void init() {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
            if (!this.file.exists()) {
                this.plugin.saveResource(this.fileName, false);
            }
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        }

        public Configuration saveDefaults() {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
            this.plugin.saveResource(this.fileName, true);
            return this;
        }

        public Configuration save() {
            if (this.fileConfiguration == null || this.file == null) {
                return this;
            }
            try {
                if (this.fileConfiguration.getConfigurationSection("").getKeys(true).size() != 0) {
                    this.fileConfiguration.save(this.file);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return this;
        }

        public Configuration reload() {
            if (this.file == null) {
                this.file = new File(this.plugin.getDataFolder(), this.fileName);
            }
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
            return this;
        }

        public String getFileName() {
            return this.fileName;
        }

        public FileConfiguration get() {
            return this.fileConfiguration;
        }
    }
}

