/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.economy;

import com.alonsoaliaga.alonsotags.economy.CurrencyManager;
import com.alonsoaliaga.alonsotags.enums.CostType;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LevelsHook
implements CurrencyManager {
    @Override
    public boolean hasEnough(Player player, int n) {
        return player.getLevel() >= n;
    }

    @Override
    public boolean hasEnough(Player player, double d) {
        return (double)player.getLevel() >= d;
    }

    @Override
    public boolean hasEnough(UUID uUID, double d) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        return player != null && this.hasEnough(player, d);
    }

    @Override
    public boolean withdraw(Player player, int n) {
        if (this.hasEnough(player, n)) {
            player.setLevel(player.getLevel() - n);
            return true;
        }
        return false;
    }

    @Override
    public boolean withdraw(Player player, double d) {
        return this.withdraw(player, (int)d);
    }

    @Override
    public boolean withdraw(UUID uUID, double d) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        return player != null && this.withdraw(player, d);
    }

    @Override
    public boolean add(Player player, int n) {
        player.setLevel(player.getLevel() + n);
        return true;
    }

    @Override
    public boolean add(Player player, double d) {
        return this.add(player, (int)d);
    }

    @Override
    public boolean add(UUID uUID, double d) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        return player != null && this.add(player, d);
    }

    @Override
    public CostType getType() {
        return CostType.LEVEL;
    }
}

