/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.economy;

import com.alonsoaliaga.alonsotags.economy.CurrencyManager;
import com.alonsoaliaga.alonsotags.enums.CostType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MaterialHook
implements CurrencyManager {
    private Material material;
    private boolean dropOnFull;
    private boolean cleanItems;

    public MaterialHook(Material material, boolean bl, boolean bl2) {
        this.material = material;
        this.dropOnFull = bl;
        this.cleanItems = bl2;
    }

    public MaterialHook(Material material, boolean bl) {
        this.material = material;
        this.dropOnFull = bl;
        this.cleanItems = true;
    }

    public MaterialHook(Material material) {
        this.material = material;
        this.dropOnFull = true;
        this.cleanItems = true;
    }

    @Override
    public boolean hasEnough(Player player, int n) {
        if (this.cleanItems) {
            HashMap hashMap = player.getInventory().all(this.material);
            int n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                ItemStack itemStack = (ItemStack)entry.getValue();
                if (!itemStack.hasItemMeta()) {
                    n2 += itemStack.getAmount();
                }
                if (n2 < n) continue;
                return true;
            }
            return false;
        }
        return player.getInventory().contains(this.material, n);
    }

    @Override
    public boolean hasEnough(Player player, double d) {
        return this.hasEnough(player, (int)d);
    }

    @Override
    public boolean hasEnough(UUID uUID, double d) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        return player != null && this.hasEnough(player, (int)d);
    }

    @Override
    public boolean withdraw(Player player, int n) {
        if (this.cleanItems) {
            HashMap hashMap = player.getInventory().all(this.material);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n2 = n;
            ItemStack itemStack = null;
            int n3 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                ItemStack itemStack2 = (ItemStack)entry.getValue();
                if (itemStack2.hasItemMeta()) continue;
                if (n2 >= itemStack2.getAmount()) {
                    arrayList.add((Integer)entry.getKey());
                    n2 -= itemStack2.getAmount();
                } else {
                    itemStack = itemStack2;
                    n3 = itemStack.getAmount() - n2;
                    n2 = 0;
                }
                if (n2 > 0) continue;
                break;
            }
            if (n2 <= 0) {
                for (Integer n4 : arrayList) {
                    player.getInventory().setItem(n4.intValue(), null);
                }
                if (itemStack != null) {
                    itemStack.setAmount(n3);
                }
                player.updateInventory();
                return true;
            }
            return false;
        }
        HashMap hashMap = player.getInventory().all(this.material);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = n;
        ItemStack itemStack = null;
        int n5 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            ItemStack itemStack3 = (ItemStack)entry.getValue();
            if (n4 >= itemStack3.getAmount()) {
                arrayList.add((Integer)entry.getKey());
                n4 -= itemStack3.getAmount();
            } else {
                itemStack = itemStack3;
                n5 = itemStack.getAmount() - n4;
                n4 = 0;
            }
            if (n4 > 0) continue;
            break;
        }
        if (n4 <= 0) {
            for (Integer n6 : arrayList) {
                player.getInventory().setItem(n6.intValue(), null);
            }
            if (itemStack != null) {
                itemStack.setAmount(n5);
            }
            player.updateInventory();
            return true;
        }
        return false;
    }

    @Override
    public boolean withdraw(Player player, double d) {
        return this.withdraw(player, (int)d);
    }

    @Override
    public boolean withdraw(UUID uUID, double d) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            return false;
        }
        return this.withdraw(player, (int)d);
    }

    @Override
    public boolean add(Player player, int n) {
        HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(this.material, n)});
        if (this.dropOnFull && !hashMap.isEmpty()) {
            hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
        }
        return true;
    }

    @Override
    public boolean add(Player player, double d) {
        return this.add(player, (int)d);
    }

    @Override
    public boolean add(UUID uUID, double d) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            return false;
        }
        return this.add(player, d);
    }

    @Override
    public CostType getType() {
        return CostType.MATERIAL;
    }
}

