/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.economy;

import com.alonsoaliaga.alonsotags.economy.CurrencyManager;
import com.alonsoaliaga.alonsotags.enums.CostType;
import java.util.OptionalLong;
import java.util.UUID;
import me.realized.tokenmanager.TokenManagerPlugin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TokenManagerHook
implements CurrencyManager {
    private TokenManagerPlugin tokenManager;

    public TokenManagerHook(TokenManagerPlugin tokenManagerPlugin) {
        this.tokenManager = tokenManagerPlugin;
    }

    @Override
    public boolean hasEnough(Player player, int n) {
        OptionalLong optionalLong = this.tokenManager.getTokens(player);
        return optionalLong.isPresent() && optionalLong.getAsLong() >= (long)n;
    }

    @Override
    public boolean hasEnough(Player player, double d) {
        OptionalLong optionalLong = this.tokenManager.getTokens(player);
        return optionalLong.isPresent() && (double)optionalLong.getAsLong() >= d;
    }

    @Override
    public boolean hasEnough(UUID uUID, double d) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            return false;
        }
        OptionalLong optionalLong = this.tokenManager.getTokens(player);
        return optionalLong.isPresent() && (double)optionalLong.getAsLong() >= d;
    }

    @Override
    public boolean withdraw(Player player, int n) {
        return this.tokenManager.removeTokens(player, (long)n);
    }

    @Override
    public boolean withdraw(Player player, double d) {
        return this.tokenManager.removeTokens(player, (long)((int)d));
    }

    @Override
    public boolean withdraw(UUID uUID, double d) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            return false;
        }
        return this.tokenManager.removeTokens(player, (long)((int)d));
    }

    @Override
    public boolean add(Player player, int n) {
        return this.tokenManager.addTokens(player, (long)n);
    }

    @Override
    public boolean add(Player player, double d) {
        return this.tokenManager.addTokens(player, (long)((int)d));
    }

    @Override
    public boolean add(UUID uUID, double d) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            return false;
        }
        return this.tokenManager.addTokens(player, (long)((int)d));
    }

    @Override
    public CostType getType() {
        return CostType.TOKEN_MANAGER;
    }
}

