/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.enums;

import com.alonsoaliaga.alonsotags.others.CommandData;

public enum CommandType {
    PLAYER("[PLAYER]"),
    CONSOLE("[CONSOLE]"),
    CHAT("[CHAT]"),
    OP("[OP]"),
    MESSAGE("[MESSAGE]"),
    MESSAGE_BROADCAST("[MESSAGE_BROADCAST]"),
    MESSAGE_WORLD_BROADCAST("[MESSAGE_WORLD_BROADCAST]"),
    SOUND("[SOUND]"),
    SOUND_BROADCAST("[SOUND_BROADCAST]"),
    SOUND_WORLD_BROADCAST("[SOUND_WORLD_BROADCAST]"),
    CUSTOM_SOUND("[CUSTOM_SOUND]"),
    CUSTOM_SOUND_BROADCAST("[CUSTOM_SOUND_BROADCAST]"),
    CUSTOM_SOUND_WORLD_BROADCAST("[CUSTOM_SOUND_WORLD_BROADCAST]"),
    TITLE("[TITLE]"),
    TITLE_BROADCAST("[TITLE_BROADCAST]"),
    TITLE_WORLD_BROADCAST("[TITLE_WORLD_BROADCAST]"),
    ACTION_BAR("[ACTION_BAR]"),
    ACTION_BAR_BROADCAST("[ACTION_BAR_BROADCAST]"),
    ACTION_BAR_WORLD_BROADCAST("[ACTION_BAR_WORLD_BROADCAST]"),
    FIREWORK("[FIREWORK]"),
    JSON("[JSON]"),
    JSON_BROADCAST("[JSON_BROADCAST]"),
    JSON_WORLD_BROADCAST("[JSON_WORLD_BROADCAST]"),
    BUNGEE_PLAYER_CHAT("[BUNGEE_PLAYER_CHAT]"),
    BUNGEE_PLAYER_COMMAND("[BUNGEE_PLAYER_COMMAND]"),
    BUNGEE_CONSOLE("[BUNGEE_CONSOLE]"),
    BOOK("[BOOK]");

    private String toRemove;

    private CommandType(String string2) {
        this.toRemove = string2;
    }

    public String getToRemove() {
        return this.toRemove;
    }

    public CommandData getCommandData(String string) {
        return new CommandData(string);
    }

    public CommandData getCommandData(String string, CommandType commandType, ConnectionType connectionType) {
        string = string.trim();
        for (CommandType commandType2 : CommandType.values()) {
            if (!string.startsWith(commandType2.getToRemove())) continue;
            return new CommandData(string.substring(commandType2.getToRemove().length()), commandType2, connectionType);
        }
        return new CommandData(string, commandType, connectionType);
    }

    public static CommandType getFromCommand(String string) {
        for (CommandType commandType : CommandType.values()) {
            if (!string.startsWith(commandType.getToRemove())) continue;
            return commandType;
        }
        return null;
    }

    public static CommandType getCommandType(String string) {
        return CommandType.getCommandType(string, null);
    }

    public static CommandType getCommandType(String string, CommandType commandType) {
        try {
            return CommandType.valueOf(string);
        }
        catch (Throwable throwable) {
            return commandType;
        }
    }

    public static enum ConnectionType {
        FIRST_JOIN("[FIRST_JOIN]"),
        KNOWN_PLAYER("[KNOWN_PLAYER]"),
        NORMAL("[NORMAL]");

        private String toRemove;

        private ConnectionType(String string2) {
            this.toRemove = string2;
        }

        public String getToRemove() {
            return this.toRemove;
        }

        public static ConnectionType getFromCommand(String string) {
            for (ConnectionType connectionType : ConnectionType.values()) {
                if (!string.startsWith(connectionType.getToRemove())) continue;
                return connectionType;
            }
            return null;
        }

        public static ConnectionType getConnectionType(String string) {
            return ConnectionType.getConnectionType(string, null);
        }

        public static ConnectionType getConnectionType(String string, ConnectionType connectionType) {
            try {
                return ConnectionType.valueOf(string);
            }
            catch (Throwable throwable) {
                return connectionType;
            }
        }
    }
}

