/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.listeners;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.api.events.TagPurchaseEvent;
import com.alonsoaliaga.alonsotags.api.events.TagSelectEvent;
import com.alonsoaliaga.alonsotags.others.ColorData;
import com.alonsoaliaga.alonsotags.others.CommandData;
import com.alonsoaliaga.alonsotags.others.PlayerData;
import com.alonsoaliaga.alonsotags.others.TagData;
import com.alonsoaliaga.alonsotags.others.TagHolder;
import com.alonsoaliaga.alonsotags.others.sounds.BukkitSoundCategoryData;
import com.alonsoaliaga.alonsotags.others.sounds.BukkitSoundNoCategoryData;
import com.alonsoaliaga.alonsotags.others.sounds.CustomSoundCategoryData;
import com.alonsoaliaga.alonsotags.others.sounds.CustomSoundNoCategoryData;
import com.alonsoaliaga.alonsotags.others.sounds.SoundData;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeMap;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.plugin.Plugin;

public class ClickListener
implements Listener {
    private AlonsoTags plugin;
    private int tagsType = 0;
    private int colorsType = 1;
    private SoundData previousTagsPageSound = null;
    private SoundData nextTagsPageSound = null;
    private SoundData closeTagsSound = null;
    private SoundData resetTagSuccessSound = null;
    private SoundData resetTagFailSound = null;
    private SoundData unlockedTagsModeOnSound = null;
    private SoundData unlockedTagsModeOffSound = null;
    private SoundData unlockedTagsNoPermissionSound = null;
    private SoundData alreadySelectedTagSound = null;
    private SoundData previewNoPermissionSound = null;
    private SoundData tagNoPermissionSound = null;
    private SoundData tagCurrentNotAvailableSound = null;
    private SoundData tagNotEnoughMoneySound = null;
    private SoundData tagErrorPurchasingSound = null;
    private SoundData tagPurchasedSound = null;
    private SoundData openToSelectColorSound = null;
    private SoundData previewNoPermissionForTagSound = null;
    private SoundData tagSelectedSound = null;
    private SoundData tagPreviewSound = null;
    private SoundData colorsBackToTagsSound = null;
    private SoundData colorNoPermissionSound = null;
    private SoundData colorSelectedSound = null;
    private SoundData closeColorsSound = null;

    public ClickListener(AlonsoTags alonsoTags) {
        this.plugin = alonsoTags;
        alonsoTags.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)alonsoTags);
        this.reloadMessages();
    }

    public void reloadMessages() {
        ConfigurationSection configurationSection = this.plugin.getFiles().getConfig().get().getConfigurationSection("Options.Premium.Sounds");
        if (configurationSection != null) {
            this.previousTagsPageSound = this.loadSoundData(configurationSection.getString("Tags-menu.Previous-page", "none"));
            this.nextTagsPageSound = this.loadSoundData(configurationSection.getString("Tags-menu.Next-page", "none"));
            this.closeTagsSound = this.loadSoundData(configurationSection.getString("Tags-menu.Close-tags", "none"));
            this.resetTagSuccessSound = this.loadSoundData(configurationSection.getString("Tags-menu.Reset-tag-success", "none"));
            this.resetTagFailSound = this.loadSoundData(configurationSection.getString("Tags-menu.Reset-tag-fail", "none"));
            this.unlockedTagsModeOnSound = this.loadSoundData(configurationSection.getString("Tags-menu.Unlocked-tags-mode-on", "none"));
            this.unlockedTagsModeOffSound = this.loadSoundData(configurationSection.getString("Tags-menu.Unlocked-tags-mode-off", "none"));
            this.unlockedTagsNoPermissionSound = this.loadSoundData(configurationSection.getString("Tags-menu.Unlocked-tags-no-permission", "none"));
            this.alreadySelectedTagSound = this.loadSoundData(configurationSection.getString("Tags-menu.Already-selected", "none"));
            this.previewNoPermissionSound = this.loadSoundData(configurationSection.getString("Tags-menu.Preview-no-permission", "none"));
            this.tagNoPermissionSound = this.loadSoundData(configurationSection.getString("Tags-menu.Tag-no-permission", "none"));
            this.tagCurrentNotAvailableSound = this.loadSoundData(configurationSection.getString("Tags-menu.Currency-not-available", "none"));
            this.tagNotEnoughMoneySound = this.loadSoundData(configurationSection.getString("Tags-menu.Not-enough-money", "none"));
            this.tagErrorPurchasingSound = this.loadSoundData(configurationSection.getString("Tags-menu.Error-purchasing", "none"));
            this.tagPurchasedSound = this.loadSoundData(configurationSection.getString("Tags-menu.Purchased", "none"));
            this.openToSelectColorSound = this.loadSoundData(configurationSection.getString("Tags-menu.Open-to-select-color", "none"));
            this.previewNoPermissionForTagSound = this.loadSoundData(configurationSection.getString("Tags-menu.Preview-no-permission-for-tag", "none"));
            this.tagSelectedSound = this.loadSoundData(configurationSection.getString("Tags-menu.Selected", "none"));
            this.tagPreviewSound = this.loadSoundData(configurationSection.getString("Tags-menu.Preview", "none"));
            this.colorsBackToTagsSound = this.loadSoundData(configurationSection.getString("Colors-menu.Back-to-tags", "none"));
            this.colorNoPermissionSound = this.loadSoundData(configurationSection.getString("Colors-menu.Color-no-permission", "none"));
            this.colorSelectedSound = this.loadSoundData(configurationSection.getString("Colors-menu.Selected", "none"));
            this.closeColorsSound = this.loadSoundData(configurationSection.getString("Colors-menu.Close-colors", "none"));
        }
    }

    private SoundData loadSoundData(String string) {
        if (string == null || string.equalsIgnoreCase("none")) {
            return null;
        }
        float f = 1.0f;
        float f2 = 1.0f;
        String[] stringArray = string.split(",");
        Sound sound = null;
        String string2 = null;
        SoundCategory soundCategory = null;
        if (stringArray.length >= 1) {
            if (stringArray[0].toLowerCase(Locale.ROOT).startsWith("custom=")) {
                string2 = stringArray[0].substring(7);
            } else {
                sound = LocalUtils.getSound(stringArray[0]);
            }
            if (stringArray.length >= 2) {
                try {
                    f = Float.parseFloat(stringArray[1]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (stringArray.length >= 3) {
                    try {
                        f2 = Float.parseFloat(stringArray[2]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (stringArray.length >= 4 && LocalUtils.isSoundCategoryAvailable()) {
                        try {
                            soundCategory = SoundCategory.valueOf((String)stringArray[3]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (sound != null) {
            if (soundCategory == null) {
                return new BukkitSoundNoCategoryData(sound, f, f2);
            }
            return new BukkitSoundCategoryData(sound, soundCategory, f, f2);
        }
        if (string2 != null) {
            if (soundCategory == null) {
                return new CustomSoundNoCategoryData(string2, f, f2);
            }
            return new CustomSoundCategoryData(string2, soundCategory, f, f2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getInventory().getHolder() instanceof TagHolder) {
            inventoryClickEvent.setCancelled(true);
            if (this.plugin.getDataMap().containsKey(inventoryClickEvent.getWhoClicked().getUniqueId())) {
                TagHolder tagHolder = (TagHolder)inventoryClickEvent.getInventory().getHolder();
                if (tagHolder.getType() == this.tagsType) {
                    if (inventoryClickEvent.getRawSlot() == this.plugin.previousSlot) {
                        if (tagHolder.getPage() <= 1) {
                            return;
                        }
                        PlayerData playerData = this.plugin.getDataMap().get(inventoryClickEvent.getWhoClicked().getUniqueId());
                        Player player = (Player)inventoryClickEvent.getWhoClicked();
                        this.plugin.openTags(player, playerData, tagHolder.getPage() - 1, tagHolder, false);
                        if (this.previousTagsPageSound != null) {
                            this.previousTagsPageSound.playSound(player);
                        }
                    } else if (inventoryClickEvent.getRawSlot() == this.plugin.nextSlot) {
                        if (tagHolder.getPage() >= (tagHolder.hasAllTagsMode() ? this.plugin.getTagSlotPagesMap().size() : tagHolder.getUnlockedTags().size())) {
                            return;
                        }
                        PlayerData playerData = this.plugin.getDataMap().get(inventoryClickEvent.getWhoClicked().getUniqueId());
                        Player player = (Player)inventoryClickEvent.getWhoClicked();
                        this.plugin.openTags(player, playerData, tagHolder.getPage() + 1, tagHolder, false);
                        if (this.nextTagsPageSound != null) {
                            this.nextTagsPageSound.playSound(player);
                        }
                    } else if (this.plugin.closeItemEnabled && inventoryClickEvent.getRawSlot() == this.plugin.closeSlot) {
                        Player player = (Player)inventoryClickEvent.getWhoClicked();
                        player.closeInventory();
                        if (this.closeTagsSound != null) {
                            this.closeTagsSound.playSound(player);
                        }
                        if (this.plugin.closeCommand != null) {
                            this.plugin.closeCommand.performCommand(player);
                        }
                    } else if (inventoryClickEvent.getRawSlot() == this.plugin.playerSlot) {
                        PlayerData playerData = this.plugin.getDataMap().get(inventoryClickEvent.getWhoClicked().getUniqueId());
                        Player player = (Player)inventoryClickEvent.getWhoClicked();
                        if (playerData.hasEnabledTag()) {
                            TagSelectEvent tagSelectEvent = new TagSelectEvent(player, playerData.getEnabledTag(), null, TagSelectEvent.Reason.PLAYER, false, null);
                            Bukkit.getPluginManager().callEvent((Event)tagSelectEvent);
                            if (tagSelectEvent.isCancelled()) {
                                return;
                            }
                            playerData.setEnabledTag(null);
                            playerData.setCurrentTag(null);
                            playerData.setCurrentRecognitionTitle("");
                            playerData.markModified();
                            player.sendMessage(this.plugin.messages.tagCleared);
                            if (this.resetTagSuccessSound != null) {
                                this.resetTagSuccessSound.playSound(player);
                            }
                            if (this.plugin.closeOnClear) {
                                player.closeInventory();
                            } else {
                                this.plugin.openTags(player, playerData, tagHolder.getPage(), tagHolder, false);
                            }
                        } else {
                            player.sendMessage(this.plugin.messages.tagNotSelected);
                            if (this.resetTagFailSound != null) {
                                this.resetTagFailSound.playSound(player);
                            }
                            if (this.plugin.closeOnClear) {
                                player.closeInventory();
                            } else {
                                this.plugin.openTags(player, playerData, tagHolder.getPage(), tagHolder, false);
                            }
                        }
                    } else if (inventoryClickEvent.getRawSlot() == this.plugin.filterSlot) {
                        Player player = (Player)inventoryClickEvent.getWhoClicked();
                        if (this.plugin.forceStateEnabled && !player.hasPermission(this.plugin.permissions.forceFilterBypassPermission)) {
                            return;
                        }
                        PlayerData playerData = this.plugin.getDataMap().get(player.getUniqueId());
                        if (playerData.hasAllTagsMode()) {
                            if (!LocalUtils.hasPermission((CommandSender)player, this.plugin.permissions.filterPermission)) {
                                player.sendMessage(this.plugin.messages.filterNoPermission);
                                if (this.unlockedTagsNoPermissionSound != null) {
                                    this.unlockedTagsNoPermissionSound.playSound(player);
                                }
                                return;
                            }
                            playerData.setAllTagsMode(false);
                            if (this.unlockedTagsModeOnSound != null) {
                                this.unlockedTagsModeOnSound.playSound(player);
                            }
                        } else {
                            playerData.setAllTagsMode(true);
                            if (this.unlockedTagsModeOffSound != null) {
                                this.unlockedTagsModeOffSound.playSound(player);
                            }
                        }
                        this.plugin.openTags(player, playerData, tagHolder.getPage(), tagHolder, true);
                    } else if (tagHolder.hasAllTagsMode() ? this.plugin.getTagSlotPagesMap().containsKey(tagHolder.getPage()) : tagHolder.getUnlockedTags().containsKey(tagHolder.getPage())) {
                        TreeMap<Integer, TagData> treeMap;
                        TreeMap<Integer, TagData> treeMap2 = treeMap = tagHolder.hasAllTagsMode() ? this.plugin.getTagSlotPagesMap().get(tagHolder.getPage()) : tagHolder.getUnlockedTags().get(tagHolder.getPage());
                        if (treeMap.containsKey(inventoryClickEvent.getRawSlot())) {
                            Object object;
                            PlayerEvent playerEvent;
                            TagData tagData = treeMap.get(inventoryClickEvent.getRawSlot());
                            PlayerData playerData = this.plugin.getDataMap().get(inventoryClickEvent.getWhoClicked().getUniqueId());
                            Player player = (Player)inventoryClickEvent.getWhoClicked();
                            if (playerData.hasEnabledTag() && playerData.getEnabledTag().equalsIgnoreCase(tagData.getTagIdentifier()) && !tagData.isDyeable()) {
                                player.sendMessage(this.plugin.messages.alreadySelected);
                                if (this.alreadySelectedTagSound != null) {
                                    this.alreadySelectedTagSound.playSound(player);
                                }
                                return;
                            }
                            if (!playerData.getPurchasedTags().contains(tagData.getTagIdentifier())) {
                                if (tagData.isPurchasable()) {
                                    if (this.plugin.previewEnabled && inventoryClickEvent.getClick() == ClickType.RIGHT) {
                                        if (tagData.hasPermission() && !player.hasPermission(tagData.getPermission()) && !this.plugin.previewIgnorePermission) {
                                            player.sendMessage(this.plugin.messages.previewNoPermissionForTag);
                                            if (this.previewNoPermissionSound != null) {
                                                this.previewNoPermissionSound.playSound(player);
                                            }
                                            return;
                                        }
                                        this.sendPreviewToPlayer(player, tagData, null);
                                        return;
                                    }
                                    if (tagData.hasPermission() && !player.hasPermission(tagData.getPermission())) {
                                        player.sendMessage(tagData.getNoPermissionMessage());
                                        if (this.tagNoPermissionSound != null) {
                                            this.tagNoPermissionSound.playSound(player);
                                        }
                                        return;
                                    }
                                    if (tagData.getCurrencyManager() == null) {
                                        player.sendMessage(this.plugin.messages.currencyNotAvailable);
                                        if (this.tagCurrentNotAvailableSound != null) {
                                            this.tagCurrentNotAvailableSound.playSound(player);
                                        }
                                        return;
                                    }
                                    if (!tagData.getCurrencyManager().hasEnough(player, tagData.getPrice())) {
                                        player.sendMessage(tagData.getNotEnoughMoneyMessage().replace("{COST}", String.valueOf(tagData.getPrice())));
                                        if (this.tagNotEnoughMoneySound != null) {
                                            this.tagNotEnoughMoneySound.playSound(player);
                                        }
                                        return;
                                    }
                                    playerEvent = new TagPurchaseEvent(player, tagData.getTagIdentifier(), tagData.getPrice(), TagPurchaseEvent.Reason.PLAYER);
                                    Bukkit.getPluginManager().callEvent((Event)playerEvent);
                                    if (playerEvent.isCancelled()) {
                                        return;
                                    }
                                    if (!tagData.getCurrencyManager().withdraw(player, tagData.getPrice())) {
                                        player.sendMessage(this.plugin.messages.errorPurchasing);
                                        if (this.tagErrorPurchasingSound != null) {
                                            this.tagErrorPurchasingSound.playSound(player);
                                        }
                                        return;
                                    }
                                    object = LocalUtils.colorize(this.plugin.parseOutput ? LocalUtils.setPlaceholders(player, tagData.getTag()) : tagData.getTag());
                                    player.sendMessage(this.plugin.messages.tagPurchased.replace("{TAG}", (CharSequence)object).replace("{PRICE}", String.valueOf(tagData.getPrice())).replace("{TAG_NAME}", tagData.getTagName()));
                                    if (this.tagPurchasedSound != null) {
                                        this.tagPurchasedSound.playSound(player);
                                    }
                                    playerData.getPurchasedTags().add(tagData.getTagIdentifier());
                                    playerData.markModified();
                                    HashMap<String, String> object2 = new HashMap<String, String>((String)object, tagData){
                                        final /* synthetic */ String val$parsedFinalTag;
                                        final /* synthetic */ TagData val$tagData;
                                        {
                                            this.val$parsedFinalTag = string;
                                            this.val$tagData = tagData;
                                            this.put("{TAG}", this.val$parsedFinalTag);
                                            this.put("{TAG_IDENTIFIER}", this.val$tagData.getTagIdentifier());
                                            this.put("{PRICE}", String.valueOf(this.val$tagData.getPrice()));
                                        }
                                    };
                                    if (!tagData.getPurchaseCommands().isEmpty()) {
                                        for (CommandData commandData : tagData.getPurchaseCommands()) {
                                            commandData.performCommand(player, object2);
                                        }
                                    }
                                } else {
                                    if (this.plugin.previewEnabled && inventoryClickEvent.getClick() == ClickType.RIGHT) {
                                        if (tagData.hasPermission() && !player.hasPermission(tagData.getPermission()) && !this.plugin.previewIgnorePermission) {
                                            player.sendMessage(this.plugin.messages.previewNoPermissionForTag);
                                            if (this.previewNoPermissionForTagSound != null) {
                                                this.previewNoPermissionForTagSound.playSound(player);
                                            }
                                            return;
                                        }
                                        this.sendPreviewToPlayer(player, tagData, null);
                                        return;
                                    }
                                    if (tagData.hasPermission() && !player.hasPermission(tagData.getPermission())) {
                                        player.sendMessage(tagData.getNoPermissionMessage());
                                        if (this.tagNoPermissionSound != null) {
                                            this.tagNoPermissionSound.playSound(player);
                                        }
                                        return;
                                    }
                                }
                            } else {
                                if (this.plugin.previewEnabled && inventoryClickEvent.getClick() == ClickType.RIGHT) {
                                    if (tagData.hasPermission() && !player.hasPermission(tagData.getPermission()) && !this.plugin.previewIgnorePermission) {
                                        player.sendMessage(this.plugin.messages.previewNoPermissionForTag);
                                        if (this.previewNoPermissionForTagSound != null) {
                                            this.previewNoPermissionForTagSound.playSound(player);
                                        }
                                        return;
                                    }
                                    this.sendPreviewToPlayer(player, tagData, null);
                                    return;
                                }
                                if (tagData.hasPermission() && !player.hasPermission(tagData.getPermission())) {
                                    player.sendMessage(tagData.getNoPermissionMessage());
                                    if (this.tagNoPermissionSound != null) {
                                        this.tagNoPermissionSound.playSound(player);
                                    }
                                    return;
                                }
                            }
                            if (!tagData.isDyeable()) {
                                playerEvent = new TagSelectEvent(player, playerData.getEnabledTag(), tagData.getTagIdentifier(), TagSelectEvent.Reason.PLAYER, false, "default");
                                Bukkit.getPluginManager().callEvent((Event)playerEvent);
                                if (playerEvent.isCancelled()) {
                                    return;
                                }
                                if (!tagData.getPreSelectCommands().isEmpty()) {
                                    for (CommandData commandData : tagData.getPreSelectCommands()) {
                                        commandData.performCommand(player, tagData, tagData.getTag());
                                    }
                                }
                                playerData.setEnabledTag(tagData.getTagIdentifier());
                                playerData.setCurrentTag(tagData.getTag());
                                playerData.setCurrentRecognitionTitle(tagData.getRecognitionTitle());
                                playerData.setEnabledColor("default");
                                playerData.setCurrentColor("");
                                playerData.markModified();
                                if (this.tagSelectedSound != null) {
                                    this.tagSelectedSound.playSound(player);
                                }
                                object = playerData.getParsedCurrentTag();
                                player.sendMessage(this.plugin.messages.tagSelected.replace("{TAG}", (CharSequence)object));
                                if (!tagData.getPostSelectCommands().isEmpty()) {
                                    for (CommandData commandData : tagData.getPostSelectCommands()) {
                                        commandData.performCommand(player, tagData, (String)object);
                                    }
                                }
                                if (this.plugin.closeOnSelect) {
                                    player.closeInventory();
                                } else {
                                    this.plugin.openTags(player, playerData, tagHolder.getPage(), tagHolder, true);
                                }
                                return;
                            }
                            if (this.openToSelectColorSound != null) {
                                this.openToSelectColorSound.playSound(player);
                            }
                            this.plugin.openColors(player, tagData);
                            return;
                        }
                    }
                } else if (tagHolder.getType() == this.colorsType) {
                    if (inventoryClickEvent.getRawSlot() == this.plugin.closeColorsSlot) {
                        Player player = (Player)inventoryClickEvent.getWhoClicked();
                        player.closeInventory();
                        if (this.closeColorsSound != null) {
                            this.closeColorsSound.playSound(player);
                        }
                        if (this.plugin.closeColorsCommand != null) {
                            this.plugin.closeColorsCommand.performCommand(player);
                        }
                        return;
                    }
                    if (inventoryClickEvent.getRawSlot() == this.plugin.backToTagsSlot) {
                        Player player = (Player)inventoryClickEvent.getWhoClicked();
                        if (this.colorsBackToTagsSound != null) {
                            this.colorsBackToTagsSound.playSound(player);
                        }
                        this.plugin.openTags(player, this.plugin.getDataMap().get(player.getUniqueId()), 1, tagHolder, false);
                        return;
                    }
                    if (this.plugin.getColorsSlotsMap().containsKey(inventoryClickEvent.getRawSlot())) {
                        void var9_34;
                        Player player = (Player)inventoryClickEvent.getWhoClicked();
                        ColorData colorData = this.plugin.getColorsSlotsMap().get(inventoryClickEvent.getRawSlot());
                        TagData tagData = tagHolder.getTagData();
                        if (this.plugin.previewEnabled && inventoryClickEvent.getClick() == ClickType.RIGHT) {
                            if (colorData.hasPermission() && !player.hasPermission(colorData.getPermission()) && !this.plugin.previewIgnorePermission) {
                                player.sendMessage(this.plugin.messages.previewNoPermissionForTag);
                                if (this.previewNoPermissionForTagSound != null) {
                                    this.previewNoPermissionForTagSound.playSound(player);
                                }
                                return;
                            }
                            this.sendPreviewToPlayer(player, tagData, colorData);
                            return;
                        }
                        if (colorData.hasPermission() && !player.hasPermission(colorData.getPermission())) {
                            player.sendMessage(colorData.getNoPermissionMessage());
                            if (this.colorNoPermissionSound != null) {
                                this.colorNoPermissionSound.playSound(player);
                            }
                            return;
                        }
                        PlayerData playerData = this.plugin.getDataMap().get(player.getUniqueId());
                        TagSelectEvent tagSelectEvent = new TagSelectEvent(player, playerData.getEnabledTag(), tagData.getTagIdentifier(), TagSelectEvent.Reason.PLAYER, true, colorData.getColorIdentifier());
                        Bukkit.getPluginManager().callEvent((Event)tagSelectEvent);
                        if (tagSelectEvent.isCancelled()) {
                            return;
                        }
                        String string = tagData.getTag();
                        String string2 = tagData.getRecognitionTitle();
                        if (colorData.isDefaultColor()) {
                            string = string.replace("{COLOR}", tagData.getDefaultColor());
                            String string3 = string2.replace("{COLOR}", tagData.getDefaultColor());
                            if (!tagData.getPreSelectCommands().isEmpty()) {
                                for (CommandData commandData : tagData.getPreSelectCommands()) {
                                    commandData.performCommand(player, tagData, string);
                                }
                            }
                            playerData.setEnabledTag(tagData.getTagIdentifier());
                            playerData.setEnabledColor(colorData.getColorIdentifier());
                            playerData.setCurrentColor(tagData.getDefaultColor());
                        } else {
                            string = string.replace("{COLOR}", colorData.getColor());
                            String string4 = string2.replace("{COLOR}", colorData.getColor());
                            if (!tagData.getPreSelectCommands().isEmpty()) {
                                for (CommandData commandData : tagData.getPreSelectCommands()) {
                                    commandData.performCommand(player, tagData, string);
                                }
                            }
                            playerData.setEnabledTag(tagData.getTagIdentifier());
                            playerData.setEnabledColor(colorData.getColorIdentifier());
                            playerData.setCurrentColor(colorData.getColor());
                        }
                        playerData.setCurrentTag(string);
                        playerData.setCurrentRecognitionTitle((String)var9_34);
                        playerData.markModified();
                        if (this.colorSelectedSound != null) {
                            this.colorSelectedSound.playSound(player);
                        }
                        String string5 = playerData.getParsedCurrentTag();
                        player.sendMessage(this.plugin.messages.tagSelected.replace("{TAG}", string5));
                        if (!tagData.getPostSelectCommands().isEmpty()) {
                            for (CommandData commandData : tagData.getPostSelectCommands()) {
                                commandData.performCommand(player, tagData, string5);
                            }
                        }
                        if (this.plugin.closeColorsOnSelect) {
                            player.closeInventory();
                        }
                        return;
                    }
                }
            } else {
                inventoryClickEvent.getWhoClicked().closeInventory();
            }
        }
    }

    private String parse(boolean bl, Player player, String string) {
        return bl ? PlaceholderAPI.setPlaceholders((Player)player, (String)string) : string;
    }

    private void sendPreviewToPlayer(Player player, TagData tagData, ColorData colorData) {
        if (this.tagPreviewSound != null) {
            this.tagPreviewSound.playSound(player);
        }
        String string = tagData.getPreview(colorData);
        String string2 = tagData.getRecognitionTitlePreview(colorData);
        if (this.plugin.previewTitleEnabled) {
            if (this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                LocalUtils.sendTitle(player, PlaceholderAPI.setPlaceholders((Player)player, (String)this.plugin.messages.previewTitle.replace("{PLAYER}", player.getName()).replace("{TAG}", string).replace("{RECOGNITION-TITLE}", string2)), PlaceholderAPI.setPlaceholders((Player)player, (String)this.plugin.messages.previewSubtitle.replace("{PLAYER}", player.getName()).replace("{TAG}", string).replace("{RECOGNITION-TITLE}", string2)), 15, 30, 15);
            } else {
                LocalUtils.sendTitle(player, this.plugin.messages.previewTitle.replace("{PLAYER}", player.getName()).replace("{TAG}", string).replace("{RECOGNITION-TITLE}", string2), this.plugin.messages.previewSubtitle.replace("{PLAYER}", player.getName()).replace("{TAG}", string).replace("{RECOGNITION-TITLE}", string2), 15, 30, 15);
            }
        }
        if (this.plugin.previewChatEnabled) {
            if (this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                for (String string3 : this.plugin.messages.previewChat) {
                    if (string3.contains("{RECOGNITION-TITLE}") && string2.isEmpty()) continue;
                    player.sendMessage(PlaceholderAPI.setPlaceholders((Player)player, (String)string3.replace("{PLAYER}", player.getName()).replace("{TAG}", string)).replace("{RECOGNITION-TITLE}", string2));
                }
            } else {
                for (String string4 : this.plugin.messages.previewChat) {
                    if (string4.contains("{RECOGNITION-TITLE}") && string2.isEmpty()) continue;
                    player.sendMessage(string4.replace("{PLAYER}", player.getName()).replace("{TAG}", string).replace("{RECOGNITION-TITLE}", string2));
                }
            }
        }
        if (this.plugin.closeOnPreviewTag) {
            player.closeInventory();
        }
    }
}

