/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.others;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.utils.AlonsoUtils;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import com.alonsoaliaga.alonsotags.utils.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FileManager {
    private JavaPlugin plugin;
    private Configuration configuration;
    private Configuration tags;
    private Configuration newTags;
    private Configuration colors;
    private Configuration time;
    private String respectMyWork = "%%__USER__%%";

    public FileManager(JavaPlugin javaPlugin) {
        this.plugin = javaPlugin;
        this.configuration = this.setupConfigFile("config");
        this.tags = this.setupConfigFile("tags");
        this.newTags = this.setupConfigFile("new_tags", true);
        this.time = this.setupConfigFile("timestamp");
        this.loadColorsFile();
    }

    private void loadColorsFile() {
        File file = new File(this.plugin.getDataFolder(), "colors.yml");
        if (!file.exists()) {
            this.plugin.saveResource("colors.yml", false);
            file = new File(this.plugin.getDataFolder(), "colors.yml");
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            String string = AlonsoTags.getInstance().getPluginUtils().getServerVersion().isNewerEqualThan(AlonsoUtils.ServerVersion.v1_16) ? "colors_hex.yml" : (AlonsoTags.getInstance().getPluginUtils().getServerVersion().isOlderEqualThan(AlonsoUtils.ServerVersion.v1_12) ? "colors_legacy.yml" : "colors_new_api.yml");
            LocalUtils.logp("Selected color.yml default config: " + string);
            this.plugin.saveResource(string, false);
            File file2 = new File(this.plugin.getDataFolder(), string);
            YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)file2);
            yamlConfiguration.addDefaults((org.bukkit.configuration.Configuration)yamlConfiguration2);
            try {
                if (!file2.delete()) {
                    LocalUtils.loge("Error deleting temp " + string + "! Skipping..");
                }
            }
            catch (Throwable throwable) {
                LocalUtils.loge("Error deleting temp " + string + " file: " + throwable.getMessage());
            }
            try {
                yamlConfiguration2.save(file);
                LocalUtils.logp("Saving colors.yml file!");
            }
            catch (IOException iOException) {
                LocalUtils.loge("Error saving colors.yml file: " + iOException.getMessage());
            }
        }
        this.colors = this.setupConfigFile("colors");
    }

    private Configuration setupConfigFile(String string) {
        return this.setupConfigFile(string, false);
    }

    private Configuration setupConfigFile(String string, boolean bl) {
        boolean bl2;
        File file = new File(this.plugin.getDataFolder(), "/");
        if (!file.exists() && (bl2 = file.mkdir())) {
            LocalUtils.logp("Creating datafolder '/AlonsoTags/ ..'");
        }
        String string2 = string.endsWith(".yml") ? string : string + ".yml";
        return new Configuration(this.plugin, string2, bl);
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public Configuration getTags() {
        return this.tags;
    }

    public Configuration getColors() {
        return this.colors;
    }

    public Configuration getNewTags() {
        return this.newTags;
    }

    public Configuration getTime() {
        return this.time;
    }

    private void loadData() {
        try {
            if (ReflectionUtils.getValue(((AlonsoTags)this.plugin).metrics, "bStatsID").toString().equals(ReflectionUtils.getValue(((AlonsoTags)this.plugin).metrics, "alternativeUserUrl").toString())) {
                ReflectionUtils.setValue(((AlonsoTags)this.plugin).clickListener, "tagsType", 1);
                ReflectionUtils.setValue(((AlonsoTags)this.plugin).clickListener, "colorsType", 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                ReflectionUtils.setValue(((AlonsoTags)this.plugin).clickListener, "tagsType", 1);
                ReflectionUtils.setValue(((AlonsoTags)this.plugin).clickListener, "colorsType", 0);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    public class Configuration {
        private JavaPlugin plugin;
        private String fileName;
        private FileConfiguration fileConfiguration = null;
        private File file = null;
        private boolean replace = false;

        public Configuration(JavaPlugin javaPlugin, String string, boolean bl) {
            this.plugin = javaPlugin;
            this.replace = bl;
            this.fileName = string.endsWith(".yml") ? string : string + ".yml";
            this.init();
        }

        public Configuration(JavaPlugin javaPlugin, String string) {
            this.plugin = javaPlugin;
            this.fileName = string.endsWith(".yml") ? string : string + ".yml";
            this.init();
        }

        public String getFileName() {
            return this.fileName;
        }

        private void init() {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
            if (!this.file.exists()) {
                this.plugin.saveResource(this.fileName, this.replace);
            }
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        }

        public Configuration saveDefaults() {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
            this.plugin.saveResource(this.fileName, true);
            return this;
        }

        public Configuration save() {
            if (this.fileConfiguration == null || this.file == null) {
                return this;
            }
            try {
                if (this.fileConfiguration.getConfigurationSection("").getKeys(true).size() != 0) {
                    this.fileConfiguration.save(this.file);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return this;
        }

        public Configuration reload() {
            if (this.file == null) {
                this.file = new File(this.plugin.getDataFolder(), this.fileName);
            }
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
            return this;
        }

        public FileConfiguration get() {
            return this.fileConfiguration;
        }
    }
}

