/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.others;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import java.util.List;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class PlayerData {
    private Player player;
    private UUID uuid;
    private String enabledTag;
    private String currentTag;
    private String currentRecognitionTitle;
    private String enabledColor;
    private String currentColor;
    private boolean allTagsMode;
    private List<String> purchasedTags;
    private boolean modified = false;

    public PlayerData(Player player, String string, String string2, String string3, String string4, String string5, boolean bl, List<String> list) {
        this.player = player;
        this.uuid = player.getUniqueId();
        this.enabledTag = string;
        this.currentTag = string2;
        this.currentRecognitionTitle = string3;
        this.enabledColor = string4;
        this.currentColor = string5;
        this.allTagsMode = bl;
        this.purchasedTags = list;
        if (string2 != null) {
            this.setCurrentTag(string2, true);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean hasEnabledTag() {
        return this.enabledTag != null;
    }

    public String getEnabledTag() {
        return this.enabledTag;
    }

    public boolean hasEnabledColor() {
        return this.enabledColor != null && !this.enabledColor.equalsIgnoreCase("default");
    }

    public String getEnabledColor() {
        return this.enabledColor;
    }

    public String getCurrentColor() {
        return this.currentColor;
    }

    public void setCurrentColor(String string) {
        this.currentColor = string;
    }

    public void setEnabledColor(String string) {
        this.enabledColor = string;
    }

    public void setEnabledTag(String string) {
        this.enabledTag = string;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void markModified() {
        this.modified = true;
    }

    public void markUpdated() {
        this.modified = false;
    }

    public String getCurrentTag() {
        return this.currentTag;
    }

    public String getParsedCurrentTag() {
        return AlonsoTags.getInstance().parseOutput ? LocalUtils.colorize(PlaceholderAPI.setPlaceholders((Player)this.player, (String)this.currentTag)) : this.currentTag;
    }

    public void setCurrentTag(String string) {
        this.setCurrentTag(string, false);
    }

    public void setCurrentTag(String string, boolean bl) {
        this.currentTag = string;
        AlonsoTags.getInstance().setNameTagSuffix(this.player, string, bl);
    }

    public void setCurrentRecognitionTitle(String string) {
        this.currentRecognitionTitle = string;
    }

    public String getCurrentRecognitionTitle() {
        return this.currentRecognitionTitle;
    }

    public String getParsedCurrentRecognitionTitle() {
        return AlonsoTags.getInstance().parseOutput ? LocalUtils.colorize(PlaceholderAPI.setPlaceholders((Player)this.player, (String)this.currentRecognitionTitle)) : this.currentRecognitionTitle;
    }

    public void setAllTagsMode(boolean bl) {
        this.allTagsMode = bl;
    }

    public boolean hasAllTagsMode() {
        return this.allTagsMode;
    }

    public List<String> getPurchasedTags() {
        return this.purchasedTags;
    }
}

