/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.utils;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.others.Materials;
import com.alonsoaliaga.alonsotags.others.Sounds;
import com.alonsoaliaga.alonsotags.utils.AlonsoUtils;
import com.alonsoaliaga.alonsotags.utils.ProtocolLibUtils;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import de.tr7zw.nbtapi.NBTCompound;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class LocalUtils {
    public static long DAY_START;
    public static long DAY_END;
    public static boolean hexColorSupport;
    public static boolean clickableTextSupport;
    public static boolean soundCategorySupport;
    public static boolean oldHoverMethod;
    public static boolean newSetUnbreakableMethod;
    public static boolean newIsUnbreakableMethod;
    public static boolean setUnbreakableSupport;
    public static boolean isUnbreakableSupport;
    public static boolean newSendTitleMethod;
    public static boolean oldSendTitleMethod;
    public static boolean longInventoryTitleSupport;
    public static boolean getMaxHealthFeatureSupport;
    public static boolean setMaxHealthFeatureSupport;
    public static boolean getMaxHealthAttributeSupport;
    public static boolean nativeOpenBookSupport;
    public static boolean setMaxHealthAttributeSupport;
    public static boolean fixColors;
    private static Map<org.bukkit.ChatColor, ColorSet<Integer, Integer, Integer>> colorMap;
    public static Method METHOD_SET_UNBREAKABLE_OLD;
    public static Method METHOD_IS_UNBREAKABLE_OLD;
    public static Method METHOD_ITEM_META_SPIGOT;
    public static Method METHOD_OLD_SEND_TITLE;
    public static Method METHOD_GET_MAX_HEALTH;
    public static Method METHOD_SET_MAX_HEALTH;
    private static final Pattern PATTERN_TO_REMOVE_FORMATTING;
    private static final Pattern HEX_COLOR_PATTERN;
    private static final Pattern PARSED_HEX_PATTERN;
    private static final Pattern PARSED_PATTERN_COLORS;
    private static final Pattern PARSED_OLD_LEGACY_HEX_PATTERN;
    public static String placeholderHexFormat;
    private static final Pattern ADD_AMPERSAND_HEX_PATTERN;
    private static final Pattern REMOVE_AMPERSAND_HEX_PATTERN;

    public static String removeFormatting(String string) {
        return LocalUtils.replaceRemoveRegex(PATTERN_TO_REMOVE_FORMATTING, string);
    }

    public static String replaceRemoveRegex(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        boolean bl = false;
        while (matcher.find()) {
            bl = true;
            String string2 = matcher.group(0);
            string = string.replace(string2, "");
        }
        return bl ? LocalUtils.replaceRemoveRegex(pattern, string) : string;
    }

    public static boolean openBook(Player player, ItemStack itemStack) {
        if (nativeOpenBookSupport) {
            player.openBook(itemStack);
            return true;
        }
        if (AlonsoUtils.PluginUtils.hasProtocolLibSupport()) {
            ProtocolLibUtils.sendBook(player, itemStack);
            return true;
        }
        return false;
    }

    public static org.bukkit.ChatColor fromRGB(int n, int n2, int n3) {
        TreeMap treeMap = new TreeMap();
        colorMap.forEach((chatColor, colorSet) -> {
            int n4 = Math.abs(n - (Integer)colorSet.getRed());
            int n5 = Math.abs(n2 - (Integer)colorSet.getGreen());
            int n6 = Math.abs(n3 - (Integer)colorSet.getBlue());
            treeMap.put(n4 + n5 + n6, chatColor);
        });
        return (org.bukkit.ChatColor)treeMap.firstEntry().getValue();
    }

    public static void setFixColors(boolean bl) {
        if (fixColors != bl) {
            LocalUtils.logp((bl ? "Enabling" : "Disabling") + " HEX color fix for 1.8 - 1.15 players.." + (bl ? " (This is an experimental feature)" : ""));
        }
        fixColors = bl;
    }

    public static String translateAlternateHexColorCodes(Character c, String string) {
        string = org.bukkit.ChatColor.translateAlternateColorCodes((char)c.charValue(), (String)string);
        if (string.length() < 7 || !string.contains("#")) {
            return string;
        }
        Matcher matcher = HEX_COLOR_PATTERN.matcher(string);
        if (fixColors) {
            while (matcher.find()) {
                String string2 = matcher.group(0);
                ChatColor chatColor = ChatColor.of((String)string2.replace("&", ""));
                org.bukkit.ChatColor chatColor2 = LocalUtils.fromRGB(chatColor.getColor().getRed(), chatColor.getColor().getGreen(), chatColor.getColor().getBlue());
                String string3 = chatColor.toString();
                string = string.replace(string2, string3.substring(0, string3.length() - 1) + chatColor2.getChar());
            }
        } else {
            while (matcher.find()) {
                String string4 = matcher.group(0);
                ChatColor chatColor = ChatColor.of((String)string4.replace("&", ""));
                string = string.replace(string4, chatColor.toString());
            }
        }
        return string;
    }

    public static String restoreColorNodesFromString(String string, boolean bl) {
        String string2;
        Matcher matcher;
        if (string.length() < 2) {
            return string;
        }
        if (hexColorSupport) {
            matcher = PARSED_HEX_PATTERN.matcher(string);
            while (matcher.find()) {
                string2 = matcher.group(0);
                string = string.replace(string2, placeholderHexFormat.replace("{COLOR}", string2.substring(2).replace("\u00a7", "")));
            }
        }
        if (bl) {
            matcher = PARSED_PATTERN_COLORS.matcher(string);
            while (matcher.find()) {
                string2 = matcher.group(0);
                string = string.replace(string2, string2.replace("\u00a7", "&"));
            }
        }
        return string;
    }

    public static String restoreColorNodesFromLegacyString(String string, boolean bl) {
        String string2;
        Matcher matcher;
        if (string.length() < 2) {
            return string;
        }
        if (hexColorSupport) {
            matcher = PARSED_OLD_LEGACY_HEX_PATTERN.matcher(string);
            while (matcher.find()) {
                string2 = matcher.group(0);
                string = string.replace(string2, placeholderHexFormat.replace("{COLOR}", string2.substring(2).replace("\u00a7", "").replace("&", "")));
            }
        }
        if (bl) {
            matcher = PARSED_PATTERN_COLORS.matcher(string);
            while (matcher.find()) {
                string2 = matcher.group(0);
                string = string.replace(string2, string2.replace("\u00a7", "&"));
            }
        }
        return string;
    }

    public static void setPlaceholderHexFormat(String string) {
        placeholderHexFormat = string;
    }

    public static String addAmpersandHexFormatString(String string) {
        if (string.length() >= 6) {
            Matcher matcher = ADD_AMPERSAND_HEX_PATTERN.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(0);
                string = string.replace(string2, "&" + string2);
            }
        }
        return string;
    }

    public static String removeAmpersandHexFormatString(String string) {
        if (string.length() >= 7) {
            Matcher matcher = REMOVE_AMPERSAND_HEX_PATTERN.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(0);
                string = string.replace(string2, string2.replace("&", ""));
            }
        }
        return string;
    }

    public static String setNullPlaceholders(String string) {
        if (AlonsoUtils.PluginUtils.hasPlaceholderApiSupport()) {
            return PlaceholderAPI.setPlaceholders(null, (String)string);
        }
        return string;
    }

    public static List<String> setNullPlaceholders(List<String> list) {
        if (AlonsoUtils.PluginUtils.hasPlaceholderApiSupport()) {
            return PlaceholderAPI.setPlaceholders(null, list);
        }
        return list;
    }

    public static String colorize(String string) {
        if (hexColorSupport) {
            return LocalUtils.translateAlternateHexColorCodes(Character.valueOf('&'), string);
        }
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static List<String> colorize(List<String> list) {
        return list.stream().map(LocalUtils::colorize).collect(Collectors.toList());
    }

    public static void logp(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(AlonsoUtils.second + "[" + "AlonsoTags" + "] &7" + string));
    }

    public static void loge(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize("&c[AlonsoTags] " + string));
    }

    public static void logd(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(AlonsoUtils.second + "[" + "AlonsoTags" + "]" + AlonsoUtils.first + "&l[Debug] &7" + string));
    }

    public static void log(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(string));
    }

    public static Material findMaterial(String ... stringArray) {
        for (String string : stringArray) {
            try {
                return Material.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return Material.COBBLESTONE;
    }

    public static Sound findSound(String ... stringArray) {
        for (String string : stringArray) {
            try {
                return Sound.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        try {
            return Sound.valueOf((String)"CLICK");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Sound.valueOf((String)"UI_BUTTON_CLICK");
        }
    }

    public static Sound getSound(String string) {
        try {
            return Sounds.valueOf(string.toUpperCase()).getSound();
        }
        catch (Exception exception) {
            try {
                return Sound.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public static Sound getSound(String string, Sound sound) {
        try {
            return Sounds.valueOf(string.toUpperCase()).getSound();
        }
        catch (Exception exception) {
            try {
                return Sound.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return sound;
            }
        }
    }

    public static Sound getSoundException(String string) {
        try {
            return Sounds.valueOf(string.toUpperCase()).getSound();
        }
        catch (Exception exception) {
            return Sound.valueOf((String)string.toUpperCase());
        }
    }

    public static Material getMaterial(String string) {
        try {
            return Materials.valueOf(string).getMaterial();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return Material.valueOf((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    public static Material getMaterial(String string, Material material) {
        if (string == null) {
            return material;
        }
        try {
            return Materials.valueOf(string).getMaterial();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return Material.valueOf((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return material;
            }
        }
    }

    public static Material getMaterialException(String string) {
        try {
            return Materials.valueOf(string).getMaterial();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Material.valueOf((String)string);
        }
    }

    public static List<EntityType> getEntityTypes(String ... stringArray) {
        ArrayList<EntityType> arrayList = new ArrayList<EntityType>();
        for (String string : stringArray) {
            try {
                arrayList.add(EntityType.valueOf((String)string.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static List<EntityType> getEntityTypes(List<String> list) {
        ArrayList<EntityType> arrayList = new ArrayList<EntityType>();
        for (String string : list) {
            try {
                arrayList.add(EntityType.valueOf((String)string.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LocalUtils.logp("&cInvalid entity type: " + string.toUpperCase());
            }
        }
        return arrayList;
    }

    public static String limitString(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static void setUUID(NBTCompound nBTCompound, String string, UUID uUID) {
        if (AlonsoUtils.serverVersion.isOlderThan(AlonsoUtils.ServerVersion.v1_16)) {
            nBTCompound.setString(string, uUID.toString());
        } else {
            nBTCompound.setUUID(string, uUID);
        }
    }

    public static String pascalCase(String string) {
        return LocalUtils.pascalCase(string, false);
    }

    public static String pascalCase(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        if (string.length() <= 1) {
            return string.toUpperCase();
        }
        String string2 = bl ? string.trim().replace("_", " ").replace("-", " ") : string.trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : string2.split(" ")) {
            if (!string3.isEmpty()) {
                arrayList.add(string3.substring(0, 1).toUpperCase() + string3.substring(1).toLowerCase());
                continue;
            }
            arrayList.add("");
        }
        return String.join((CharSequence)" ", arrayList);
    }

    public static String firstCase(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim();
        if (string.length() <= 1) {
            return string2.toUpperCase();
        }
        return string2.substring(0, 1).toUpperCase() + string2.substring(1).toLowerCase();
    }

    public static String firstCase(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        if (!bl) {
            return LocalUtils.firstCase(string);
        }
        String string2 = string.trim();
        if (string.length() <= 1) {
            return string2.toUpperCase();
        }
        return (string2.substring(0, 1).toUpperCase() + string2.substring(1).toLowerCase()).replace("_", " ").replace("-", " ");
    }

    public static boolean isDay(long l) {
        if (l >= 24000L) {
            l %= 24000L;
        }
        return l > DAY_START || l < DAY_END;
    }

    public static boolean isNight(long l) {
        return !LocalUtils.isDay(l);
    }

    @Nullable
    public static Location decodeLocation(String string) {
        if (string == null) {
            return null;
        }
        try {
            String[] stringArray = string.split("\\|");
            World world = Bukkit.getWorld((String)stringArray[0]);
            if (world == null) {
                return null;
            }
            return new Location(world, Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]), Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5]));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void sendProtocolActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Player player, String string) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)string));
        try {
            if (alonsoPlugin.getPluginUtils().getActionBarProtocolMethod() == 0) {
                packetContainer.getBytes().write(0, (Object)2);
            } else {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            protocolManager.sendServerPacket(player, packetContainer);
        }
        catch (Exception exception) {
            LocalUtils.log(String.format("&c%s[ProtocolLib] Error sending Action Bar to %s", "[AlonsoTags] ", player.getName()));
        }
    }

    public static void sendProtocolActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Collection<? extends Player> collection, String string) {
        block5: {
            ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
            PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
            packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)string));
            try {
                if (alonsoPlugin.getPluginUtils().getActionBarProtocolMethod() == 0) {
                    packetContainer.getBytes().write(0, (Object)2);
                } else {
                    packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
                }
                for (Player player : collection) {
                    protocolManager.sendServerPacket(player, packetContainer);
                }
            }
            catch (Throwable throwable) {
                LocalUtils.log(String.format("&c%s[ProtocolLib] Error sending Action Bar to players.", "[AlonsoTags] "));
                if (!AlonsoTags.getInstance().debugMode) break block5;
                LocalUtils.logp("You are reading the following stacktrace because debug mode is enabled.");
                throwable.printStackTrace();
            }
        }
    }

    public static void sendBungeeActionBar(Player player, String string) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
    }

    public static void sendActionBar(AlonsoTags alonsoTags, Collection<? extends Player> collection, String string) {
        if (AlonsoTags.getInstance().debugMode) {
            LocalUtils.logp("ActionBarType is " + alonsoTags.getPluginUtils().getActionBarType().name() + ". Sending..");
        }
        if (alonsoTags.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.BUNGEE) {
            for (Player player : collection) {
                LocalUtils.sendBungeeActionBar(player, string);
            }
        } else if (alonsoTags.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.PROTOCOL) {
            LocalUtils.sendProtocolActionBar((AlonsoUtils.AlonsoPlugin)alonsoTags, collection, string);
        } else {
            for (Player player : collection) {
                player.sendMessage(string);
            }
        }
    }

    public static void sendActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Player player, String string) {
        if (alonsoPlugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.BUNGEE) {
            LocalUtils.sendBungeeActionBar(player, string);
        } else if (alonsoPlugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.PROTOCOL) {
            LocalUtils.sendProtocolActionBar(alonsoPlugin, player, string);
        } else {
            player.sendMessage(string);
        }
    }

    @Nullable
    public static String encodeLocation(Location location) {
        if (location == null) {
            return null;
        }
        try {
            String string = "%s|%s|%s|%s|%s|%s";
            return String.format(string, location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void send(CommandSender commandSender, String string) {
        commandSender.sendMessage(LocalUtils.colorize(string));
    }

    public static Collection<Material> getMaterials(String ... stringArray) {
        List<String> list = Arrays.asList(stringArray);
        return Stream.of(Material.values()).filter(material -> list.contains(material.name())).collect(Collectors.toList());
    }

    public static List<Location> getLocationsInLine(Location location, Location location2) {
        Vector vector = location2.toVector();
        location.setDirection(vector.subtract(location.toVector()));
        Vector vector2 = location.getDirection();
        double d = location.distance(location2);
        ArrayList<Location> arrayList = new ArrayList<Location>();
        arrayList.add(location.clone());
        int n = 0;
        while ((double)n < d) {
            Location location3 = location.add(vector2);
            arrayList.add(location3.clone());
            ++n;
        }
        return arrayList;
    }

    public static List<Location> getLocationsInLine(Location location, Location location2, double d) {
        Vector vector = location2.toVector();
        location.setDirection(vector.subtract(location.toVector()));
        Vector vector2 = location.getDirection();
        double d2 = location.distance(location2);
        ArrayList<Location> arrayList = new ArrayList<Location>();
        arrayList.add(location.clone());
        for (double d3 = 0.0; d3 < d2; d3 += d) {
            Location location3 = location.add(vector2);
            arrayList.add(location3.clone());
        }
        return arrayList;
    }

    public static String getDuration(long l) {
        return LocalUtils.getDuration(l, false);
    }

    public static String getDuration(long l, boolean bl) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        long l5 = l4 / 24L;
        if (l > 86399999L) {
            return Math.abs(l5) + "d " + Math.abs(l4 % 24L) + "h " + Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        if (l > 1439999L) {
            return Math.abs(l4 % 24L) + "h " + Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        if (l > 59999L || !bl) {
            return Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        long l6 = Math.abs(l2) % 60L;
        return (l6 <= 0L ? 1L : l6) + "s";
    }

    public static String getWatchDuration(long l) {
        return LocalUtils.getWatchDuration(l, true);
    }

    public static String getWatchDuration(long l, boolean bl) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        long l5 = l4 / 24L;
        if (bl) {
            if (l > 86399999L) {
                long l6 = Math.abs(l5);
                long l7 = Math.abs(l4 % 24L);
                long l8 = Math.abs(l3 % 60L);
                long l9 = Math.abs(l2 % 60L);
                return (l6 < 10L ? "0" + l6 : Long.valueOf(l7)) + ":" + (l7 < 10L ? "0" + l7 : Long.valueOf(l7)) + ":" + (l8 < 10L ? "0" + l8 : Long.valueOf(l8)) + ":" + (l9 < 10L ? "0" + l9 : Long.valueOf(l9));
            }
            if (l > 1439999L) {
                long l10 = Math.abs(l4 % 24L);
                long l11 = Math.abs(l3 % 60L);
                long l12 = Math.abs(l2 % 60L);
                return (l10 < 10L ? "0" + l10 : Long.valueOf(l10)) + ":" + (l11 < 10L ? "0" + l11 : Long.valueOf(l11)) + ":" + (l12 < 10L ? "0" + l12 : Long.valueOf(l12));
            }
            long l13 = Math.abs(l3) % 60L;
            long l14 = Math.abs(l2) % 60L;
            return (l13 < 10L ? "0" + l13 : Long.valueOf(l13)) + ":" + (l14 < 10L ? "0" + l14 : Long.valueOf(l14));
        }
        if (l > 86399999L) {
            return Math.abs(l5) + ":" + Math.abs(l4 % 24L) + ":" + Math.abs(l3) % 60L + ":" + Math.abs(l2) % 60L;
        }
        if (l > 1439999L) {
            return Math.abs(l4 % 24L) + ":" + Math.abs(l3) % 60L + ":" + Math.abs(l2) % 60L;
        }
        return Math.abs(l3) % 60L + ":" + Math.abs(l2) % 60L;
    }

    public static String random(List<String> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static <E> E randomNbt(List<E> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static LivingEntity getLivingEntityAround(Player player, UUID uUID, int n, int n2) {
        Optional<Entity> optional = player.getNearbyEntities((double)n2, (double)n2, (double)n2).stream().filter(entity -> entity instanceof LivingEntity && entity.getEntityId() == n).findFirst();
        return optional.orElse(null);
    }

    public static TextComponent createClickable(@Nonnull String string, HoverEvent.Action action, @Nullable String string2, ClickEvent.Action action2, String string3) {
        TextComponent textComponent = new TextComponent(LocalUtils.colorize(string));
        if (string2 != null && action != null) {
            if (oldHoverMethod) {
                textComponent.setHoverEvent(new HoverEvent(action, new ComponentBuilder(LocalUtils.colorize(string2)).create()));
            } else {
                textComponent.setHoverEvent(new HoverEvent(action, new Content[]{new Text(LocalUtils.colorize(string2))}));
            }
        }
        if (string3 != null && action2 != null) {
            textComponent.setClickEvent(new ClickEvent(action2, string3));
        }
        return textComponent;
    }

    public static void sendTitle(Player player, String string, String string2, int n, int n2, int n3) {
        if (oldSendTitleMethod) {
            player.sendTitle(LocalUtils.colorize(string), LocalUtils.colorize(string2));
        } else {
            player.sendTitle(LocalUtils.colorize(string), LocalUtils.colorize(string2), n, n2, n3);
        }
    }

    public static void sendTitle(Player player, String string, String string2) {
        LocalUtils.sendTitle(player, string, string2, 15, 30, 15);
    }

    public static void sendTitle(Collection<? extends Player> collection, String string, String string2) {
        LocalUtils.sendTitle(collection, string, string2, 15, 30, 15);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendTitle(Collection<? extends Player> collection, String string, String string2, int n, int n2, int n3) {
        if (newSendTitleMethod) {
            for (Player player : collection) {
                player.sendTitle(LocalUtils.colorize(string), LocalUtils.colorize(string2), n, n2, n3);
            }
            return;
        } else {
            if (!oldSendTitleMethod) return;
            try {
                for (Player player : collection) {
                    METHOD_OLD_SEND_TITLE.invoke((Object)player, LocalUtils.colorize(string), LocalUtils.colorize(string2));
                }
                return;
            }
            catch (Throwable throwable) {
                LocalUtils.loge("Error with Reflections in old sendTitle method.");
                if (!AlonsoTags.getInstance().debugMode) return;
                LocalUtils.loge("You are reading this stacktrace because debug mode is enabled.");
                throwable.printStackTrace();
            }
        }
    }

    public static ItemMeta setUnbreakable(ItemMeta itemMeta, boolean bl) {
        block5: {
            if (newSetUnbreakableMethod) {
                itemMeta.setUnbreakable(bl);
            } else if (setUnbreakableSupport) {
                try {
                    Object object = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                    METHOD_SET_UNBREAKABLE_OLD.invoke(object, bl);
                }
                catch (Throwable throwable) {
                    if (!AlonsoTags.getInstance().debugMode) break block5;
                    LocalUtils.loge("Reflections for setUnbreakable method failed. This is a debug message!");
                }
            }
        }
        return itemMeta;
    }

    public static boolean isUnbreakable(ItemMeta itemMeta) {
        block4: {
            if (newSetUnbreakableMethod) {
                return itemMeta.isUnbreakable();
            }
            if (setUnbreakableSupport) {
                try {
                    Object object = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                    return (Boolean)METHOD_IS_UNBREAKABLE_OLD.invoke(object, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!AlonsoTags.getInstance().debugMode) break block4;
                    LocalUtils.loge("Reflections for isUnbreakable method failed. This is a debug message!");
                }
            }
        }
        return false;
    }

    public static void findClasses(String string, String ... stringArray) {
        boolean bl = false;
        for (String string2 : stringArray) {
            try {
                Class.forName(string2);
                bl = true;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (!bl) {
            Class.forName(string);
        }
    }

    public static String fixInventoryTitle(String string) {
        return longInventoryTitleSupport ? string : (string.length() > 32 ? string.substring(0, 32) : string);
    }

    public static boolean isClickableTextSupported() {
        return clickableTextSupport;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean setMaxHealth(Player player, double d) {
        if (setMaxHealthFeatureSupport) {
            if (setMaxHealthAttributeSupport) {
                AttributeInstance attributeInstance = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                if (attributeInstance == null) return false;
                attributeInstance.setBaseValue(d);
                return true;
            }
            try {
                METHOD_SET_MAX_HEALTH.invoke((Object)player, d);
                return true;
            }
            catch (Throwable throwable) {
                if (!AlonsoTags.getInstance().debugMode) return false;
                LocalUtils.logp("Reflections to set max health failed. This is a debug message!");
                return false;
            }
        } else {
            if (!AlonsoTags.getInstance().debugMode) return false;
            LocalUtils.logp("Set max health feature is NOT available in this server. Do NOT use it.");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getMaxHealth(Player player) {
        if (getMaxHealthFeatureSupport) {
            if (getMaxHealthAttributeSupport) {
                AttributeInstance attributeInstance = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                if (attributeInstance == null) return 20.0;
                return attributeInstance.getValue();
            }
            try {
                Object object = METHOD_GET_MAX_HEALTH.invoke((Object)player, new Object[0]);
                return object instanceof Double ? (Double)object : (double)((Integer)object).intValue();
            }
            catch (Throwable throwable) {
                if (!AlonsoTags.getInstance().debugMode) return 20.0;
                LocalUtils.logp("Reflections to get max health failed. This is a debug message!");
                return 20.0;
            }
        } else {
            if (!AlonsoTags.getInstance().debugMode) return 20.0;
            LocalUtils.logp("Get max health feature is NOT available in this server. Do NOT use it.");
        }
        return 20.0;
    }

    public static boolean hasPermission(CommandSender commandSender, String string) {
        return string == null || commandSender.hasPermission(string);
    }

    public static org.bukkit.Color getColor(String string) {
        return LocalUtils.getColor(string, null);
    }

    public static org.bukkit.Color getColor(String string, org.bukkit.Color color) {
        Color color2;
        Object object;
        block14: {
            if (AlonsoTags.getInstance().debugMode) {
                LocalUtils.logp("Checking if '" + string + "' is a color..");
            }
            try {
                object = Color.class.getField(string);
                color2 = (Color)((Field)object).get(null);
                if (AlonsoTags.getInstance().debugMode) {
                    LocalUtils.logp("java.awt.Color field is " + (color2 == null ? "" : "not ") + "null");
                }
                if (color2 != null) {
                    return org.bukkit.Color.fromRGB((int)color2.getRed(), (int)color2.getGreen(), (int)color2.getBlue());
                }
            }
            catch (Throwable throwable) {
                if (!AlonsoTags.getInstance().debugMode) break block14;
                throwable.printStackTrace();
                LocalUtils.logp("java.awt.Color field is null (getRGB)");
            }
        }
        try {
            object = Color.decode(string.startsWith("#") ? string : "#" + string);
            if (AlonsoTags.getInstance().debugMode) {
                LocalUtils.logp("java.awt.Color field is " + (object == null ? "" : "not ") + "null");
            }
            return org.bukkit.Color.fromRGB((int)((Color)object).getRGB());
        }
        catch (Throwable throwable) {
            if (AlonsoTags.getInstance().debugMode) {
                LocalUtils.logp("java.awt.Color.decode is null (" + (string.startsWith("#") ? string : "#" + string) + ")");
            }
            try {
                color2 = org.bukkit.Color.fromRGB((int)Integer.parseInt(string));
                if (AlonsoTags.getInstance().debugMode) {
                    LocalUtils.logp("Color.fromRGB is not null (" + color2.asRGB() + ").");
                }
                return color2;
            }
            catch (Throwable throwable2) {
                if (AlonsoTags.getInstance().debugMode) {
                    LocalUtils.logp("Color.fromRGB is null (" + string + ") not a valid color int.");
                }
                if (AlonsoTags.getInstance().debugMode) {
                    LocalUtils.logp("Using default color " + color + "!");
                }
                return color;
            }
        }
    }

    public static String setPlaceholders(Player player, String string) {
        if (string.isEmpty()) {
            return string;
        }
        String string2 = player.getName();
        String string3 = player.getWorld().getName();
        String string4 = player.getWorld().getUID().toString();
        String string5 = String.valueOf(player.getLocation().getBlockX());
        String string6 = String.valueOf(player.getLocation().getBlockY());
        String string7 = String.valueOf(player.getLocation().getBlockZ());
        String string8 = player.getUniqueId().toString();
        if ((string = string.replace("{PLAYER}", string2).replace("{UUID}", string8).replace("{WORLD}", string3).replace("{WORLD_UUID}", string4).replace("{X}", string5).replace("{Y}", string6).replace("{Z}", string7)).contains("{UNIQUE_PLAYERS}")) {
            string = string.replace("{UNIQUE_PLAYERS}", String.valueOf(Bukkit.getOfflinePlayers().length + 1));
        }
        return LocalUtils.colorize(AlonsoUtils.PluginUtils.hasPlaceholderApiSupport() ? PlaceholderAPI.setPlaceholders((Player)player, (String)string) : string);
    }

    public static String setPlaceholders(Player player, String string, HashMap<String, String> hashMap) {
        if (string.isEmpty()) {
            return string;
        }
        String string2 = player.getName();
        String string3 = player.getWorld().getName();
        String string4 = player.getWorld().getUID().toString();
        String string5 = String.valueOf(player.getLocation().getBlockX());
        String string6 = String.valueOf(player.getLocation().getBlockY());
        String string7 = String.valueOf(player.getLocation().getBlockZ());
        String string8 = player.getUniqueId().toString();
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            string = string.replace(entry.getKey(), entry.getValue());
        }
        if ((string = string.replace("{PLAYER}", string2).replace("{UUID}", string8).replace("{WORLD}", string3).replace("{WORLD_UUID}", string4).replace("{X}", string5).replace("{Y}", string6).replace("{Z}", string7)).contains("{UNIQUE_PLAYERS}")) {
            string = string.replace("{UNIQUE_PLAYERS}", String.valueOf(Bukkit.getOfflinePlayers().length + 1));
        }
        return LocalUtils.colorize(AlonsoUtils.PluginUtils.hasPlaceholderApiSupport() ? PlaceholderAPI.setPlaceholders((Player)player, (String)string) : string);
    }

    public static boolean isSoundCategoryAvailable() {
        return soundCategorySupport;
    }

    static {
        Object object;
        ItemMeta itemMeta;
        ItemStack itemStack;
        Object object2;
        DAY_START = 22750L;
        DAY_END = 12750L;
        fixColors = true;
        colorMap = new HashMap<org.bukkit.ChatColor, ColorSet<Integer, Integer, Integer>>();
        METHOD_SET_UNBREAKABLE_OLD = null;
        METHOD_IS_UNBREAKABLE_OLD = null;
        METHOD_ITEM_META_SPIGOT = null;
        METHOD_OLD_SEND_TITLE = null;
        METHOD_GET_MAX_HEALTH = null;
        METHOD_SET_MAX_HEALTH = null;
        try {
            Player.class.getMethod("getAttribute", Attribute.class);
            getMaxHealthAttributeSupport = true;
            setMaxHealthAttributeSupport = true;
            getMaxHealthFeatureSupport = true;
            setMaxHealthFeatureSupport = true;
            LocalUtils.logp("Max health Attribute check found. Using it..");
        }
        catch (Throwable throwable) {
            getMaxHealthAttributeSupport = false;
            setMaxHealthAttributeSupport = false;
            try {
                METHOD_GET_MAX_HEALTH = Player.class.getMethod("getMaxHealth", new Class[0]);
                getMaxHealthFeatureSupport = true;
                LocalUtils.logp("Max health Attribute check not found. Using Player#getMaxHealth method..");
            }
            catch (Throwable throwable2) {
                getMaxHealthFeatureSupport = false;
                LocalUtils.logp("Max health check couldn't be loaded. Feature will be disabled and will always return 20..");
            }
            try {
                METHOD_SET_MAX_HEALTH = Player.class.getMethod("setMaxHealth", Double.TYPE);
                setMaxHealthFeatureSupport = true;
                LocalUtils.logp("Max health Attribute check not found. Using Player#getMaxHealth method..");
            }
            catch (Throwable throwable3) {
                setMaxHealthFeatureSupport = false;
                LocalUtils.logp("Max health check couldn't be loaded. Feature will be disabled and will always return 20..");
            }
        }
        try {
            object2 = Bukkit.createInventory(null, (int)9, (String)"Hello Thanks For Downloading My Plugin. Consider donating to support my work on https://alonsoaliaga.com/donate");
            object2.setItem(0, new ItemStack(Materials.PLAYER_HEAD.getMaterial()));
            longInventoryTitleSupport = true;
            LocalUtils.logp("Inventory title with support for more than 32 characters. Skipping..");
        }
        catch (Throwable throwable) {
            longInventoryTitleSupport = false;
            LocalUtils.logp("Inventory title without support for more than 32 characters. Limiting..");
        }
        try {
            object2 = Class.forName("net.md_5.bungee.api.ChatColor");
            ((Class)object2).getDeclaredMethod("of", String.class);
            hexColorSupport = true;
            LocalUtils.logp("Hex colors are available! Ready for RGB..");
        }
        catch (Throwable throwable) {
            hexColorSupport = false;
            LocalUtils.logp("Hex colors are not available! Ignoring..");
        }
        try {
            Class.forName("org.bukkit.SoundCategory");
            soundCategorySupport = true;
        }
        catch (Throwable throwable) {
            soundCategorySupport = false;
        }
        try {
            HoverEvent.class.getDeclaredConstructor(HoverEvent.Action.class, BaseComponent[].class);
            oldHoverMethod = true;
            clickableTextSupport = true;
            LocalUtils.logp("Old constructor for HoverEvent found! Using it..");
        }
        catch (Throwable throwable) {
            oldHoverMethod = false;
            try {
                itemStack = Class.forName("org.bukkit.entity.Player$Spigot");
                itemStack.getDeclaredMethod("sendMessage", TextComponent.class);
                clickableTextSupport = true;
                LocalUtils.logp("Old constructor for HoverEvent not found! Using the new one..");
            }
            catch (Throwable throwable4) {
                clickableTextSupport = false;
                LocalUtils.logp("Clickable text is not available, consider using spigot or forks! Skipping..");
            }
        }
        try {
            Player.class.getDeclaredMethod("sendTitle", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            newSendTitleMethod = true;
            LocalUtils.logp("New sendTitle method found! Using it..");
        }
        catch (Throwable throwable) {
            newSendTitleMethod = false;
            try {
                METHOD_OLD_SEND_TITLE = Player.class.getDeclaredMethod("sendTitle", String.class, String.class);
                oldSendTitleMethod = true;
                LocalUtils.logp("Old sendTitle method found! Using it as..");
            }
            catch (Throwable throwable5) {
                oldSendTitleMethod = false;
                LocalUtils.logp("Old sendTitle method not found! Ignoring..");
            }
        }
        try {
            ItemMeta.class.getDeclaredMethod("setUnbreakable", Boolean.TYPE);
            newSetUnbreakableMethod = true;
            setUnbreakableSupport = true;
            LocalUtils.logp("New setUnbreakable method found! Using it..");
        }
        catch (Throwable throwable) {
            try {
                METHOD_ITEM_META_SPIGOT = ItemMeta.class.getDeclaredMethod("spigot", new Class[0]);
                itemStack = new ItemStack(LocalUtils.findMaterial("COBBLESTONE", "PLAYER_HEAD", "SKULL", "STONE"));
                itemMeta = itemStack.getItemMeta();
                object = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                METHOD_SET_UNBREAKABLE_OLD = object.getClass().getDeclaredMethod("setUnbreakable", Boolean.TYPE);
                itemStack.setItemMeta(itemMeta);
                newSetUnbreakableMethod = false;
                setUnbreakableSupport = true;
                LocalUtils.logp("New setUnbreakable method not found! Using the old one for spigot ONLY..");
            }
            catch (Throwable throwable6) {
                newSetUnbreakableMethod = false;
                setUnbreakableSupport = false;
                LocalUtils.logp("Server type/version does not support setUnbreakable method. Consider using spigot/paper!");
            }
        }
        try {
            Player.class.getMethod("openBook", ItemStack.class);
            nativeOpenBookSupport = true;
        }
        catch (Throwable throwable) {
            nativeOpenBookSupport = false;
        }
        try {
            ItemMeta.class.getDeclaredMethod("isUnbreakable", new Class[0]);
            newIsUnbreakableMethod = true;
            isUnbreakableSupport = true;
            LocalUtils.logp("New isUnbreakable method found! Using it..");
        }
        catch (Throwable throwable) {
            try {
                METHOD_ITEM_META_SPIGOT = ItemMeta.class.getDeclaredMethod("spigot", new Class[0]);
                itemStack = new ItemStack(LocalUtils.findMaterial("COBBLESTONE", "PLAYER_HEAD", "SKULL", "STONE"));
                itemMeta = itemStack.getItemMeta();
                object = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                METHOD_IS_UNBREAKABLE_OLD = object.getClass().getDeclaredMethod("isUnbreakable", new Class[0]);
                itemStack.setItemMeta(itemMeta);
                newIsUnbreakableMethod = false;
                isUnbreakableSupport = true;
                LocalUtils.logp("New isUnbreakable method not found! Using the old one for spigot ONLY..");
            }
            catch (Throwable throwable7) {
                newIsUnbreakableMethod = false;
                isUnbreakableSupport = false;
                LocalUtils.logp("Server type/version does not support isUnbreakable method. Consider using spigot/paper!");
            }
        }
        if (hexColorSupport) {
            LocalUtils.log("Enabling HEX color fix for 1.8 - 1.15 players.. (This is an experimental feature");
            colorMap.put(org.bukkit.ChatColor.BLACK, new ColorSet<Integer, Integer, Integer>(0, 0, 0));
            colorMap.put(org.bukkit.ChatColor.DARK_BLUE, new ColorSet<Integer, Integer, Integer>(0, 0, 170));
            colorMap.put(org.bukkit.ChatColor.DARK_GREEN, new ColorSet<Integer, Integer, Integer>(0, 170, 0));
            colorMap.put(org.bukkit.ChatColor.DARK_AQUA, new ColorSet<Integer, Integer, Integer>(0, 170, 170));
            colorMap.put(org.bukkit.ChatColor.DARK_RED, new ColorSet<Integer, Integer, Integer>(170, 0, 0));
            colorMap.put(org.bukkit.ChatColor.DARK_PURPLE, new ColorSet<Integer, Integer, Integer>(170, 0, 170));
            colorMap.put(org.bukkit.ChatColor.GOLD, new ColorSet<Integer, Integer, Integer>(255, 170, 0));
            colorMap.put(org.bukkit.ChatColor.GRAY, new ColorSet<Integer, Integer, Integer>(170, 170, 170));
            colorMap.put(org.bukkit.ChatColor.DARK_GRAY, new ColorSet<Integer, Integer, Integer>(85, 85, 85));
            colorMap.put(org.bukkit.ChatColor.BLUE, new ColorSet<Integer, Integer, Integer>(85, 85, 255));
            colorMap.put(org.bukkit.ChatColor.GREEN, new ColorSet<Integer, Integer, Integer>(85, 255, 85));
            colorMap.put(org.bukkit.ChatColor.AQUA, new ColorSet<Integer, Integer, Integer>(85, 255, 255));
            colorMap.put(org.bukkit.ChatColor.RED, new ColorSet<Integer, Integer, Integer>(255, 85, 85));
            colorMap.put(org.bukkit.ChatColor.LIGHT_PURPLE, new ColorSet<Integer, Integer, Integer>(255, 85, 255));
            colorMap.put(org.bukkit.ChatColor.YELLOW, new ColorSet<Integer, Integer, Integer>(255, 255, 85));
            colorMap.put(org.bukkit.ChatColor.WHITE, new ColorSet<Integer, Integer, Integer>(255, 255, 255));
        }
        PATTERN_TO_REMOVE_FORMATTING = Pattern.compile("(\u00a7x(\u00a7[a-f0-9]){6}|([\u00a7&])[a-f0-9klmnor]|(&?#[a-f0-9]{6}))", 2);
        HEX_COLOR_PATTERN = Pattern.compile("&?#[a-f0-9]{6}", 2);
        PARSED_HEX_PATTERN = Pattern.compile("\u00a7x(\u00a7[a-f0-9]){6}", 2);
        PARSED_PATTERN_COLORS = Pattern.compile("\u00a7[a-f0-9klmnor]", 2);
        PARSED_OLD_LEGACY_HEX_PATTERN = Pattern.compile("[&\u00a7]x([&\u00a7][a-f0-9]){6}", 2);
        placeholderHexFormat = "&#{COLOR}";
        ADD_AMPERSAND_HEX_PATTERN = Pattern.compile("(?<!&)#[a-f0-9]{6}", 2);
        REMOVE_AMPERSAND_HEX_PATTERN = Pattern.compile("&#[a-f0-9]{6}", 2);
    }

    private static class ColorSet<R, G, B> {
        R red = null;
        G green = null;
        B blue = null;

        ColorSet(R r, G g, B b) {
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        public R getRed() {
            return this.red;
        }

        public G getGreen() {
            return this.green;
        }

        public B getBlue() {
            return this.blue;
        }
    }
}

