/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.angelchest.jefflib.internal.nms.v1_16_R3.ai;

import de.jeff_media.angelchest.jefflib.ai.goal.PathfinderGoal;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.EntityCreature;
import net.minecraft.server.v1_16_R3.IWorldReader;
import net.minecraft.server.v1_16_R3.PathfinderGoalGotoTarget;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Creature;

public abstract class HatchedMoveToBlockGoal
extends PathfinderGoalGotoTarget
implements PathfinderGoal {
    protected final Creature bukkitEntity;

    public HatchedMoveToBlockGoal(Creature creature, EntityCreature entityCreature, double d2, int n2, int n3) {
        super(entityCreature, d2, n2, n3);
        this.bukkitEntity = creature;
    }

    public Creature getBukkitEntity() {
        return this.bukkitEntity;
    }

    public static class ByBlockPredicate
    extends HatchedMoveToBlockGoal {
        private final Predicate<org.bukkit.block.Block> predicate;

        public ByBlockPredicate(Creature creature, EntityCreature entityCreature, double d2, int n2, int n3, Predicate<org.bukkit.block.Block> predicate) {
            super(creature, entityCreature, d2, n2, n3);
            this.predicate = predicate;
        }

        protected boolean a(IWorldReader iWorldReader, BlockPosition blockPosition) {
            return this.predicate.test(this.bukkitEntity.getWorld().getBlockAt(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ()));
        }

        @Override
        public boolean canUse() {
            return this.a();
        }
    }

    public static class ByMaterialSet
    extends HatchedMoveToBlockGoal {
        private final Set<Block> validBlockTypes;

        public ByMaterialSet(Creature creature, EntityCreature entityCreature, double d2, int n2, int n3, Set<Material> set) {
            super(creature, entityCreature, d2, n2, n3);
            this.validBlockTypes = ByMaterialSet.getBlockTypes(set);
        }

        private static Set<Block> getBlockTypes(Set<Material> set) {
            return set.stream().map(CraftMagicNumbers::getBlock).collect(Collectors.toSet());
        }

        @Override
        public boolean canUse() {
            return this.a();
        }

        protected boolean a(IWorldReader iWorldReader, BlockPosition blockPosition) {
            return this.validBlockTypes.contains(iWorldReader.getType(blockPosition).getBlock());
        }
    }
}

