/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.ai;

import de.jeff_media.angelchest.jefflib.ai.goal.PathfinderGoal;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.level.IWorldReader;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Creature;

public abstract class HatchedMoveToBlockGoal
extends PathfinderGoalGotoTarget
implements PathfinderGoal {
    protected final Creature bukkitEntity;

    public HatchedMoveToBlockGoal(Creature creature, EntityCreature entityCreature, double d2, int n2, int n3) {
        super(entityCreature, d2, n2, n3);
        this.bukkitEntity = creature;
    }

    public Creature getBukkitEntity() {
        return this.bukkitEntity;
    }

    public static class ByBlockPredicate
    extends HatchedMoveToBlockGoal {
        private final Predicate<Block> predicate;

        public ByBlockPredicate(Creature creature, EntityCreature entityCreature, double d2, int n2, int n3, Predicate<Block> predicate) {
            super(creature, entityCreature, d2, n2, n3);
            this.predicate = predicate;
        }

        protected boolean a(IWorldReader iWorldReader, BlockPosition blockPosition) {
            return this.predicate.test(this.bukkitEntity.getWorld().getBlockAt(blockPosition.u(), blockPosition.v(), blockPosition.w()));
        }
    }

    public static class ByMaterialSet
    extends HatchedMoveToBlockGoal {
        private final Set<net.minecraft.world.level.block.Block> validBlockTypes;

        public ByMaterialSet(Creature creature, EntityCreature entityCreature, double d2, int n2, int n3, Set<Material> set) {
            super(creature, entityCreature, d2, n2, n3);
            this.validBlockTypes = ByMaterialSet.getBlockTypes(set);
        }

        private static Set<net.minecraft.world.level.block.Block> getBlockTypes(Set<Material> set) {
            return set.stream().map(CraftMagicNumbers::getBlock).collect(Collectors.toSet());
        }

        protected boolean a(IWorldReader iWorldReader, BlockPosition blockPosition) {
            return this.validBlockTypes.contains(iWorldReader.a_(blockPosition).b());
        }
    }
}

