/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.metrics.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.zaxxer.hikari.metrics.IMetricsTracker;
import com.zaxxer.hikari.metrics.PoolStats;
import java.util.concurrent.TimeUnit;

public final class CodaHaleMetricsTracker
implements IMetricsTracker {
    private final String poolName;
    private final Timer connectionObtainTimer;
    private final Histogram connectionUsage;
    private final Histogram connectionCreation;
    private final Meter connectionTimeoutMeter;
    private final MetricRegistry registry;
    private static final String METRIC_CATEGORY = "pool";
    private static final String METRIC_NAME_WAIT = "Wait";
    private static final String METRIC_NAME_USAGE = "Usage";
    private static final String METRIC_NAME_CONNECT = "ConnectionCreation";
    private static final String METRIC_NAME_TIMEOUT_RATE = "ConnectionTimeoutRate";
    private static final String METRIC_NAME_TOTAL_CONNECTIONS = "TotalConnections";
    private static final String METRIC_NAME_IDLE_CONNECTIONS = "IdleConnections";
    private static final String METRIC_NAME_ACTIVE_CONNECTIONS = "ActiveConnections";
    private static final String METRIC_NAME_PENDING_CONNECTIONS = "PendingConnections";
    private static final String METRIC_NAME_MAX_CONNECTIONS = "MaxConnections";
    private static final String METRIC_NAME_MIN_CONNECTIONS = "MinConnections";

    CodaHaleMetricsTracker(String string, PoolStats poolStats, MetricRegistry metricRegistry) {
        this.poolName = string;
        this.registry = metricRegistry;
        this.connectionObtainTimer = metricRegistry.timer(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_WAIT}));
        this.connectionUsage = metricRegistry.histogram(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_USAGE}));
        this.connectionCreation = metricRegistry.histogram(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_CONNECT}));
        this.connectionTimeoutMeter = metricRegistry.meter(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_TIMEOUT_RATE}));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_TOTAL_CONNECTIONS}), (Metric)((Gauge)poolStats::getTotalConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_IDLE_CONNECTIONS}), (Metric)((Gauge)poolStats::getIdleConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_ACTIVE_CONNECTIONS}), (Metric)((Gauge)poolStats::getActiveConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_PENDING_CONNECTIONS}), (Metric)((Gauge)poolStats::getPendingThreads));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_MAX_CONNECTIONS}), (Metric)((Gauge)poolStats::getMaxConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_MIN_CONNECTIONS}), (Metric)((Gauge)poolStats::getMinConnections));
    }

    @Override
    public void close() {
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_WAIT}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_USAGE}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_CONNECT}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_TIMEOUT_RATE}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_TOTAL_CONNECTIONS}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_IDLE_CONNECTIONS}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_ACTIVE_CONNECTIONS}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_PENDING_CONNECTIONS}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_MAX_CONNECTIONS}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_MIN_CONNECTIONS}));
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.connectionObtainTimer.update(l, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.connectionUsage.update(l);
    }

    @Override
    public void recordConnectionTimeout() {
        this.connectionTimeoutMeter.mark();
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.connectionCreation.update(l);
    }

    public Timer getConnectionAcquisitionTimer() {
        return this.connectionObtainTimer;
    }

    public Histogram getConnectionDurationHistogram() {
        return this.connectionUsage;
    }

    public Histogram getConnectionCreationHistogram() {
        return this.connectionCreation;
    }
}

