/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting;

import cz.larkyy.aquaticcratestesting.animation.task.Tasks;
import cz.larkyy.aquaticcratestesting.commands.CommandCompleter;
import cz.larkyy.aquaticcratestesting.commands.Commands;
import cz.larkyy.aquaticcratestesting.crate.CrateHandler;
import cz.larkyy.aquaticcratestesting.crate.CrateListener;
import cz.larkyy.aquaticcratestesting.crate.reward.RewardActions;
import cz.larkyy.aquaticcratestesting.dabatase.DatabaseManager;
import cz.larkyy.aquaticcratestesting.hooks.PAPIHook;
import cz.larkyy.aquaticcratestesting.item.ItemHandler;
import cz.larkyy.aquaticcratestesting.loader.LoaderManager;
import cz.larkyy.aquaticcratestesting.messages.MessageHandler;
import cz.larkyy.aquaticcratestesting.nms.NMSHandler;
import cz.larkyy.aquaticcratestesting.player.PlayerHandler;
import cz.larkyy.aquaticcratestesting.player.PlayerListener;
import cz.larkyy.aquaticcratestesting.utils.colors.Colors;
import cz.larkyy.nms.impl.impl.v1_16_R3;
import cz.larkyy.nms.impl.impl.v1_17_R1;
import cz.larkyy.nms.impl.impl.v1_18_R2;
import cz.larkyy.nms.impl.impl.v1_19_R2;
import cz.larkyy.nms.impl.v1_19_R3;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import xyz.larkyy.nms.v1_19_4.V1_19_4;

public final class AquaticCratesTesting
extends JavaPlugin {
    private static PlayerHandler playerHandler;
    private static Tasks tasks;
    private static RewardActions rewardActions;
    private static CrateHandler crateHandler;
    private static DatabaseManager databaseManager;
    private static NMSHandler nmsHandler;
    private static MessageHandler messageHandler;
    private static ItemHandler itemHandler;
    public static boolean loaded;

    public void onEnable() {
        AquaticCratesTesting.loadConfig0();
        Bukkit.getConsoleSender().sendMessage(Colors.format("&bAquaticCrates &8| &fLoading the plugin..."));
        tasks = new Tasks();
        rewardActions = new RewardActions();
        itemHandler = new ItemHandler();
        crateHandler = new CrateHandler();
        playerHandler = new PlayerHandler();
        databaseManager = new DatabaseManager();
        messageHandler = new MessageHandler();
        Bukkit.getConsoleSender().sendMessage(Colors.format("&bAquaticCrates &8| &fLoading &7NMS Version&f!"));
        String string = "null";
        switch (this.getServer().getBukkitVersion()) {
            case "1.16.5-R0.1-SNAPSHOT": {
                nmsHandler = new v1_16_R3();
                string = "v1_16_R3";
                break;
            }
            case "1.17.1-R0.1-SNAPSHOT": {
                nmsHandler = new v1_17_R1();
                string = "v1_17_R1";
                break;
            }
            case "1.18.2-R0.1-SNAPSHOT": {
                nmsHandler = new v1_18_R2();
                string = "v1_18_R2";
                break;
            }
            case "1.19.2-R0.1-SNAPSHOT": {
                nmsHandler = new v1_19_R2();
                string = "v1_19_R2";
                break;
            }
            case "1.19.3-R0.1-SNAPSHOT": {
                nmsHandler = new v1_19_R3();
                string = "v1_19_R3";
                break;
            }
            case "1.19.4-R0.1-SNAPSHOT": {
                nmsHandler = new V1_19_4();
                string = "v1_19_R4";
            }
        }
        Bukkit.getConsoleSender().sendMessage(Colors.format("&bAquaticCrates &8| &fUsing NMS version &7" + string + "&f."));
        this.getCommand("aquaticcrates").setExecutor((CommandExecutor)new Commands());
        this.getCommand("aquaticcrates").setTabCompleter((TabCompleter)new CommandCompleter());
        this.getServer().getPluginManager().registerEvents((Listener)new CrateListener(), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            Bukkit.getConsoleSender().sendMessage(Colors.format("&bAquaticCrates &8| &fLoading &7PlaceholderAPI Hook&f!"));
            new PAPIHook().register();
        }
        Bukkit.getConsoleSender().sendMessage(Colors.format("&bAquaticCrates &8| &fLoading &7Database&f!"));
        try {
            databaseManager.setup();
        }
        catch (IOException | ClassNotFoundException | SQLException exception) {
            throw new RuntimeException(exception);
        }
        new LoaderManager(() -> new BukkitRunnable(){

            public void run() {
                if (loaded) {
                    AquaticCratesTesting.this.unload();
                }
                new BukkitRunnable(){

                    public void run() {
                        AquaticCratesTesting.this.load();
                        loaded = true;
                    }
                }.runTaskLater((Plugin)AquaticCratesTesting.instance(), 1L);
            }
        }.runTask((Plugin)this));
    }

    public void load() {
        Bukkit.getConsoleSender().sendMessage(Colors.format("&bAquaticCrates &8| &fLoading &7Item Database&f!"));
        itemHandler.load();
        Bukkit.getConsoleSender().sendMessage(Colors.format("&bAquaticCrates &8| &fLoading &7Crates&f!"));
        crateHandler.load();
        Bukkit.getConsoleSender().sendMessage(Colors.format("&bAquaticCrates &8| &fLoading &7Players&f!"));
        playerHandler.loadPlayers(() -> this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this));
        Bukkit.getConsoleSender().sendMessage(Colors.format("&bAquaticCrates &8| &fLoading &7Messages!"));
        messageHandler.load();
        Bukkit.getConsoleSender().sendMessage(Colors.format("&bAquaticCrates &8| &fPlugin &aLoaded&f!"));
    }

    public void unload() {
        crateHandler.unloadCrates();
        playerHandler.savePlayers(false);
        Bukkit.getWorlds().forEach(world -> world.getEntities().forEach(entity -> {
            if ("aquaticcrates".equals(entity.getCustomName())) {
                entity.setPersistent(false);
                entity.remove();
            }
        }));
        playerHandler.unloadPlayers();
    }

    public void reload() {
        this.unload();
        this.load();
    }

    public void onDisable() {
        this.unload();
        Bukkit.getLogger().info("DISABLING");
    }

    public static PlayerHandler getPlayerHandler() {
        return playerHandler;
    }

    public static CrateHandler getCrateHandler() {
        return crateHandler;
    }

    public static DatabaseManager getDatabaseManager() {
        return databaseManager;
    }

    public static AquaticCratesTesting instance() {
        return (AquaticCratesTesting)AquaticCratesTesting.getPlugin(AquaticCratesTesting.class);
    }

    public static NMSHandler getNmsHandler() {
        return nmsHandler;
    }

    public static ItemHandler getItemHandler() {
        return itemHandler;
    }

    public static MessageHandler getMessageHandler() {
        return messageHandler;
    }

    public static Tasks getTasks() {
        return tasks;
    }

    public static RewardActions getRewardActions() {
        return rewardActions;
    }

    static {
        loaded = false;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=%%__USER__%%&resource_id=%%__RESOURCE__%%&nonce=9379992").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

