/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.config;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.animation.AnimationEmote;
import cz.larkyy.aquaticcratestesting.animation.AnimationManager;
import cz.larkyy.aquaticcratestesting.animation.AnimationTitle;
import cz.larkyy.aquaticcratestesting.animation.task.ConfiguredTask;
import cz.larkyy.aquaticcratestesting.animation.task.PreOpenTitle;
import cz.larkyy.aquaticcratestesting.animation.task.Task;
import cz.larkyy.aquaticcratestesting.animation.task.TaskArgument;
import cz.larkyy.aquaticcratestesting.animation.task.Tasks;
import cz.larkyy.aquaticcratestesting.config.Config;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.inventories.PreviewGUI;
import cz.larkyy.aquaticcratestesting.crate.inventories.RerollGUI;
import cz.larkyy.aquaticcratestesting.crate.reroll.RerollManager;
import cz.larkyy.aquaticcratestesting.crate.reward.ConfiguredRewardAction;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.crate.reward.RewardActions;
import cz.larkyy.aquaticcratestesting.shaded.itemlibrary.CustomItem;
import cz.larkyy.aquaticcratestesting.shaded.itemlibrary.UnknownCustomItemException;
import cz.larkyy.aquaticcratestesting.shaded.menulib.Menu;
import cz.larkyy.aquaticcratestesting.shaded.menulib.MenuItem;
import cz.larkyy.aquaticcratestesting.utils.colors.Colors;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.plugin.java.JavaPlugin;

public class CrateConfig
extends Config {
    private final String identifier;

    public CrateConfig(JavaPlugin javaPlugin, File file) {
        super(javaPlugin, file);
        this.identifier = file.getName().substring(0, file.getName().length() - 4);
    }

    public Crate loadCrate() {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        AtomicReference<Object> atomicReference2 = new AtomicReference<Object>(null);
        AtomicReference<Object> atomicReference3 = new AtomicReference<Object>(null);
        AtomicReference<Object> atomicReference4 = new AtomicReference<Object>(null);
        CustomItem customItem = this.loadKey();
        if (customItem == null) {
            Bukkit.getConsoleSender().sendMessage("\u00a7cCrate could not be loaded, because the Key item is null!");
            return null;
        }
        Crate crate = new Crate(this.identifier, Colors.format(this.getConfiguration().getString("display-name", this.identifier)), customItem, this.getConfiguration().getString("model"), this.loadRewards(), this.getConfiguration().getBoolean("key.requires-crate-to-open", true), atomicReference, atomicReference2, atomicReference3, atomicReference4, this.loadHologram("hologram"), this.getConfiguration().getDouble("hologram-y-offset", 0.0), this.getConfiguration().getString("open-permission"), this.getConfiguration().getBoolean("instant-open-while-sneaking", true));
        this.loadPreviewGUI(crate, atomicReference);
        this.loadRerollGUI(crate, atomicReference2);
        this.loadRerollManager(crate, atomicReference3);
        this.loadAnimationManager(crate, atomicReference4);
        return crate;
    }

    private CustomItem loadKey() {
        return this.loadItem("key");
    }

    private CustomItem loadItem(String string) {
        try {
            return CustomItem.loadFromYaml(this.getConfiguration(), string);
        }
        catch (UnknownCustomItemException unknownCustomItemException) {
            Bukkit.getConsoleSender().sendMessage("\u00a7cItem \u00a7l" + string + "\u00a7c could not be loaded! Please, check your configuration!");
            return null;
        }
    }

    private List<Reward> loadRewards() {
        ArrayList<Reward> arrayList = new ArrayList<Reward>();
        if (!this.getConfiguration().contains("rewards")) {
            return arrayList;
        }
        this.getConfiguration().getConfigurationSection("rewards").getKeys(false).forEach(string -> {
            Reward reward = this.loadReward((String)string);
            if (reward != null) {
                if (reward.getItem().getItem() == null || reward.getPreviewItem().getItem() == null || reward.getItem().getItem().getItemMeta() == null || reward.getPreviewItem().getItem().getItemMeta() == null) {
                    Bukkit.getConsoleSender().sendMessage("\u00a7cReward \u00a7l" + string + "\u00a7c could not be loaded!");
                } else {
                    arrayList.add(reward);
                }
            }
        });
        return arrayList;
    }

    private Reward loadReward(String string) {
        String string2 = "rewards." + string;
        CustomItem customItem = this.loadItem(string2 + ".item");
        if (customItem == null) {
            Bukkit.getConsoleSender().sendMessage("The reward " + string + " could not be loaded, because the item is null!");
            return null;
        }
        CustomItem customItem2 = this.loadItem(string2 + ".preview-item");
        double d = this.getConfiguration().getDouble(string2 + ".chance");
        String string3 = this.getConfiguration().getString(string2 + ".permission");
        boolean bl = this.getConfiguration().getBoolean(string2 + ".give-item", false);
        return new Reward(string, customItem, customItem2, d, this.loadRewardActions(string2 + ".actions"), string3, bl, this.loadHologram(string2 + ".hologram"), this.getConfiguration().getDouble(string2 + ".hologram-y-offset", 0.0));
    }

    private List<ConfiguredRewardAction> loadRewardActions(String string) {
        ArrayList<ConfiguredRewardAction> arrayList = new ArrayList<ConfiguredRewardAction>();
        block0: for (String string2 : this.getConfiguration().getStringList(string)) {
            for (String string3 : RewardActions.inst().getActionTypes().keySet()) {
                if (!string2.startsWith("[" + string3 + "]")) continue;
                String string4 = string2.substring(string3.length() + 2).trim();
                arrayList.add(new ConfiguredRewardAction(RewardActions.inst().getAction(string3), string4));
                continue block0;
            }
        }
        return arrayList;
    }

    private List<String> loadHologram(String string) {
        if (!this.getConfiguration().contains(string)) {
            return new ArrayList<String>();
        }
        return this.getConfiguration().getStringList(string);
    }

    private void loadPreviewGUI(Crate crate, AtomicReference<PreviewGUI> atomicReference) {
        if (!this.getConfiguration().contains("preview") || !this.getConfiguration().getBoolean("preview.enabled", true)) {
            return;
        }
        Object object = this.getConfiguration().contains("preview.title") ? Colors.format(this.getConfiguration().getString("preview.title")) : crate.getDisplayName() + "\u00a78 Preview";
        Menu.Builder builder = Menu.builder(AquaticCratesTesting.instance()).size(this.getConfiguration().getInt("preview.size", 54)).title((String)object);
        if (this.getConfiguration().contains("preview.items")) {
            for (String string : this.getConfiguration().getConfigurationSection("preview.items").getKeys(false)) {
                MenuItem menuItem = this.loadMenuItem(string, "preview.items." + string);
                if (menuItem == null) continue;
                builder.addItem(menuItem);
            }
        }
        List list = this.getConfiguration().getStringList("preview.reward-lore");
        atomicReference.set(new PreviewGUI(crate, builder, this.getConfiguration().getIntegerList("preview.reward-slots"), list, this.getConfiguration().getBoolean("preview.openable-by-key", false)));
    }

    private void loadRerollGUI(Crate crate, AtomicReference<RerollGUI> atomicReference) {
        if (!(this.getConfiguration().contains("reroll") && this.getConfiguration().getBoolean("reroll.enabled", true) && this.getConfiguration().getString("reroll.type", "Interaction").equalsIgnoreCase("gui"))) {
            return;
        }
        String string = "reroll.gui.";
        Object object = this.getConfiguration().contains(string + "title") ? Colors.format(this.getConfiguration().getString(string + "title")) : crate.getDisplayName() + "\u00a78 Reroll";
        Menu.Builder builder = Menu.builder(AquaticCratesTesting.instance()).size(this.getConfiguration().getInt(string + "size", 27)).title((String)object);
        if (this.getConfiguration().contains(string + "items")) {
            for (String string2 : this.getConfiguration().getConfigurationSection(string + "items").getKeys(false)) {
                MenuItem menuItem = this.loadMenuItem(string2, string + "items." + string2);
                if (menuItem == null) continue;
                builder.addItem(menuItem);
            }
        }
        int n = this.getConfiguration().getInt(string + "reward-slot", 13);
        atomicReference.set(new RerollGUI(builder, n));
    }

    private MenuItem loadMenuItem(String string, String string2) {
        CustomItem customItem = this.loadItem(string2);
        if (customItem == null) {
            Bukkit.getConsoleSender().sendMessage("\u00a7cMenu Item " + string2 + " could not be loaded, because the item is null!");
            return null;
        }
        List<Integer> list = this.getConfiguration().contains(string2 + ".slot") ? Arrays.asList(this.getConfiguration().getInt(string2 + ".slot")) : this.getConfiguration().getIntegerList(string2 + ".slots");
        return MenuItem.builder(string, customItem.getItem()).slots(list).build();
    }

    private void loadRerollManager(Crate crate, AtomicReference<RerollManager> atomicReference) {
        if (!this.getConfiguration().contains("reroll") || !this.getConfiguration().getBoolean("reroll.enabled", true)) {
            atomicReference.set(new RerollManager(crate, new HashMap<String, Integer>(), RerollManager.Type.INTERACTION));
        }
        RerollManager.Type type = RerollManager.Type.valueOf(this.getConfiguration().getString("reroll.type", "interaction").toUpperCase());
        atomicReference.set(new RerollManager(crate, this.loadRerollGroups(), type));
    }

    private Map<String, Integer> loadRerollGroups() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (this.getConfiguration().contains("reroll.limits")) {
            this.getConfiguration().getConfigurationSection("reroll.limits").getKeys(false).forEach(string -> {
                int n = this.getConfiguration().getInt("reroll.limits." + string);
                hashMap.put((String)string, n);
            });
        }
        return hashMap;
    }

    private void loadAnimationManager(Crate crate, AtomicReference<AnimationManager> atomicReference) {
        AnimationManager.Type type = AnimationManager.Type.valueOf(this.getConfiguration().getString("animation.type", "INSTANT").toUpperCase());
        atomicReference.set(new AnimationManager(crate, type, this.loadTasks(), this.getConfiguration().getInt("animation.length", 0), this.loadAnimationTitle("animation.title"), this.loadAnimationTitle("reroll.title"), this.loadLocation("animation.model-location"), this.loadLocation("animation.camera-location"), this.getConfiguration().getBoolean("animation.skippable", false), this.getConfiguration().getBoolean("animation.use-pumpkin-helmet", false), this.loadAnimationEmote(), this.getConfiguration().getInt("animation.pre-open.length", 0), this.loadPreOpenTitle()));
    }

    private PreOpenTitle loadPreOpenTitle() {
        if (!this.getConfiguration().contains("animation.pre-open.title")) {
            return null;
        }
        String string = "animation.pre-open.title";
        String string2 = this.getConfiguration().getString(string + ".title", "");
        String string3 = this.getConfiguration().getString(string + ".subtitle", "");
        int n = this.getConfiguration().getInt(string + ".in", 0);
        int n2 = this.getConfiguration().getInt(string + ".stay", 10);
        int n3 = this.getConfiguration().getInt(string + ".out", 0);
        return new PreOpenTitle(n, n3, n2, string2, string3);
    }

    private AnimationEmote loadAnimationEmote() {
        String string = "animation.player-model";
        if (!this.getConfiguration().contains(string)) {
            return new AnimationEmote(null, null);
        }
        String string2 = this.getConfiguration().getString(string + ".emote", null);
        Location location = this.loadLocation(string);
        return new AnimationEmote(location, string2);
    }

    private AnimationTitle loadAnimationTitle(String string) {
        if (!this.getConfiguration().contains(string)) {
            return new AnimationTitle(new ArrayList<String>(), BarColor.WHITE, BarStyle.SOLID);
        }
        List list = this.getConfiguration().getStringList(string + ".lines");
        BarColor barColor = BarColor.valueOf((String)this.getConfiguration().getString(string + ".color").toUpperCase());
        BarStyle barStyle = BarStyle.valueOf((String)this.getConfiguration().getString(string + ".style").toUpperCase());
        return new AnimationTitle(list, barColor, barStyle);
    }

    private Location loadLocation(String string) {
        if (!this.getConfiguration().contains(string)) {
            return null;
        }
        World world = Bukkit.getWorld((String)this.getConfiguration().getString(string + ".world"));
        if (world == null) {
            return null;
        }
        double d = this.getConfiguration().getDouble(string + ".x");
        double d2 = this.getConfiguration().getDouble(string + ".y");
        double d3 = this.getConfiguration().getDouble(string + ".z");
        float f = Float.parseFloat(this.getConfiguration().getString(string + ".yaw", "0"));
        float f2 = Float.parseFloat(this.getConfiguration().getString(string + ".pitch", "0"));
        return new Location(world, d, d2, d3, f, f2);
    }

    private List<ConfiguredTask> loadTasks() {
        ArrayList<ConfiguredTask> arrayList = new ArrayList<ConfiguredTask>();
        if (!this.getConfiguration().contains("animation.actions")) {
            return arrayList;
        }
        this.getConfiguration().getConfigurationSection("animation.actions").getKeys(false).forEach(string -> {
            String string2 = this.getConfiguration().getString("animation.actions." + string + ".type").toLowerCase();
            Task task = Tasks.inst().getTask(string2);
            if (task != null) {
                arrayList.add(new ConfiguredTask(task, this.loadArguments("animation.actions." + string, task.getArgs())));
            }
        });
        return arrayList;
    }

    private Map<String, Object> loadArguments(String string, List<TaskArgument> list) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (TaskArgument taskArgument : list) {
            if (this.getConfiguration().getConfigurationSection(string).getKeys(false).contains(taskArgument.getId())) {
                hashMap.put(taskArgument.getId(), this.getConfiguration().get(string + "." + taskArgument.getId()));
                continue;
            }
            if (taskArgument.isRequired()) {
                Bukkit.getConsoleSender().sendMessage(Colors.format("&cARGUMENT &4" + taskArgument.getId() + " &cIS MISSING, PLEASE UPDATE YOUR CONFIGURATION!"));
            }
            hashMap.put(taskArgument.getId(), taskArgument.getDefaultValue());
        }
        return hashMap;
    }
}

