/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.animation.AnimationManager;
import cz.larkyy.aquaticcratestesting.api.AquaticCratesAPI;
import cz.larkyy.aquaticcratestesting.api.events.ClaimRewardEvent;
import cz.larkyy.aquaticcratestesting.api.events.CrateOpenEvent;
import cz.larkyy.aquaticcratestesting.crate.Key;
import cz.larkyy.aquaticcratestesting.crate.PlacedCrate;
import cz.larkyy.aquaticcratestesting.crate.inventories.PreviewGUI;
import cz.larkyy.aquaticcratestesting.crate.inventories.RerollGUI;
import cz.larkyy.aquaticcratestesting.crate.reroll.RerollManager;
import cz.larkyy.aquaticcratestesting.crate.reroll.impl.MenuReroll;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.messages.Messages;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import cz.larkyy.aquaticcratestesting.shaded.itemlibrary.CustomItem;
import cz.larkyy.aquaticcratestesting.utils.RewardUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Crate {
    private static final NamespacedKey KEY = new NamespacedKey((Plugin)AquaticCratesTesting.instance(), "CrateIdentifier");
    private final String identifier;
    private final String displayName;
    private final Key key;
    private final String model;
    private final List<Reward> rewards;
    private final AtomicReference<PreviewGUI> previewGUI;
    private final AtomicReference<RerollGUI> rerollGUI;
    private final AtomicReference<RerollManager> rerollManager;
    private final AtomicReference<AnimationManager> animationManager;
    private final List<String> hologram;
    private final double hologramYOffset;
    private final String permission;
    private final boolean instantWhileSneaking;

    public Crate(String string, String string2, CustomItem customItem, String string3, List<Reward> list, boolean bl, AtomicReference<PreviewGUI> atomicReference, AtomicReference<RerollGUI> atomicReference2, AtomicReference<RerollManager> atomicReference3, AtomicReference<AnimationManager> atomicReference4, List<String> list2, double d, String string4, boolean bl2) {
        this.identifier = string;
        this.displayName = string2;
        this.key = new Key(customItem, this, bl);
        this.model = string3;
        this.rewards = list;
        this.previewGUI = atomicReference;
        this.rerollGUI = atomicReference2;
        this.rerollManager = atomicReference3;
        this.animationManager = atomicReference4;
        this.hologram = list2;
        this.hologramYOffset = d;
        this.permission = string4;
        this.instantWhileSneaking = bl2;
    }

    public void openPreview(Player player, PlacedCrate placedCrate) {
        if (AquaticCratesTesting.getCrateHandler().isInAnimation(player)) {
            return;
        }
        PreviewGUI previewGUI = this.previewGUI.get();
        if (previewGUI == null) {
            return;
        }
        if (placedCrate == null && !previewGUI.isOpenableByKey()) {
            return;
        }
        previewGUI.open(player, 0, placedCrate);
    }

    public void openRerollGUI(MenuReroll menuReroll) {
        RerollGUI rerollGUI = this.rerollGUI.get();
        if (rerollGUI == null) {
            return;
        }
        rerollGUI.open(menuReroll);
    }

    public PreviewGUI getPreviewGUI() {
        return this.previewGUI.get();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Key getKey() {
        return this.key;
    }

    public void giveKey(Player player, int n, boolean bl) {
        if (bl) {
            CratePlayer cratePlayer = CratePlayer.get(player);
            cratePlayer.addKeys(this.identifier, n);
        } else {
            this.key.give(Collections.singletonList(player), n);
        }
    }

    public void giveCrate(Player player) {
        ItemStack itemStack = new ItemStack(Material.CHEST);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName("\u00a7fCrate: " + this.identifier);
        itemMeta.getPersistentDataContainer().set(KEY, PersistentDataType.STRING, (Object)this.identifier);
        itemStack.setItemMeta(itemMeta);
        player.getInventory().addItem(new ItemStack[]{itemStack});
    }

    public void giveKeyAll(int n, boolean bl) {
        if (bl) {
            AquaticCratesAPI.getPlayerHandler().loadPlayers(() -> {});
            AquaticCratesAPI.getPlayerHandler().getPlayers().forEach(cratePlayer -> cratePlayer.addKeys(this.identifier, n));
        } else {
            this.key.give(new ArrayList<Player>(Bukkit.getOnlinePlayers()), n);
        }
    }

    public boolean open(CratePlayer cratePlayer, PlacedCrate placedCrate, boolean bl) {
        return this.open(cratePlayer, placedCrate, bl, true);
    }

    public boolean open(CratePlayer cratePlayer, PlacedCrate placedCrate, boolean bl, boolean bl2) {
        if (AquaticCratesAPI.getCrateHandler().isInAnimation(cratePlayer.getPlayer())) {
            return false;
        }
        if (this.permission != null && !cratePlayer.getPlayer().hasPermission(this.permission)) {
            Messages.CRATE_NO_PERMISSION.send((CommandSender)cratePlayer.getPlayer());
            return false;
        }
        if (!this.animationManager.get().canBeOpened(cratePlayer.getPlayer())) {
            return false;
        }
        if (bl2 && !cratePlayer.takeKey(this.key)) {
            Messages.DO_NOT_HAVE_KEY.send((CommandSender)cratePlayer.getPlayer());
            return false;
        }
        CrateOpenEvent crateOpenEvent = new CrateOpenEvent(cratePlayer.getPlayer(), this);
        AtomicReference<Reward> atomicReference = new AtomicReference<Reward>(this.getRandomReward(cratePlayer.getPlayer()));
        if (atomicReference.get() == null) {
            cratePlayer.getPlayer().sendMessage("No available reward has been found! Contact an Admin!");
            Bukkit.getPluginManager().callEvent((Event)crateOpenEvent);
            return true;
        }
        if (bl && this.instantWhileSneaking) {
            ClaimRewardEvent claimRewardEvent = new ClaimRewardEvent(cratePlayer.getPlayer(), atomicReference.get(), this);
            Bukkit.getServer().getPluginManager().callEvent((Event)claimRewardEvent);
            atomicReference.get().give(cratePlayer.getPlayer());
        } else {
            this.animationManager.get().open(cratePlayer.getPlayer(), atomicReference, placedCrate, animation -> {
                if (this.rerollManager.get().setRerolling(cratePlayer.getPlayer(), atomicReference, reward -> {
                    this.animationManager.get().hideTitle(cratePlayer.getPlayer());
                    ClaimRewardEvent claimRewardEvent = new ClaimRewardEvent(cratePlayer.getPlayer(), (Reward)reward, this);
                    Bukkit.getServer().getPluginManager().callEvent((Event)claimRewardEvent);
                    reward.give(cratePlayer.getPlayer());
                    this.animationManager.get().removeAnimation(cratePlayer.getPlayer());
                    animation.end();
                }, reward -> {
                    this.animationManager.get().hideTitle(cratePlayer.getPlayer());
                    atomicReference.set(this.getRandomReward(cratePlayer.getPlayer()));
                    animation.start();
                })) {
                    this.animationManager.get().showTitle(this.animationManager.get().getRerollingTitle(), cratePlayer.getPlayer());
                }
            });
        }
        Bukkit.getPluginManager().callEvent((Event)crateOpenEvent);
        return true;
    }

    public Reward getRandomReward(Player player) {
        return RewardUtils.getRandomReward(player, this.rewards, null);
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public PlacedCrate spawn(Location location) {
        return AquaticCratesAPI.getCrateHandler().spawnCrate(location, this);
    }

    public String getModel() {
        return this.model;
    }

    public List<Reward> getPossibleRewards(Player player) {
        return RewardUtils.getPossibleRewards(player, this.rewards);
    }

    public RerollManager getRerollManager() {
        return this.rerollManager.get();
    }

    public static Crate get(String string) {
        return AquaticCratesAPI.getCrate(string);
    }

    public static Crate get(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        String string = (String)itemMeta.getPersistentDataContainer().get(KEY, PersistentDataType.STRING);
        if (string == null) {
            return null;
        }
        return Crate.get(string);
    }

    public AtomicReference<AnimationManager> getAnimationManager() {
        return this.animationManager;
    }

    public List<String> getHologram() {
        return this.hologram;
    }

    public double getHologramYOffset() {
        return this.hologramYOffset;
    }
}

