/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.config.Config;
import cz.larkyy.aquaticcratestesting.config.CrateConfig;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.PlacedCrate;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CrateHandler {
    private final Map<String, Crate> crates = new HashMap<String, Crate>();
    private final Map<Location, PlacedCrate> locations = new HashMap<Location, PlacedCrate>();
    private static final Config crateData = new Config((JavaPlugin)AquaticCratesTesting.instance(), "locations.yml");

    public void removePlacedCrate(Location location) {
        PlacedCrate placedCrate = this.locations.remove(location);
        if (placedCrate == null) {
            return;
        }
        placedCrate.destroy();
        this.saveCrates();
    }

    public Crate getCrate(String string) {
        return this.crates.get(string);
    }

    public PlacedCrate spawnCrate(Location location, Crate crate) {
        PlacedCrate placedCrate = new PlacedCrate(crate, location, crate.getModel());
        Location location2 = location.clone().getBlock().getLocation();
        location2.setYaw(0.0f);
        this.locations.put(location2, placedCrate);
        return placedCrate;
    }

    public PlacedCrate getPlacedCrate(Location location) {
        return this.locations.get(location);
    }

    public void load() {
        this.loadCrates();
    }

    private void loadCrates() {
        Crate crate;
        crateData.load();
        File file = new File(AquaticCratesTesting.instance().getDataFolder(), "crates/");
        file.mkdirs();
        for (File object : file.listFiles()) {
            crate = new CrateConfig((JavaPlugin)AquaticCratesTesting.instance(), object).loadCrate();
            if (crate == null) continue;
            this.crates.put(crate.getIdentifier(), crate);
        }
        if (!crateData.getConfiguration().contains("crates")) {
            return;
        }
        for (String string : crateData.getConfiguration().getStringList("crates")) {
            String[] stringArray = string.split("\\|");
            Crate crate2 = Crate.get(stringArray[0]);
            if (crate2 == null || (crate = Bukkit.getWorld((String)stringArray[1])) == null) continue;
            double d = Double.parseDouble(stringArray[2]);
            double d2 = Double.parseDouble(stringArray[3]);
            double d3 = Double.parseDouble(stringArray[4]);
            float f = Float.parseFloat(stringArray[5]);
            this.spawnCrate(new Location((World)crate, d, d2, d3, f, 0.0f), crate2);
        }
    }

    public void unloadCrates() {
        for (PlacedCrate placedCrate : this.locations.values()) {
            placedCrate.destroy();
        }
    }

    public void saveCrates() {
        new BukkitRunnable(){

            public void run() {
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                for (Map.Entry<Location, PlacedCrate> entry : CrateHandler.this.locations.entrySet()) {
                    PlacedCrate placedCrate = entry.getValue();
                    Location location = placedCrate.getLocation();
                    arrayList.add((CallSite)((Object)(placedCrate.getCrate().getIdentifier() + "|" + location.getWorld().getName() + "|" + location.getX() + "|" + location.getY() + "|" + location.getZ() + "|" + location.getYaw())));
                }
                crateData.getConfiguration().set("crates", arrayList);
                crateData.save();
            }
        }.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
    }

    public boolean isInAnimation(Player player) {
        for (Crate crate : this.crates.values()) {
            if (!crate.getAnimationManager().get().isInAnimation(player)) continue;
            return true;
        }
        return false;
    }

    public boolean skipAnimation(Player player) {
        for (Crate crate : this.crates.values()) {
            if (!crate.getAnimationManager().get().skipAnimation(player)) continue;
            return true;
        }
        return false;
    }

    public boolean forceSkipAnimation(Player player) {
        for (Crate crate : this.crates.values()) {
            if (!crate.getAnimationManager().get().forceSkipAnimation(player)) continue;
            return true;
        }
        return false;
    }

    public Map<Location, PlacedCrate> getLocations() {
        return this.locations;
    }

    public Map<String, Crate> getCrates() {
        return this.crates;
    }
}

