/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.loader;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.loader.Loader;
import cz.larkyy.aquaticcratestesting.loader.impl.AquaticEngineLoader;
import cz.larkyy.aquaticcratestesting.loader.impl.ItemsAdderLoader;
import cz.larkyy.aquaticcratestesting.loader.impl.ModelEngineLoader;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class LoaderManager {
    private final List<Loader> loaders = new ArrayList<Loader>();
    private final Runnable runnable;

    public LoaderManager(Runnable runnable) {
        this.runnable = runnable;
        if (this.getPlugin("AquaticModelEngine") != null) {
            try {
                Class.forName("xyz.larkyy.aquaticmodelengine.api.event.ModelLoadEvent");
                Class.forName("xyz.larkyy.aquaticmodelengine.api.event.State");
                AquaticEngineLoader aquaticEngineLoader = new AquaticEngineLoader(this::tryLoad);
                this.loaders.add(aquaticEngineLoader);
                if (AquaticCratesTesting.loaded) {
                    aquaticEngineLoader.load();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.getPlugin("ItemsAdder") != null) {
            this.loaders.add(new ItemsAdderLoader(this::tryLoad));
            if (AquaticCratesTesting.loaded) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"iareload");
            }
        }
        if (this.getPlugin("ModelEngine") != null) {
            try {
                Class.forName("com.ticxo.modelengine.api.events.ModelRegistrationEvent");
                this.loaders.add(new ModelEngineLoader(this::tryLoad));
                if (AquaticCratesTesting.loaded) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"meg reload");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Bukkit.getConsoleSender().sendMessage("[AquaticCrates] Using an old version of ModelEngine! Use at least v3.0.0!");
            }
        }
    }

    public void tryLoad() {
        for (Loader loader : this.loaders) {
            if (loader.isLoaded()) continue;
            return;
        }
        this.load();
    }

    private void load() {
        this.runnable.run();
    }

    private Plugin getPlugin(String string) {
        return AquaticCratesTesting.instance().getServer().getPluginManager().getPlugin(string);
    }
}

