/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.shaded.menulib;

import cz.larkyy.aquaticcratestesting.shaded.menulib.MenuItem;
import cz.larkyy.aquaticcratestesting.shaded.menulib.MenuListener;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Menu
implements InventoryHolder {
    private final JavaPlugin plugin;
    private final NamespacedKey key;
    private final Map<String, MenuItem> menuItems;
    private final String title;
    private final Inventory inventory;

    public Menu(JavaPlugin javaPlugin, NamespacedKey namespacedKey, Map<String, MenuItem> map, String string, int n) {
        this.plugin = javaPlugin;
        this.key = namespacedKey;
        this.menuItems = map;
        this.title = string;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)n, (String)string);
        this.loadItems();
    }

    public void loadItems() {
        for (MenuItem menuItem : this.menuItems.values()) {
            menuItem.getSlots().forEach(n -> this.inventory.setItem(n.intValue(), menuItem.getItemStack()));
        }
    }

    public MenuItem getItem(String string) {
        return this.menuItems.get(string);
    }

    public Map<String, MenuItem> getItems() {
        return this.menuItems;
    }

    public void addItem(MenuItem menuItem) {
        this.menuItems.put(menuItem.getId(), menuItem);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void activate(InventoryClickEvent inventoryClickEvent) {
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        if (!itemMeta.getPersistentDataContainer().has(this.key, PersistentDataType.STRING)) {
            return;
        }
        String string = (String)itemMeta.getPersistentDataContainer().get(this.key, PersistentDataType.STRING);
        MenuItem menuItem = this.menuItems.get(string);
        if (menuItem == null) {
            return;
        }
        menuItem.activate(inventoryClickEvent);
    }

    public Menu clone() {
        return new Menu(this.plugin, this.key, this.menuItems, this.title, this.inventory.getSize());
    }

    public static Builder builder(JavaPlugin javaPlugin) {
        return new Builder(javaPlugin);
    }

    public static class Builder {
        private final JavaPlugin plugin;
        private final NamespacedKey key;
        private Map<String, MenuItem> menuItems;
        private String title;
        private int size;

        public Builder(JavaPlugin javaPlugin) {
            this.plugin = javaPlugin;
            this.key = new NamespacedKey((Plugin)javaPlugin, "MenuLib_Key");
            this.menuItems = new HashMap<String, MenuItem>();
            this.size = 9;
        }

        public Builder addItem(MenuItem menuItem) {
            ItemStack itemStack = menuItem.getItemStack();
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)menuItem.getId());
            itemStack.setItemMeta(itemMeta);
            this.menuItems.put(menuItem.getId(), menuItem);
            return this;
        }

        public Builder title(String string) {
            this.title = string;
            return this;
        }

        public Builder size(int n) {
            this.size = n;
            return this;
        }

        public Menu build() {
            new MenuListener(this.plugin);
            return new Menu(this.plugin, this.key, this.menuItems, this.title, this.size);
        }

        public Builder clone() {
            Builder builder = new Builder(this.plugin);
            builder.menuItems = new HashMap<String, MenuItem>();
            this.menuItems.forEach((string, menuItem) -> builder.menuItems.put((String)string, menuItem.clone()));
            builder.title = this.title;
            builder.size = this.size;
            return builder;
        }
    }
}

