/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.shaded.menulib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MenuItem {
    private final String id;
    private final ItemStack itemStack;
    private List<Consumer<InventoryClickEvent>> actions;
    private final List<Integer> slots;

    public MenuItem(String string, ItemStack itemStack, List<Consumer<InventoryClickEvent>> list, List<Integer> list2) {
        this.id = string;
        this.itemStack = itemStack;
        this.actions = list;
        this.slots = list2;
    }

    public MenuItem(String string, ItemStack itemStack, Consumer<InventoryClickEvent> consumer, List<Integer> list) {
        this.id = string;
        this.itemStack = itemStack;
        this.actions = new ArrayList<Consumer>(Arrays.asList(consumer));
        this.slots = list;
    }

    public String getId() {
        return this.id;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public void addAction(Consumer<InventoryClickEvent> consumer) {
        this.actions.add(consumer);
    }

    public void activate(InventoryClickEvent inventoryClickEvent) {
        for (Consumer<InventoryClickEvent> consumer : this.actions) {
            consumer.accept(inventoryClickEvent);
        }
    }

    public MenuItem clone() {
        return new MenuItem(this.id, this.itemStack.clone(), new ArrayList<Consumer<InventoryClickEvent>>(this.actions), new ArrayList<Integer>(this.slots));
    }

    public static Builder builder(String string, ItemStack itemStack) {
        return new Builder(string, itemStack);
    }

    public static class Builder {
        private final String id;
        private final ItemStack is;
        private List<Integer> slots;
        private Consumer<InventoryClickEvent> action;

        public Builder(String string, ItemStack itemStack) {
            this.id = string;
            this.is = itemStack;
            this.slots = new ArrayList<Integer>();
            this.action = inventoryClickEvent -> {};
        }

        public Builder slots(List<Integer> list) {
            this.slots = list;
            return this;
        }

        public Builder action(Consumer<InventoryClickEvent> consumer) {
            this.action = consumer;
            return this;
        }

        public MenuItem build() {
            return new MenuItem(this.id, this.is, this.action, this.slots);
        }
    }
}

