/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.codahale.metrics.health.HealthCheckRegistry;
import com.zaxxer.hikari.HikariConfigMXBean;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.util.PropertyElf;
import com.zaxxer.hikari.util.UtilityElf;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariConfig
implements HikariConfigMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariConfig.class);
    private static final char[] ID_CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long VALIDATION_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long SOFT_TIMEOUT_FLOOR = Long.getLong("com.zaxxer.hikari.timeoutMs.floor", 250L);
    private static final long IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static final long DEFAULT_KEEPALIVE_TIME = 0L;
    private static final int DEFAULT_POOL_SIZE = 10;
    private static boolean unitTest = false;
    private volatile String catalog;
    private volatile long connectionTimeout;
    private volatile long validationTimeout;
    private volatile long idleTimeout;
    private volatile long leakDetectionThreshold;
    private volatile long maxLifetime;
    private volatile int maxPoolSize = -1;
    private volatile int minIdle = -1;
    private volatile String username;
    private volatile String password;
    private long initializationFailTimeout = 1L;
    private String connectionInitSql;
    private String connectionTestQuery;
    private String dataSourceClassName;
    private String dataSourceJndiName;
    private String driverClassName;
    private String exceptionOverrideClassName;
    private String jdbcUrl;
    private String poolName;
    private String schema;
    private String transactionIsolationName;
    private boolean isAutoCommit = true;
    private boolean isReadOnly;
    private boolean isIsolateInternalQueries;
    private boolean isRegisterMbeans;
    private boolean isAllowPoolSuspension;
    private DataSource dataSource;
    private Properties dataSourceProperties = new Properties();
    private ThreadFactory threadFactory;
    private ScheduledExecutorService scheduledExecutor;
    private MetricsTrackerFactory metricsTrackerFactory;
    private Object metricRegistry;
    private Object healthCheckRegistry;
    private Properties healthCheckProperties = new Properties();
    private long keepaliveTime = 0L;
    private volatile boolean sealed;

    public HikariConfig() {
        this.maxLifetime = MAX_LIFETIME;
        this.connectionTimeout = CONNECTION_TIMEOUT;
        this.validationTimeout = VALIDATION_TIMEOUT;
        this.idleTimeout = IDLE_TIMEOUT;
        String string = System.getProperty("hikaricp.configurationFile");
        if (string != null) {
            this.loadProperties(string);
        }
    }

    public HikariConfig(Properties properties) {
        this();
        PropertyElf.setTargetFromProperties(this, properties);
    }

    public HikariConfig(String string) {
        this();
        this.loadProperties(string);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String string) {
        this.catalog = string;
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long l) {
        if (l == 0L) {
            this.connectionTimeout = Integer.MAX_VALUE;
        } else {
            if (l < SOFT_TIMEOUT_FLOOR) {
                throw new IllegalArgumentException("connectionTimeout cannot be less than " + SOFT_TIMEOUT_FLOOR + "ms");
            }
            this.connectionTimeout = l;
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("idleTimeout cannot be negative");
        }
        this.idleTimeout = l;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    @Override
    public void setLeakDetectionThreshold(long l) {
        this.leakDetectionThreshold = l;
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public void setMaxLifetime(long l) {
        this.maxLifetime = l;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("maxPoolSize cannot be less than 1");
        }
        this.maxPoolSize = n;
    }

    @Override
    public int getMinimumIdle() {
        return this.minIdle;
    }

    @Override
    public void setMinimumIdle(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("minimumIdle cannot be negative");
        }
        this.minIdle = n;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String string) {
        this.username = string;
    }

    @Override
    public long getValidationTimeout() {
        return this.validationTimeout;
    }

    @Override
    public void setValidationTimeout(long l) {
        if (l < SOFT_TIMEOUT_FLOOR) {
            throw new IllegalArgumentException("validationTimeout cannot be less than " + SOFT_TIMEOUT_FLOOR + "ms");
        }
        this.validationTimeout = l;
    }

    public String getConnectionTestQuery() {
        return this.connectionTestQuery;
    }

    public void setConnectionTestQuery(String string) {
        this.checkIfSealed();
        this.connectionTestQuery = string;
    }

    public String getConnectionInitSql() {
        return this.connectionInitSql;
    }

    public void setConnectionInitSql(String string) {
        this.checkIfSealed();
        this.connectionInitSql = string;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.checkIfSealed();
        this.dataSource = dataSource;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public void setDataSourceClassName(String string) {
        this.checkIfSealed();
        this.dataSourceClassName = string;
    }

    public void addDataSourceProperty(String string, Object object) {
        this.checkIfSealed();
        this.dataSourceProperties.put(string, object);
    }

    public String getDataSourceJNDI() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJNDI(String string) {
        this.checkIfSealed();
        this.dataSourceJndiName = string;
    }

    public Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public void setDataSourceProperties(Properties properties) {
        this.checkIfSealed();
        this.dataSourceProperties.putAll((Map<?, ?>)properties);
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string) {
        this.checkIfSealed();
        Class<?> clazz = this.attemptFromContextLoader(string);
        try {
            if (clazz == null) {
                clazz = this.getClass().getClassLoader().loadClass(string);
                LOGGER.debug("Driver class {} found in the HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error("Failed to load driver class {} from HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
        }
        if (clazz == null) {
            throw new RuntimeException("Failed to load driver class " + string + " in either of HikariConfig class loader or Thread context classloader");
        }
        try {
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.driverClassName = string;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate class " + string, exception);
        }
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String string) {
        this.checkIfSealed();
        this.jdbcUrl = string;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean bl) {
        this.checkIfSealed();
        this.isAutoCommit = bl;
    }

    public boolean isAllowPoolSuspension() {
        return this.isAllowPoolSuspension;
    }

    public void setAllowPoolSuspension(boolean bl) {
        this.checkIfSealed();
        this.isAllowPoolSuspension = bl;
    }

    public long getInitializationFailTimeout() {
        return this.initializationFailTimeout;
    }

    public void setInitializationFailTimeout(long l) {
        this.checkIfSealed();
        this.initializationFailTimeout = l;
    }

    public boolean isIsolateInternalQueries() {
        return this.isIsolateInternalQueries;
    }

    public void setIsolateInternalQueries(boolean bl) {
        this.checkIfSealed();
        this.isIsolateInternalQueries = bl;
    }

    public MetricsTrackerFactory getMetricsTrackerFactory() {
        return this.metricsTrackerFactory;
    }

    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        if (this.metricRegistry != null) {
            throw new IllegalStateException("cannot use setMetricsTrackerFactory() and setMetricRegistry() together");
        }
        this.metricsTrackerFactory = metricsTrackerFactory;
    }

    public Object getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(Object object) {
        if (this.metricsTrackerFactory != null) {
            throw new IllegalStateException("cannot use setMetricRegistry() and setMetricsTrackerFactory() together");
        }
        if (object != null && !UtilityElf.safeIsAssignableFrom(object = this.getObjectOrPerformJndiLookup(object), "com.codahale.metrics.MetricRegistry") && !UtilityElf.safeIsAssignableFrom(object, "io.micrometer.core.instrument.MeterRegistry")) {
            throw new IllegalArgumentException("Class must be instance of com.codahale.metrics.MetricRegistry or io.micrometer.core.instrument.MeterRegistry");
        }
        this.metricRegistry = object;
    }

    public Object getHealthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    public void setHealthCheckRegistry(Object object) {
        this.checkIfSealed();
        if (object != null && !((object = this.getObjectOrPerformJndiLookup(object)) instanceof HealthCheckRegistry)) {
            throw new IllegalArgumentException("Class must be an instance of com.codahale.metrics.health.HealthCheckRegistry");
        }
        this.healthCheckRegistry = object;
    }

    public Properties getHealthCheckProperties() {
        return this.healthCheckProperties;
    }

    public void setHealthCheckProperties(Properties properties) {
        this.checkIfSealed();
        this.healthCheckProperties.putAll((Map<?, ?>)properties);
    }

    public void addHealthCheckProperty(String string, String string2) {
        this.checkIfSealed();
        this.healthCheckProperties.setProperty(string, string2);
    }

    public long getKeepaliveTime() {
        return this.keepaliveTime;
    }

    public void setKeepaliveTime(long l) {
        this.keepaliveTime = l;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.checkIfSealed();
        this.isReadOnly = bl;
    }

    public boolean isRegisterMbeans() {
        return this.isRegisterMbeans;
    }

    public void setRegisterMbeans(boolean bl) {
        this.checkIfSealed();
        this.isRegisterMbeans = bl;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String string) {
        this.checkIfSealed();
        this.poolName = string;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.checkIfSealed();
        this.scheduledExecutor = scheduledExecutorService;
    }

    public String getTransactionIsolation() {
        return this.transactionIsolationName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.checkIfSealed();
        this.schema = string;
    }

    public String getExceptionOverrideClassName() {
        return this.exceptionOverrideClassName;
    }

    public void setExceptionOverrideClassName(String string) {
        this.checkIfSealed();
        Class<?> clazz = this.attemptFromContextLoader(string);
        try {
            if (clazz == null) {
                clazz = this.getClass().getClassLoader().loadClass(string);
                LOGGER.debug("SQLExceptionOverride class {} found in the HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error("Failed to load SQLExceptionOverride class {} from HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
        }
        if (clazz == null) {
            throw new RuntimeException("Failed to load SQLExceptionOverride class " + string + " in either of HikariConfig class loader or Thread context classloader");
        }
        try {
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.exceptionOverrideClassName = string;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate class " + string, exception);
        }
    }

    public void setTransactionIsolation(String string) {
        this.checkIfSealed();
        this.transactionIsolationName = string;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.checkIfSealed();
        this.threadFactory = threadFactory;
    }

    void seal() {
        this.sealed = true;
    }

    public void copyStateTo(HikariConfig hikariConfig) {
        for (Field field : HikariConfig.class.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(hikariConfig, field.get(this));
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to copy HikariConfig state: " + exception.getMessage(), exception);
            }
        }
        hikariConfig.sealed = false;
    }

    private Class<?> attemptFromContextLoader(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                LOGGER.debug("Driver class {} found in Thread context class loader {}", (Object)string, (Object)classLoader);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.debug("Driver class {} not found in Thread context class loader {}, trying classloader {}", string, classLoader, this.getClass().getClassLoader());
            }
        }
        return null;
    }

    public void validate() {
        if (this.poolName == null) {
            this.poolName = this.generatePoolName();
        } else if (this.isRegisterMbeans && this.poolName.contains(":")) {
            throw new IllegalArgumentException("poolName cannot contain ':' when used with JMX");
        }
        this.catalog = UtilityElf.getNullIfEmpty(this.catalog);
        this.connectionInitSql = UtilityElf.getNullIfEmpty(this.connectionInitSql);
        this.connectionTestQuery = UtilityElf.getNullIfEmpty(this.connectionTestQuery);
        this.transactionIsolationName = UtilityElf.getNullIfEmpty(this.transactionIsolationName);
        this.dataSourceClassName = UtilityElf.getNullIfEmpty(this.dataSourceClassName);
        this.dataSourceJndiName = UtilityElf.getNullIfEmpty(this.dataSourceJndiName);
        this.driverClassName = UtilityElf.getNullIfEmpty(this.driverClassName);
        this.jdbcUrl = UtilityElf.getNullIfEmpty(this.jdbcUrl);
        if (this.dataSource != null) {
            if (this.dataSourceClassName != null) {
                LOGGER.warn("{} - using dataSource and ignoring dataSourceClassName.", (Object)this.poolName);
            }
        } else if (this.dataSourceClassName != null) {
            if (this.driverClassName != null) {
                LOGGER.error("{} - cannot use driverClassName and dataSourceClassName together.", (Object)this.poolName);
                throw new IllegalStateException("cannot use driverClassName and dataSourceClassName together.");
            }
            if (this.jdbcUrl != null) {
                LOGGER.warn("{} - using dataSourceClassName and ignoring jdbcUrl.", (Object)this.poolName);
            }
        } else if (this.jdbcUrl == null && this.dataSourceJndiName == null) {
            if (this.driverClassName != null) {
                LOGGER.error("{} - jdbcUrl is required with driverClassName.", (Object)this.poolName);
                throw new IllegalArgumentException("jdbcUrl is required with driverClassName.");
            }
            LOGGER.error("{} - dataSource or dataSourceClassName or jdbcUrl is required.", (Object)this.poolName);
            throw new IllegalArgumentException("dataSource or dataSourceClassName or jdbcUrl is required.");
        }
        this.validateNumerics();
        if (LOGGER.isDebugEnabled() || unitTest) {
            this.logConfiguration();
        }
    }

    private void validateNumerics() {
        if (this.maxLifetime != 0L && this.maxLifetime < TimeUnit.SECONDS.toMillis(30L)) {
            LOGGER.warn("{} - maxLifetime is less than 30000ms, setting to default {}ms.", (Object)this.poolName, (Object)MAX_LIFETIME);
            this.maxLifetime = MAX_LIFETIME;
        }
        if (this.keepaliveTime != 0L && this.keepaliveTime < TimeUnit.SECONDS.toMillis(30L)) {
            LOGGER.warn("{} - keepaliveTime is less than 30000ms, disabling it.", (Object)this.poolName);
            this.keepaliveTime = 0L;
        }
        if (this.keepaliveTime != 0L && this.maxLifetime != 0L && this.keepaliveTime >= this.maxLifetime) {
            LOGGER.warn("{} - keepaliveTime is greater than or equal to maxLifetime, disabling it.", (Object)this.poolName);
            this.keepaliveTime = 0L;
        }
        if (this.leakDetectionThreshold > 0L && !unitTest && (this.leakDetectionThreshold < TimeUnit.SECONDS.toMillis(2L) || this.leakDetectionThreshold > this.maxLifetime && this.maxLifetime > 0L)) {
            LOGGER.warn("{} - leakDetectionThreshold is less than 2000ms or more than maxLifetime, disabling it.", (Object)this.poolName);
            this.leakDetectionThreshold = 0L;
        }
        if (this.connectionTimeout < SOFT_TIMEOUT_FLOOR) {
            LOGGER.warn("{} - connectionTimeout is less than {}ms, setting to {}ms.", this.poolName, SOFT_TIMEOUT_FLOOR, CONNECTION_TIMEOUT);
            this.connectionTimeout = CONNECTION_TIMEOUT;
        }
        if (this.validationTimeout < SOFT_TIMEOUT_FLOOR) {
            LOGGER.warn("{} - validationTimeout is less than {}ms, setting to {}ms.", this.poolName, SOFT_TIMEOUT_FLOOR, VALIDATION_TIMEOUT);
            this.validationTimeout = VALIDATION_TIMEOUT;
        }
        if (this.maxPoolSize < 1) {
            this.maxPoolSize = 10;
        }
        if (this.minIdle < 0 || this.minIdle > this.maxPoolSize) {
            this.minIdle = this.maxPoolSize;
        }
        if (this.idleTimeout + TimeUnit.SECONDS.toMillis(1L) > this.maxLifetime && this.maxLifetime > 0L && this.minIdle < this.maxPoolSize) {
            LOGGER.warn("{} - idleTimeout is close to or more than maxLifetime, disabling it.", (Object)this.poolName);
            this.idleTimeout = 0L;
        } else if (this.idleTimeout != 0L && this.idleTimeout < TimeUnit.SECONDS.toMillis(10L) && this.minIdle < this.maxPoolSize) {
            LOGGER.warn("{} - idleTimeout is less than 10000ms, setting to default {}ms.", (Object)this.poolName, (Object)IDLE_TIMEOUT);
            this.idleTimeout = IDLE_TIMEOUT;
        } else if (this.idleTimeout != IDLE_TIMEOUT && this.idleTimeout != 0L && this.minIdle == this.maxPoolSize) {
            LOGGER.warn("{} - idleTimeout has been set but has no effect because the pool is operating as a fixed size pool.", (Object)this.poolName);
        }
    }

    private void checkIfSealed() {
        if (this.sealed) {
            throw new IllegalStateException("The configuration of the pool is sealed once started. Use HikariConfigMXBean for runtime changes.");
        }
    }

    private void logConfiguration() {
        LOGGER.debug("{} - configuration:", (Object)this.poolName);
        TreeSet<String> treeSet = new TreeSet<String>(PropertyElf.getPropertyNames(HikariConfig.class));
        for (String string : treeSet) {
            try {
                Object object = PropertyElf.getProperty(string, this);
                if ("dataSourceProperties".equals(string)) {
                    Properties properties = PropertyElf.copyProperties(this.dataSourceProperties);
                    properties.setProperty("password", "<masked>");
                    object = properties;
                }
                if ("initializationFailTimeout".equals(string) && this.initializationFailTimeout == Long.MAX_VALUE) {
                    object = "infinite";
                } else if ("transactionIsolation".equals(string) && this.transactionIsolationName == null) {
                    object = "default";
                } else if (string.matches("scheduledExecutorService|threadFactory") && object == null) {
                    object = "internal";
                } else if (string.contains("jdbcUrl") && object instanceof String) {
                    object = ((String)object).replaceAll("([?&;]password=)[^&#;]*(.*)", "$1<masked>$2");
                } else if (string.contains("password")) {
                    object = "<masked>";
                } else if (object instanceof String) {
                    object = "\"" + object + "\"";
                } else if (object == null) {
                    object = "none";
                }
                LOGGER.debug("{}{}", (Object)(string + "................................................").substring(0, 32), object);
            }
            catch (Exception exception) {}
        }
    }

    private void loadProperties(String string) {
        block9: {
            File file = new File(string);
            try (InputStream inputStream = file.isFile() ? new FileInputStream(file) : this.getClass().getResourceAsStream(string);){
                if (inputStream != null) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    PropertyElf.setTargetFromProperties(this, properties);
                    break block9;
                }
                throw new IllegalArgumentException("Cannot find property file: " + string);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to read property file", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generatePoolName() {
        String string = "HikariPool-";
        try {
            Properties properties = System.getProperties();
            synchronized (properties) {
                String string2 = String.valueOf(Integer.getInteger("com.zaxxer.hikari.pool_number", 0) + 1);
                System.setProperty("com.zaxxer.hikari.pool_number", string2);
                return "HikariPool-" + string2;
            }
        }
        catch (AccessControlException accessControlException) {
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            StringBuilder stringBuilder = new StringBuilder("HikariPool-");
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(ID_CHARACTERS[threadLocalRandom.nextInt(62)]);
            }
            LOGGER.info("assigned random pool name '{}' (security manager prevented access to system properties)", (Object)stringBuilder);
            return stringBuilder.toString();
        }
    }

    private Object getObjectOrPerformJndiLookup(Object object) {
        if (object instanceof String) {
            try {
                InitialContext initialContext = new InitialContext();
                return initialContext.lookup((String)object);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException);
            }
        }
        return object;
    }
}

