/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.animation;

import cz.larkyy.aquaticcratestesting.animation.Animation;
import cz.larkyy.aquaticcratestesting.animation.AnimationTitle;
import cz.larkyy.aquaticcratestesting.animation.impl.CinematicAnimation;
import cz.larkyy.aquaticcratestesting.animation.impl.InstantAnimation;
import cz.larkyy.aquaticcratestesting.animation.impl.PlacedCrateAnimation;
import cz.larkyy.aquaticcratestesting.animation.impl.PlacedCratePersonalisedAnimation;
import cz.larkyy.aquaticcratestesting.animation.task.ConfiguredTask;
import cz.larkyy.aquaticcratestesting.animation.task.PreOpenTitle;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.PlacedCrate;
import cz.larkyy.aquaticcratestesting.crate.reroll.Reroll;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.messages.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AnimationManager {
    private final Crate crate;
    private final Type type;
    private final List<ConfiguredTask> tasks;
    private final int length;
    private final int startDelay;
    private final PreOpenTitle preOpenTitle;
    private final AnimationTitle openingTitle;
    private final AnimationTitle rerollingTitle;
    private final Location modelLocation;
    private final Location cameraLocation;
    private final Map<Player, Animation> animations;
    private final boolean skippable;
    private final boolean setPumpkinHelmet;
    private final Map<Player, List<BossBar>> bossBars;

    public AnimationManager(Crate crate, Type type, List<ConfiguredTask> list, int n, AnimationTitle animationTitle, AnimationTitle animationTitle2, Location location, Location location2, boolean bl, boolean bl2, int n2, PreOpenTitle preOpenTitle) {
        this.crate = crate;
        this.type = type;
        this.tasks = list;
        this.length = n;
        this.animations = new HashMap<Player, Animation>();
        this.openingTitle = animationTitle;
        this.rerollingTitle = animationTitle2;
        this.modelLocation = location;
        this.cameraLocation = location2;
        this.skippable = bl;
        this.setPumpkinHelmet = bl2;
        this.preOpenTitle = preOpenTitle;
        this.startDelay = n2;
        this.bossBars = new HashMap<Player, List<BossBar>>();
    }

    public void open(Player player, AtomicReference<Reward> atomicReference, PlacedCrate placedCrate, Consumer<Animation> consumer) {
        switch (this.type) {
            case INSTANT: {
                new InstantAnimation(this, player, atomicReference, consumer);
                break;
            }
            case PLACEDCRATE: {
                new PlacedCrateAnimation(this, player, atomicReference, consumer, placedCrate);
                break;
            }
            case CINEMATIC: {
                new CinematicAnimation(this, player, atomicReference, consumer);
                break;
            }
            case PLACEDCRATE_PERSONALISED: {
                new PlacedCratePersonalisedAnimation(this, player, atomicReference, consumer, placedCrate);
            }
        }
    }

    public void playTask(int n, Animation animation) {
        this.tasks.forEach(configuredTask -> {
            if (n == configuredTask.getDelay()) {
                configuredTask.run(animation);
            }
        });
    }

    public boolean shouldStopAnimation(int n) {
        return n >= this.length;
    }

    public boolean setPumpkinHelmet() {
        return this.setPumpkinHelmet;
    }

    public void removeAnimation(Player player) {
        this.animations.remove(player);
    }

    public void addAnimation(Player player, Animation animation) {
        this.animations.put(player, animation);
    }

    public Crate getCrate() {
        return this.crate;
    }

    public boolean canBeOpened(Player player) {
        if (this.type == Type.PLACEDCRATE) {
            if (!this.animations.isEmpty()) {
                Messages.OPEN_ALREADY_OPENING.send((CommandSender)player);
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean isAnyoneOpening() {
        return !this.animations.isEmpty();
    }

    public List<BossBar> showTitle(AnimationTitle animationTitle, Player player) {
        List<BossBar> list = animationTitle.create();
        for (BossBar bossBar2 : list) {
            Reroll reroll = Reroll.get(player);
            if (reroll == null) continue;
            bossBar2.setTitle(bossBar2.getTitle().replace("%rerolls-available%", "" + (this.crate.getRerollManager().getPlayerLimit(player) - reroll.getReroll())));
        }
        if (this.bossBars.containsKey(player)) {
            this.hideTitle(player);
        }
        list.forEach(bossBar -> bossBar.addPlayer(player));
        this.bossBars.put(player, list);
        return list;
    }

    public void hideTitle(Player player) {
        if (!this.bossBars.containsKey(player)) {
            return;
        }
        this.bossBars.get(player).forEach(bossBar -> bossBar.removePlayer(player));
        this.bossBars.remove(player);
    }

    public AnimationTitle getOpeningTitle() {
        return this.openingTitle;
    }

    public AnimationTitle getRerollingTitle() {
        return this.rerollingTitle;
    }

    public Location getCameraLocation() {
        return this.cameraLocation;
    }

    public Location getModelLocation() {
        return this.modelLocation;
    }

    public Animation getAnimation(Player player) {
        return this.animations.get(player);
    }

    public boolean isSkippable() {
        return this.skippable;
    }

    public boolean isInAnimation(Player player) {
        return this.animations.containsKey(player);
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public PreOpenTitle getPreOpenTitle() {
        return this.preOpenTitle;
    }

    public boolean skipAnimation(Player player) {
        Animation animation = this.getAnimation(player);
        if (animation == null) {
            return false;
        }
        if (!this.isSkippable()) {
            return false;
        }
        if (!animation.isStarted()) {
            return false;
        }
        animation.reroll();
        return true;
    }

    public boolean forceSkipAnimation(Player player) {
        Animation animation = this.getAnimation(player);
        if (animation == null) {
            return false;
        }
        animation.reroll();
        return true;
    }

    public static enum Type {
        INSTANT,
        PLACEDCRATE,
        PLACEDCRATE_PERSONALISED,
        CINEMATIC;

    }
}

