/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.animation.AnimationManager;
import cz.larkyy.aquaticcratestesting.api.AquaticCratesAPI;
import cz.larkyy.aquaticcratestesting.api.events.ClaimRewardEvent;
import cz.larkyy.aquaticcratestesting.api.events.CrateOpenEvent;
import cz.larkyy.aquaticcratestesting.api.events.KeyUseEvent;
import cz.larkyy.aquaticcratestesting.crate.CrateBase;
import cz.larkyy.aquaticcratestesting.crate.Key;
import cz.larkyy.aquaticcratestesting.crate.PlacedCrate;
import cz.larkyy.aquaticcratestesting.crate.inventories.PreviewGUI;
import cz.larkyy.aquaticcratestesting.crate.inventories.RerollGUI;
import cz.larkyy.aquaticcratestesting.crate.milestone.Milestone;
import cz.larkyy.aquaticcratestesting.crate.milestone.MilestoneHandler;
import cz.larkyy.aquaticcratestesting.crate.model.ModelSettings;
import cz.larkyy.aquaticcratestesting.crate.price.PriceHandler;
import cz.larkyy.aquaticcratestesting.crate.reroll.RerollManager;
import cz.larkyy.aquaticcratestesting.crate.reroll.impl.MenuReroll;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.messages.Messages;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import cz.larkyy.aquaticcratestesting.utils.IReward;
import cz.larkyy.aquaticcratestesting.utils.RewardUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import xyz.larkyy.itemlibrary.CustomItem;

public class Crate
extends CrateBase {
    private static final NamespacedKey KEY = new NamespacedKey((Plugin)AquaticCratesTesting.instance(), "CrateIdentifier");
    private final Key key;
    private final List<Reward> rewards;
    private final AtomicReference<PreviewGUI> previewGUI;
    private final AtomicReference<RerollGUI> rerollGUI;
    private final AtomicReference<RerollManager> rerollManager;
    private final AtomicReference<AnimationManager> animationManager;
    private final String permission;
    private final boolean instantWhileSneaking;
    private final PriceHandler priceHandler;
    private final MilestoneHandler milestoneHandler;

    public Crate(String string, String string2, CustomItem customItem, ModelSettings modelSettings, List<Reward> list, boolean bl, AtomicReference<PreviewGUI> atomicReference, AtomicReference<RerollGUI> atomicReference2, AtomicReference<RerollManager> atomicReference3, AtomicReference<AnimationManager> atomicReference4, List<String> list2, double d, String string3, boolean bl2, PriceHandler priceHandler, TreeMap<Integer, Milestone> treeMap, HashMap<Integer, Milestone> hashMap, int n, int n2) {
        super(string, string2, modelSettings, list2, d, n, n2);
        this.key = new Key(customItem, this, bl);
        this.rewards = list;
        this.previewGUI = atomicReference;
        this.rerollGUI = atomicReference2;
        this.rerollManager = atomicReference3;
        this.animationManager = atomicReference4;
        this.permission = string3;
        this.instantWhileSneaking = bl2;
        this.priceHandler = priceHandler;
        this.milestoneHandler = new MilestoneHandler(this, treeMap, hashMap);
    }

    public MilestoneHandler getMilestoneHandler() {
        return this.milestoneHandler;
    }

    public PriceHandler getPriceHandler() {
        return this.priceHandler;
    }

    public void openPreview(Player player, PlacedCrate placedCrate) {
        if (AquaticCratesTesting.getCrateHandler().isInAnimation(player)) {
            return;
        }
        PreviewGUI previewGUI = this.previewGUI.get();
        if (previewGUI == null) {
            return;
        }
        if (placedCrate == null && !previewGUI.isOpenableByKey()) {
            return;
        }
        previewGUI.open(player, 0, placedCrate);
    }

    public void openRerollGUI(MenuReroll menuReroll) {
        RerollGUI rerollGUI = this.rerollGUI.get();
        if (rerollGUI == null) {
            return;
        }
        rerollGUI.open(menuReroll);
    }

    public PreviewGUI getPreviewGUI() {
        return this.previewGUI.get();
    }

    public Key getKey() {
        return this.key;
    }

    public void giveKey(Player player, int n, boolean bl) {
        if (bl) {
            CratePlayer cratePlayer = CratePlayer.get(player);
            cratePlayer.addKeys(this.getIdentifier(), n);
        } else {
            this.key.give(Collections.singletonList(player), n);
        }
    }

    public void giveCrate(Player player) {
        ItemStack itemStack = new ItemStack(Material.CHEST);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName("\u00a7fCrate: " + this.getIdentifier());
        itemMeta.getPersistentDataContainer().set(KEY, PersistentDataType.STRING, (Object)this.getIdentifier());
        itemStack.setItemMeta(itemMeta);
        player.getInventory().addItem(new ItemStack[]{itemStack});
    }

    public void giveKeyAll(int n, boolean bl) {
        if (bl) {
            AquaticCratesAPI.getPlayerHandler().loadPlayers(() -> {});
            AquaticCratesAPI.getPlayerHandler().getPlayers().forEach(cratePlayer -> cratePlayer.addKeys(this.getIdentifier(), n));
        } else {
            this.key.give(new ArrayList<Player>(Bukkit.getOnlinePlayers()), n);
        }
    }

    public void open(CratePlayer cratePlayer, PlacedCrate placedCrate, boolean bl) {
        this.open(cratePlayer, placedCrate, bl, true);
    }

    public void open(CratePlayer cratePlayer, PlacedCrate placedCrate, boolean bl, boolean bl2) {
        AtomicReference<Reward> atomicReference;
        Object object;
        if (AquaticCratesAPI.getCrateHandler().isInAnimation(cratePlayer.getPlayer())) {
            return;
        }
        if (this.permission != null && !cratePlayer.getPlayer().hasPermission(this.permission)) {
            Messages.CRATE_NO_PERMISSION.send((CommandSender)cratePlayer.getPlayer());
            return;
        }
        if (!this.animationManager.get().canBeOpened(cratePlayer.getPlayer())) {
            return;
        }
        if (bl2) {
            object = this.priceHandler.chooseGroup(cratePlayer.getPlayer(), this);
            if (object == null) {
                Messages.DO_NOT_HAVE_KEY.send((CommandSender)cratePlayer.getPlayer());
                return;
            }
            if (!object.has(cratePlayer.getPlayer(), this)) {
                Messages.DO_NOT_HAVE_KEY.send((CommandSender)cratePlayer.getPlayer());
                return;
            }
            atomicReference = new AtomicReference<Reward>(this.getRandomReward(cratePlayer.getPlayer()));
            if (atomicReference.get() == null) {
                Messages.NO_REWARD_AVAILABLE.send((CommandSender)cratePlayer.getPlayer());
                return;
            }
            object.take(cratePlayer.getPlayer(), this);
        } else {
            object = new KeyUseEvent(cratePlayer.getPlayer(), this, KeyUseEvent.KeyType.NONE, null);
            Bukkit.getPluginManager().callEvent((Event)object);
            atomicReference = new AtomicReference<Reward>(this.getRandomReward(cratePlayer.getPlayer()));
            if (atomicReference.get() == null) {
                Messages.NO_REWARD_AVAILABLE.send((CommandSender)cratePlayer.getPlayer());
                return;
            }
        }
        object = new CrateOpenEvent(cratePlayer.getPlayer(), this);
        if (bl && this.instantWhileSneaking) {
            ClaimRewardEvent claimRewardEvent = new ClaimRewardEvent(cratePlayer.getPlayer(), atomicReference.get(), this);
            this.milestoneHandler.increaseAmt(cratePlayer.getPlayer());
            Bukkit.getServer().getPluginManager().callEvent((Event)claimRewardEvent);
            atomicReference.get().give(cratePlayer.getPlayer());
        } else {
            this.animationManager.get().open(cratePlayer.getPlayer(), atomicReference, placedCrate, animation -> {
                if (this.rerollManager.get().setRerolling(cratePlayer.getPlayer(), atomicReference, reward -> {
                    this.animationManager.get().hideTitle(cratePlayer.getPlayer());
                    ClaimRewardEvent claimRewardEvent = new ClaimRewardEvent(cratePlayer.getPlayer(), (Reward)reward, this);
                    Bukkit.getServer().getPluginManager().callEvent((Event)claimRewardEvent);
                    this.milestoneHandler.increaseAmt(cratePlayer.getPlayer());
                    reward.give(cratePlayer.getPlayer());
                    this.animationManager.get().removeAnimation(cratePlayer.getPlayer());
                    animation.end();
                }, reward -> {
                    this.animationManager.get().hideTitle(cratePlayer.getPlayer());
                    atomicReference.set(this.getRandomReward(cratePlayer.getPlayer()));
                    animation.start();
                })) {
                    this.animationManager.get().showTitle(this.animationManager.get().getRerollingTitle(), cratePlayer.getPlayer());
                }
            });
        }
        Bukkit.getPluginManager().callEvent((Event)object);
    }

    public Reward getRandomReward(Player player) {
        List<IReward> list = RewardUtils.getPossibleRewards(player, this.rewards, this);
        return (Reward)RewardUtils.getRandomReward(list, null);
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public PlacedCrate spawn(Location location) {
        return AquaticCratesAPI.getCrateHandler().spawnCrate(location, this);
    }

    public List<Reward> getPossibleRewards(Player player) {
        return RewardUtils.getPossibleRewards(player, this.rewards, this).stream().map(iReward -> (Reward)iReward).toList();
    }

    public RerollManager getRerollManager() {
        return this.rerollManager.get();
    }

    public static Crate get(String string) {
        return AquaticCratesAPI.getCrate(string);
    }

    public static Crate get(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        String string = (String)itemMeta.getPersistentDataContainer().get(KEY, PersistentDataType.STRING);
        if (string == null) {
            return null;
        }
        return Crate.get(string);
    }

    public AtomicReference<AnimationManager> getAnimationManager() {
        return this.animationManager;
    }
}

