/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.api.event;

import java.util.UUID;
import kotlin.Metadata;
import kotlin1520.jvm.internal.Intrinsics;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.jetbrains.annotations.NotNull;
import org.serverct.ersha.AttributePlus;
import org.serverct.ersha.api.enums.AttributeName;
import org.serverct.ersha.api.event.impl.EventImpl;
import org.serverct.ersha.attribute.data.AttributeData;
import org.serverct.ersha.manager.AttributeManager;
import org.serverct.ersha.manager.data.ConfigurationManager;
import org.serverct.ersha.taboolib.module.nms.MinecraftVersion;
import org.serverct.ersha.tool.Tools;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000eR\u001a\u0010\u0014\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/serverct/ersha/api/event/AttrShootBowEvent;", "Lorg/serverct/ersha/api/event/impl/EventImpl;", "evt", "Lorg/bukkit/event/entity/EntityShootBowEvent;", "(Lorg/bukkit/event/entity/EntityShootBowEvent;)V", "arrow", "Lorg/bukkit/entity/Arrow;", "getArrow", "()Lorg/bukkit/entity/Arrow;", "force", "", "getForce", "()F", "setForce", "(F)V", "options", "Lorg/serverct/ersha/manager/data/ConfigurationManager;", "speed", "getSpeed", "setSpeed", "spread", "getSpread", "setSpread", "autoHandle", "", "setCancelled", "value", "", "AttributePlus"})
public final class AttrShootBowEvent
extends EventImpl<AttrShootBowEvent> {
    @NotNull
    private final EntityShootBowEvent evt;
    @NotNull
    private final ConfigurationManager options;
    @NotNull
    private final Arrow arrow;
    private float force;
    private float speed;
    private float spread;

    public AttrShootBowEvent(@NotNull EntityShootBowEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.evt = evt;
        this.options = AttributePlus.INSTANCE.getConfigurationManager();
        Entity entity = this.evt.getProjectile();
        if (entity == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bukkit.entity.Arrow");
        }
        this.arrow = (Arrow)entity;
        this.force = this.options.getForceSetting() ? this.evt.getForce() : 1.0f;
        this.speed = (float)this.options.getSpeedSetting();
        this.spread = (float)this.options.getSpreadSetting();
    }

    @NotNull
    public final Arrow getArrow() {
        return this.arrow;
    }

    public final float getForce() {
        return this.force;
    }

    public final void setForce(float f) {
        this.force = f;
    }

    public final float getSpeed() {
        return this.speed;
    }

    public final void setSpeed(float f) {
        this.speed = f;
    }

    public final float getSpread() {
        return this.spread;
    }

    public final void setSpread(float f) {
        this.spread = f;
    }

    @Override
    public void setCancelled(boolean value2) {
        this.setCancelled(value2);
        this.evt.setCancelled(value2);
    }

    public final void autoHandle() {
        double through;
        AttributeManager attributeManager = AttributePlus.INSTANCE.getAttributeManager();
        UUID uUID = this.evt.getEntity().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"evt.entity.uniqueId");
        UUID uUID2 = uUID;
        uUID = this.evt.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"evt.entity");
        AttributeData attackerData = attributeManager.getAttributeData(uUID2, (LivingEntity)uUID);
        this.speed += attackerData.getRandomValue(AttributeName.SHOOT_SPEED.toServerName()).floatValue() / (float)100;
        this.spread += attackerData.getRandomValue(AttributeName.SHOOT_SPREAD.toServerName()).floatValue() / (float)100;
        if (this.options.getForceSetting()) {
            this.speed = this.speed * this.force / 1.0f;
            this.spread = this.spread * this.force / 1.0f;
        }
        if (MinecraftVersion.INSTANCE.getMajor() >= 6 && this.options.getThroughSetting() && Tools.INSTANCE.chance(through = attackerData.getRandomValue(AttributeName.SHOOT_THROUGH.toServerName()).doubleValue())) {
            ((AbstractArrow)this.arrow).setPierceLevel(this.options.getThroughAmount());
        }
    }
}

