/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.attribute.persistent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin1520.collections.CollectionsKt;
import kotlin1520.jvm.internal.DefaultConstructorMarker;
import kotlin1520.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.serverct.ersha.AttributePlus;
import org.serverct.ersha.attribute.data.AttributeData;
import org.serverct.ersha.attribute.data.AttributeSource;
import org.serverct.ersha.manager.database.FunctionKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020\u0005J\u0014\u0010\r\u001a\u00020\u001c2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050#J\u000e\u0010\u0017\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u001cH\u0002J\u000e\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0007R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lorg/serverct/ersha/attribute/persistent/AttributePersistentSource;", "", "data", "Lorg/serverct/ersha/attribute/data/AttributeData;", "source", "", "date", "", "(Lorg/serverct/ersha/attribute/data/AttributeData;Ljava/lang/String;J)V", "attribute", "Lorg/serverct/ersha/attribute/data/AttributeSource;", "getAttribute", "()Lorg/serverct/ersha/attribute/data/AttributeSource;", "setAttribute", "(Lorg/serverct/ersha/attribute/data/AttributeSource;)V", "attributes", "", "changedState", "", "getData", "()Lorg/serverct/ersha/attribute/data/AttributeData;", "getDate", "()J", "setDate", "(J)V", "getSource", "()Ljava/lang/String;", "addAttribute", "", "deleteSource", "player", "Lorg/bukkit/entity/Player;", "fromJsonContent", "content", "saveToString", "", "time", "", "updateSource", "updateToPlayer", "current", "AttributePlus"})
public final class AttributePersistentSource {
    @NotNull
    private final AttributeData data;
    @NotNull
    private final String source;
    private long date;
    private boolean changedState;
    @Nullable
    private AttributeSource attribute;
    @NotNull
    private List<String> attributes;

    public AttributePersistentSource(@NotNull AttributeData data, @NotNull String source2, long date) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this.data = data;
        this.source = source2;
        this.date = date;
        this.changedState = true;
        boolean bl = false;
        this.attributes = new ArrayList();
    }

    public /* synthetic */ AttributePersistentSource(AttributeData attributeData, String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = -1L;
        }
        this(attributeData, string, l);
    }

    @NotNull
    public final AttributeData getData() {
        return this.data;
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    public final long getDate() {
        return this.date;
    }

    public final void setDate(long l) {
        this.date = l;
    }

    @Nullable
    public final AttributeSource getAttribute() {
        return this.attribute;
    }

    public final void setAttribute(@Nullable AttributeSource attributeSource) {
        this.attribute = attributeSource;
    }

    public final void setDate(double time2) {
        this.date = (long)((double)System.currentTimeMillis() + (double)1000L * time2);
        this.changedState = true;
    }

    public final void setAttribute(@NotNull List<String> attributes2) {
        Intrinsics.checkNotNullParameter(attributes2, (String)"attributes");
        this.attributes = CollectionsKt.toMutableList((Collection)attributes2);
        this.changedState = true;
        this.updateSource();
        FunctionKt.getDatabase().savePersistentSource(this.data.getPlayer(), this);
    }

    public final void addAttribute(@NotNull String attribute2) {
        Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
        this.attributes.add(attribute2);
        this.changedState = true;
        this.updateSource();
        FunctionKt.getDatabase().savePersistentSource(this.data.getPlayer(), this);
    }

    public final boolean updateToPlayer(long current) {
        if (this.date != -1L && current >= this.date) {
            return false;
        }
        if (this.changedState) {
            this.changedState = false;
            if (this.attribute != null) {
                AttributeData.operationApiAttribute$default(this.data, this.source, this.attribute, AttributeSource.OperationType.ADD, false, 8, null);
            }
        }
        return true;
    }

    private final void updateSource() {
        Collection collection = this.attributes;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.attribute = new AttributeSource(this.attributes, null, 2, null);
            this.changedState = true;
        }
    }

    public final void deleteSource(@NotNull Player player) {
        HashMap<String, AttributePersistentSource> hashMap;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.data.takeApiAttribute(this.source);
        String[] stringArray = this.data.getPersistent();
        if (stringArray != null && (hashMap = stringArray.getPersistent()) != null) {
            hashMap.remove(this.source);
        }
        stringArray = new String[]{this.source};
        FunctionKt.getDatabase().deletePersistentSource(player, stringArray);
    }

    @NotNull
    public final AttributePersistentSource fromJsonContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object object = AttributePlus.INSTANCE.getGson().fromJson(content, this.attributes.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(content, attributes::class.java)");
        this.attributes = (List)object;
        this.updateSource();
        return this;
    }

    @NotNull
    public final String saveToString() {
        String string = AttributePlus.INSTANCE.getGson().toJson(this.attributes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(attributes)");
        return string;
    }
}

