/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.core.rewards;

import java.util.List;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.rewards.BSRewardType;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.external.BungeeCordManager;
import org.black_ixx.bossshop.managers.misc.InputReader;
import org.black_ixx.bossshop.managers.misc.StringManipulationLib;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class BSRewardTypeBungeeCordCommand
extends BSRewardType {
    @Override
    public Object createObject(Object o, boolean force_final_state) {
        return InputReader.readStringList(o);
    }

    @Override
    public boolean validityCheck(String item_name, Object o) {
        if (o != null) {
            return true;
        }
        ClassManager.manager.getBugFinder().severe("Was not able to create ShopItem " + item_name + "! The reward object needs to be a list of commands (text lines).");
        return false;
    }

    @Override
    public void enableType() {
        ClassManager.manager.getSettings().setBungeeCordServerEnabled(true);
    }

    @Override
    public boolean canBuy(Player p, BSBuy buy, boolean message_if_no_success, Object reward, ClickType clickType) {
        return true;
    }

    @Override
    public void giveReward(Player p, BSBuy buy, Object reward, ClickType clickType) {
        List commands = (List)reward;
        BungeeCordManager bc = ClassManager.manager.getBungeeCordManager();
        if (bc != null) {
            for (String s : commands) {
                bc.executeCommand(p, ClassManager.manager.getStringManager().transform(s, buy, buy.getShop(), null, p));
            }
        } else {
            ClassManager.manager.getBugFinder().severe("Was not able to execute BungeeCord commands: The BungeeCordManager was not enabled properly.");
        }
    }

    @Override
    public String getDisplayReward(Player p, BSBuy buy, Object reward, ClickType clickType) {
        List commands = (List)reward;
        String commands_formatted = StringManipulationLib.formatList(commands);
        return ClassManager.manager.getMessageHandler().get("Display.BungeeCordCommand").replace("%commands%", commands_formatted);
    }

    @Override
    public String[] createNames() {
        return new String[]{"bungeecordcommand", "bungeecordcommands", "bccommand", "bccommands"};
    }

    @Override
    public boolean mightNeedShopUpdate() {
        return true;
    }
}

