/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.listeners;

import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.features.PlayerDataHandler;
import org.black_ixx.bossshop.misc.userinput.BSChatUserInput;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final BossShop plugin;

    public PlayerListener(BossShop plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void shopCommand(PlayerCommandPreprocessEvent e) {
        if (!e.isCancelled() && this.plugin.getClassManager().getSettings().getShopCommandsEnabled()) {
            BSShop shop;
            Player p = e.getPlayer();
            String cmd = e.getMessage().substring(1);
            if (this.plugin.getClassManager().getShops() != null && (shop = this.plugin.getClassManager().getShops().getShopByCommand(cmd)) != null) {
                if (p.hasPermission("BossShop.open") || p.hasPermission("BossShop.open.command") || p.hasPermission("BossShop.open.command." + shop.getShopName())) {
                    ClassManager.manager.getShops().openShop(p, shop);
                } else {
                    ClassManager.manager.getMessageHandler().sendMessage("Main.NoPermission", (CommandSender)p);
                }
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void chat(AsyncPlayerChatEvent e) {
        PlayerDataHandler h;
        BSChatUserInput i;
        if (ClassManager.manager.getPlayerDataHandler() != null && (i = (h = ClassManager.manager.getPlayerDataHandler()).getInputRequest(e.getPlayer())) != null) {
            if (i.isUpToDate()) {
                i.input(e.getPlayer(), e.getMessage());
                e.setCancelled(true);
            }
            h.removeInputRequest(e.getPlayer());
        }
    }

    @EventHandler
    public void quitServer(PlayerQuitEvent event) {
        this.leave(event.getPlayer());
    }

    @EventHandler
    public void kickedOffServer(PlayerKickEvent event) {
        this.leave(event.getPlayer());
    }

    public void leave(Player p) {
        if (ClassManager.manager.getPlayerDataHandler() != null) {
            ClassManager.manager.getPlayerDataHandler().leftServer(p);
        }
    }
}

